/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.IdpBrowserSso;
import com.pingidentity.admin.api.model.IdpBrowserSsoAttributeContract;
import com.pingidentity.admin.api.model.IdpConnection;
import com.pingidentity.admin.api.model.Protocol;
import com.pingidentity.admin.api.validator.SpAdapterMappingsValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.IdpConnectionAttributeContractTranslator;
import com.pingidentity.pf.admin.rest.translator.SpAdapterMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.TargetAttributeMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SpAdapterToConnectionDependencyErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private static final SpAdapterMappingTranslator mappingTranslator = new SpAdapterMappingTranslator(new ValidatorContext());
    private static final IdpConnectionAttributeContractTranslator idpAttributeContractTranslator = new IdpConnectionAttributeContractTranslator();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (!(causedByItem instanceof AuthnAdapterInstance)) {
            return;
        }
        AuthnAdapterInstance adapter = (AuthnAdapterInstance)causedByItem;
        Collection connections = connectionManager.getAllIdpConnections();
        for (org.sourceid.saml20.domain.IdpConnection idpConnection : connections) {
            for (TargetAttributeMapping mapping : idpConnection.getTargetAttributeMappings()) {
                if (!mapping.getAdapterInstanceId().equals(adapter.getId()) && (mapping.getConnectionOverrideInstance() == null || !mapping.getConnectionOverrideInstance().getParentId().equals(adapter.getId()))) continue;
                IdpConnection apiConn = new IdpConnection();
                IdpBrowserSso browserSso = new IdpBrowserSso();
                browserSso.setAttributeContract(new IdpBrowserSsoAttributeContract());
                apiConn.setIdpBrowserSso(browserSso);
                idpAttributeContractTranslator.domainToApi(idpConnection, apiConn.getIdpBrowserSso().getAttributeContract());
                Protocol protocol = Protocol.valueOf((String)idpConnection.getProtocol().name());
                browserSso.setProtocol(protocol);
                mappingTranslator.domainToApi(Arrays.asList(mapping), apiConn.getIdpBrowserSso().getAdapterMappings());
                SpAdapterMappingsValidator mappingValidator = new SpAdapterMappingsValidator(apiConn.getIdpBrowserSso(), Collections.emptyList(), new ValidatorContext());
                DependencyError error = new DependencyError(idpConnection.getId(), DependencyType.SP_ADAPTER, adapter.getId(), AffectedItemType.IDP_CONN);
                if (mappingValidator.validate()) {
                    existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    continue;
                }
                if (existingErrors.contains(error)) continue;
                existingErrors.add(error);
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }
}

