/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.ApiUtil;
import com.pingidentity.admin.api.model.TokenToTokenMapping;
import com.pingidentity.admin.api.validator.TokenToTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.TokenToTokenMappingTranslator;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.Collection;
import org.sourceid.a2a.domain.Token2TokenMapping;
import org.sourceid.a2a.domain.mgmt.Token2TokenManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenGeneratorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;

public class TokenGeneratorsToTokenTranslatorMappingsValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final Token2TokenManager token2TokenManager = MgmtFactory.getToken2TokenManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        String id = "";
        DependencyType type = null;
        if (causedByItem instanceof TokenProcessorInstance) {
            TokenProcessorInstance tokenProcessor = (TokenProcessorInstance)causedByItem;
            id = tokenProcessor.getId();
            type = DependencyType.TOKEN_PROCESSOR;
        } else if (causedByItem instanceof TokenGeneratorInstance) {
            TokenGeneratorInstance tokenGenerator = (TokenGeneratorInstance)causedByItem;
            id = tokenGenerator.getId();
            type = DependencyType.TOKEN_GENERATOR;
        }
        for (Token2TokenMapping mapping : token2TokenManager.getMappings()) {
            if ((type != DependencyType.TOKEN_PROCESSOR || !mapping.getSourceId().equals(id)) && (type != DependencyType.TOKEN_GENERATOR || !mapping.getTargetId().equals(id))) continue;
            TokenToTokenMappingTranslator translator = new TokenToTokenMappingTranslator();
            TokenToTokenMapping apiMapping = TokenToTokenMappingTranslator.domainToApi((Token2TokenMapping)mapping);
            TokenToTokenMappingTranslator.cleanupContractFulfillmentMapping((TokenToTokenMapping)apiMapping);
            TokenToTokenMappingValidator tokenToTokenMappingValidator = new TokenToTokenMappingValidator(apiMapping, token2TokenManager, MgmtFactory.getTokenProcessorManager(), MgmtFactory.getTokenGeneratorManager(), new ValidatorContext(true, this.isEaAdmin(), true));
            String mappingId = ApiUtil.combineId((String)mapping.getSourceId(), (String)mapping.getTargetId());
            DependencyError error = new DependencyError(mappingId, type, id, AffectedItemType.TOKEN_TRANSLATOR_MAPPING);
            if (tokenToTokenMappingValidator.validate()) {
                existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                continue;
            }
            if (existingErrors.contains(error)) continue;
            existingErrors.add(error);
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

