/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.dependency.error.validator.impl.AttrMappingDependencyUtil;
import com.pingidentity.fsm.state.impl.OAuthMetadataUtil;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import java.util.Collection;
import java.util.Set;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class TokenProcessorPolicyDepErrorValidator
extends DependencyErrorValidatorImpl {
    private final TokenExchangeProcessorPolicyManager teppManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        this.checkAttributeMapping(causedByItem, existingErrors);
    }

    private void checkAttributeMapping(Object causedByItem, Collection<DependencyError> existingErrors) {
        if (!(causedByItem instanceof ClientSetting)) {
            return;
        }
        ClientSetting clientSetting = (ClientSetting)causedByItem;
        Set<String> extendedProps = OAuthMetadataUtil.getExtendedClientMetadataParamsWithPrefix(clientSetting);
        AttrMappingDependencyUtil.clearDependencyErrorForAffectedType(existingErrors, AffectedItemType.TEPP, DependencyType.OAUTH_CLIENT_SETTINGS);
        this.teppManager.getTokenExchangeProcessorPolicies().getPolicies().values().forEach(policy -> policy.getTokenExchangeProcessorMappings().values().forEach(mapping -> {
            if (AttrMappingDependencyUtil.checkDependencyErrorForContractFulfillment(existingErrors, extendedProps, mapping.getAttributeMapping().getAttributeMapping(), AffectedItemType.TEPP, policy.getId())) {
                return;
            }
            if (AttrMappingDependencyUtil.checkDependencyErrorForIssuanceCriteria(existingErrors, extendedProps, mapping.getAttributeMapping().getTokenAuthorizationIssuanceCriteria(), AffectedItemType.TEPP, policy.getId())) {
                return;
            }
        }));
    }

    @Override
    public boolean requiresConnectionValidation() {
        return false;
    }
}

