/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.dependency.error.validator.impl;

import com.pingidentity.admin.api.model.IdpTokenProcessorMapping;
import com.pingidentity.admin.api.model.SpConnection;
import com.pingidentity.admin.api.validator.IdpWsTrustTokenMappingValidator;
import com.pingidentity.dependency.error.AffectedItemType;
import com.pingidentity.dependency.error.DependencyErrorValidatorImpl;
import com.pingidentity.dependency.error.mgmt.DependencyError;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.pf.admin.rest.translator.SpWsTrustTranslator;
import java.util.Collection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;

public class TokenProcessorsToConnectionsDepErrorValidatorImpl
extends DependencyErrorValidatorImpl {
    private static final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();

    @Override
    public void getDependencyErrors(Object causedByItem, Collection<DependencyError> existingErrors) {
        TokenProcessorInstance tokenProcessor = (TokenProcessorInstance)causedByItem;
        for (org.sourceid.saml20.domain.SpConnection spConnection : connectionManager.getAllSpConnections()) {
            if (spConnection.getWsTrustSettings() == null || spConnection.getWsTrustSettings().getTokenToAssertionMappings() == null) continue;
            SpWsTrustTranslator wsTrustTranslator = new SpWsTrustTranslator();
            SpConnection apiConn = new SpConnection();
            wsTrustTranslator.domainToApi(spConnection, apiConn);
            int index = 0;
            for (IdpTokenProcessorMapping apiMapping : apiConn.getWsTrust().getTokenProcessorMappings()) {
                if (apiMapping.getIdpTokenProcessorRef().getId().equals(tokenProcessor.getId())) {
                    IdpWsTrustTokenMappingValidator validator = new IdpWsTrustTokenMappingValidator(apiMapping, index, apiConn.getWsTrust(), null);
                    DependencyError error = new DependencyError(spConnection.getId(), DependencyType.TOKEN_PROCESSOR, tokenProcessor.getId(), AffectedItemType.SP_CONN);
                    if (validator.validate()) {
                        existingErrors.removeIf(dependencyError -> dependencyError.equals((Object)error));
                    } else if (!existingErrors.contains(error)) {
                        existingErrors.add(error);
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public boolean requiresConnectionValidation() {
        return true;
    }
}

