/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.display.filter;

import com.pingidentity.display.filter.DisplayFilter;
import com.pingidentity.display.filter.DisplayMultiKey;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class BlockFilter
extends DisplayFilter {
    public static final String ITEMS_PER_PAGE_KEY = "ITEMS_PER_PAGE";
    public static final String ITEMS_PER_BLOCK_KEY = "ITEMS_PER_BLOCK_KEY";
    public static final String PAGE_KEY = "PAGE_KEY";
    public static final String BLOCK_KEY = "BLOCK_KEY";
    protected int itemsPerPage = 10;
    protected int itemsPerBlock = 5;
    protected int page = 1;
    protected int block = 1;

    public BlockFilter(DisplayFilter next) {
        super(next);
    }

    @Override
    protected void configureFilter(Properties props) {
        if (StringUtils.isNotBlank((String)props.getProperty(ITEMS_PER_PAGE_KEY))) {
            this.itemsPerPage = Integer.parseInt(props.getProperty(ITEMS_PER_PAGE_KEY));
        }
        if (StringUtils.isNotBlank((String)props.getProperty(ITEMS_PER_BLOCK_KEY))) {
            this.itemsPerBlock = Integer.parseInt(props.getProperty(ITEMS_PER_BLOCK_KEY));
        }
        this.page = Integer.parseInt(props.getProperty(PAGE_KEY));
        this.block = Integer.parseInt(props.getProperty(BLOCK_KEY));
    }

    @Override
    protected List<DisplayMultiKey> getFilteredResults(List<DisplayMultiKey> items) {
        if (items.isEmpty()) {
            return items;
        }
        List<DisplayMultiKey> itemsPerSelectedBlock = this.getSubListOfItems(items, this.itemsPerBlock * this.itemsPerPage, this.block);
        return itemsPerSelectedBlock;
    }

    protected List<DisplayMultiKey> getSubListOfItems(List<DisplayMultiKey> items, int itemsPerGrouping, int itemIndex) {
        int startIndex = (itemIndex - 1) * itemsPerGrouping;
        int endIndex = startIndex + itemsPerGrouping;
        int size = items.size();
        if (endIndex - (size - 1) > 0) {
            endIndex = size;
        }
        return items.subList(startIndex, endIndex);
    }
}

