/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.display.filter;

import com.pingidentity.display.filter.BasicSearchFilter;
import com.pingidentity.display.filter.DisplayFilter;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class StrictMatchingBasicSearchFilter
extends BasicSearchFilter {
    protected boolean hasWildcardPrefix;
    protected boolean hasWildcardSuffix;

    public StrictMatchingBasicSearchFilter(DisplayFilter next) {
        super(next);
    }

    @Override
    protected void configureFilter(Properties props) {
        this.isCaseSensitive = "true".equalsIgnoreCase(props.getProperty("IS_CASE_SENSITIVE_KEY", "false"));
        String queryToModify = props.getProperty("QUERY_KEY");
        this.queryTokens.clear();
        if (StringUtils.isNotBlank((String)queryToModify)) {
            this.hasWildcardPrefix = StringUtils.startsWith((String)queryToModify, (String)"*");
            if (this.hasWildcardPrefix) {
                queryToModify = StringUtils.stripStart((String)queryToModify, (String)"*");
            }
            this.hasWildcardSuffix = StringUtils.endsWith((String)queryToModify, (String)"*");
            if (this.hasWildcardSuffix) {
                queryToModify = StringUtils.stripEnd((String)queryToModify, (String)"*");
            }
            this.queryTokens.add(!this.isCaseSensitive ? queryToModify.toLowerCase() : queryToModify);
        }
    }

    @Override
    protected boolean itemMatchesQuery(String item) {
        String query = (String)this.queryTokens.get(0);
        if (this.hasWildcardPrefix && this.hasWildcardSuffix) {
            return item.contains(query);
        }
        if (this.hasWildcardPrefix && !this.hasWildcardSuffix) {
            return StringUtils.endsWith((String)item, (String)query);
        }
        if (!this.hasWildcardPrefix && this.hasWildcardSuffix) {
            return StringUtils.startsWith((String)item, (String)query);
        }
        return item.equals(query);
    }
}

