/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.filter;

import com.pingidentity.util.AdminBaseUrlUtil;
import com.pingidentity.util.ResponseModificationUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.servlet.filter.AbstractHttpFilter;

public class ServiceHandlingFilter
extends AbstractHttpFilter {
    private static final String SERVICE_QUERY = "service";
    private static final String API_TOKEN_REQ_PARAM = "apitoken";
    private static final String FINISH_SSO_REQ_PARAM = "finishsso";
    private static final String DIRECT_LOGIN_REQ_PARAM = "page/directLogin";
    private static final String TAPESTRY_SERVICE = "/render/pingfederate/app";

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (request != null) {
            String serviceData = request.getParameter(SERVICE_QUERY);
            if (API_TOKEN_REQ_PARAM.equals(serviceData)) {
                ResponseModificationUtil.setClearSiteDataHeaders(response);
                response.setContentType("application/json");
                response.setStatus(301);
            }
            if (FINISH_SSO_REQ_PARAM.equals(serviceData) || DIRECT_LOGIN_REQ_PARAM.equals(serviceData)) {
                String redirectUrl = ServiceHandlingFilter.getRedirectUrl(request);
                response.setStatus(307);
                response.setHeader("Location", redirectUrl);
            }
        }
    }

    private static String getRedirectUrl(HttpServletRequest request) {
        StringBuilder basePath = AdminBaseUrlUtil.getAdminBaseUrlFromServletRequest((HttpServletRequest)request);
        return basePath + "/render/pingfederate/app?" + request.getQueryString();
    }
}

