/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.helper;

import com.pingidentity.integrations.provisioner.pingidforworkforce.ProvisionerInformationKey;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.templates.connection.ConnectionTemplate;
import com.pingidentity.templates.connection.ConnectionTemplateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.Role;

public class ImportProvisioningConnectionHelper {
    public SpConnection createProvisioningConnection() {
        SimpleFieldList defaultFieldItems;
        String connectorTypeName = ProvisionerInformationKey.PROVISIONER_INFORMATION.getKey();
        ConnectionTemplateManager templateManager = new ConnectionTemplateManager();
        ConnectionTemplate template = templateManager.getConnectionTemplate(Role.SP, connectorTypeName);
        SpConnection templateConnection = null;
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin saasProvisioningPlugin = pluginManager.getPluginInstance(connectorTypeName);
        if (saasProvisioningPlugin != null && (templateConnection = (SpConnection)template.getConnection(defaultFieldItems = this.getFieldDescAsSimpleFieldList(template.getFieldDescriptors()))) != null) {
            templateConnection.setConnectionTargetType(connectorTypeName);
            HashMap<String, String> connectionTemplateProperties = new HashMap<String, String>();
            for (Field field : defaultFieldItems.getFields()) {
                connectionTemplateProperties.put(field.getName(), field.getValue());
            }
            templateConnection.setConnectionTemplateProperties(connectionTemplateProperties);
        }
        return templateConnection;
    }

    private SimpleFieldList getFieldDescAsSimpleFieldList(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (fieldDescriptors != null) {
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                Field field = new Field(fieldDescriptor.getName(), fieldDescriptor.getDefaultValue());
                fields.add(field);
            }
        }
        return new SimpleFieldList(fields);
    }
}

