/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.IWizardTransition;
import com.pingidentity.fsm.tasklet.GuiTimingLog;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Wizard
implements IWizard,
Serializable {
    private static final transient Log log = LogFactory.getLog(Wizard.class);
    protected boolean completed;
    private IWizardState sourceState;
    private IWizardState currentState;

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Override
    public IWizardState getSourceState() {
        return this.sourceState;
    }

    public void setSourceState(IWizardState sourceState) {
        this.sourceState = sourceState;
    }

    public void setCurrentState(IWizardState currentState) {
        this.currentState = currentState;
    }

    @Override
    public IWizardState getCurrentState() {
        return this.currentState;
    }

    @Override
    public IWizardState getStateByName(String name) {
        IWizardState sourceNode = this.getSourceState();
        if (sourceNode == null) {
            return null;
        }
        if (sourceNode.getStateName().equals(name)) {
            return sourceNode;
        }
        return Wizard.findNode(sourceNode, name);
    }

    @Override
    public boolean traverseForward() {
        long start = System.currentTimeMillis();
        boolean okay = this.currentState.onStateExit();
        GuiTimingLog.log(start, this.currentState, this, "onStateExit");
        if (!okay) {
            return false;
        }
        IWizardTransition outgoingTransition = this.currentState.getOutgoingTransition();
        if (outgoingTransition == null) {
            this.currentState.processState();
            return false;
        }
        IWizardState nextState = outgoingTransition.getTarget();
        if (nextState == null) {
            return false;
        }
        if (this.currentState.isCheckpoint()) {
            nextState.setIncomingTransition(null);
        } else {
            nextState.setIncomingTransition(outgoingTransition);
        }
        this.setCurrentState(nextState);
        start = System.currentTimeMillis();
        this.currentState.onStateActivated();
        GuiTimingLog.log(start, this.currentState, this, "onStateActivated");
        return true;
    }

    @Override
    public boolean traverseBackward() {
        IWizardTransition incomingTransition = this.currentState.getIncomingTransition();
        if (incomingTransition != null) {
            this.setCurrentState(incomingTransition.getSource());
            return true;
        }
        return false;
    }

    public static IWizardState findNode(IWizardState state, String name) {
        if (state == null || name == null) {
            return null;
        }
        IWizardTransition[] transitions = state.getOutgoingTransitions();
        if (transitions != null) {
            for (int i = 0; i < transitions.length; ++i) {
                IWizardState resultState;
                IWizardState probedState = transitions[i].getTarget();
                IWizardState iWizardState = resultState = name.equals(probedState.getStateName()) ? probedState : Wizard.findNode(probedState, name);
                if (resultState == null) continue;
                return resultState;
            }
        }
        return null;
    }
}

