/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.IWizardTransition;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class WizardState
implements IWizardState,
Serializable {
    private boolean checkpoint;
    protected String stateName;
    protected IWizard wizard;
    protected IWizardTransition incomingTransition;
    private ArrayList<IWizardTransition> outgoingTransitions = new ArrayList();

    @Override
    public boolean isCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(boolean checkpoint) {
        this.checkpoint = checkpoint;
    }

    @Override
    public String getStateName() {
        return this.stateName;
    }

    @Override
    public IWizard getWizard() {
        return this.wizard;
    }

    @Override
    public IWizardTransition getIncomingTransition() {
        return this.incomingTransition;
    }

    @Override
    public void setIncomingTransition(IWizardTransition value) {
        this.incomingTransition = value;
    }

    @Override
    public IWizardTransition[] getOutgoingTransitions() {
        return this.outgoingTransitions.toArray(new IWizardTransition[0]);
    }

    @Override
    public void addOutgoingTransition(IWizardTransition value) {
        this.outgoingTransitions.add(value);
        value.setSource(this);
    }

    public void clearOutgoingTransitions() {
        this.outgoingTransitions.clear();
    }

    @Override
    public IWizardTransition getOutgoingTransition() {
        IWizardTransition[] edges = this.getOutgoingTransitions();
        for (int i = 0; i < edges.length; ++i) {
            if (!edges[i].validate()) continue;
            return edges[i];
        }
        return null;
    }

    @Override
    public boolean isStateInPath() {
        return this == this.wizard.getCurrentState() || WizardState.checkTraverseBack(this.wizard.getCurrentState(), this);
    }

    public static boolean checkTraverseBack(IWizardState startState, IWizardState searchState) {
        IWizardTransition incomingEdge = startState.getIncomingTransition();
        if (incomingEdge == null) {
            return false;
        }
        IWizardState srcState = incomingEdge.getSource();
        return srcState == searchState ? true : WizardState.checkTraverseBack(srcState, searchState);
    }

    public WizardState(IWizard owner, String name) {
        this.wizard = owner;
        this.stateName = name;
    }
}

