/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.APCMappingTasklet;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.fragments.FragmentMappingTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceContextType;

public class APCAdapterContractMappingState
extends MappingState
implements Serializable {
    public APCAdapterContractMappingState(Tasklet value) {
        super(value, "mapping");
        this.setMenuName("Contract Fulfillment");
        this.model.setTargetName("Contract Fulfillment");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.attributeMapping = (AttributeMapping)dataFromDisk;
        super.populate(this.attributeMapping);
        this.model = new SAML2MappingModel("Contract Fulfillment", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping outmap = (AttributeMapping)dataToDisk;
        Map attrMap = this.model.getMapping().getAttributeMapping();
        outmap.setAttributeMap2(attrMap);
        return true;
    }

    @Override
    public void onStateActivated() {
        if (this.sources == null) {
            this.sources = new DataMap.Sources();
        }
        this.sources.reset();
        this.sources.addNoMappingSource("No Mapping");
        APCMappingTasklet apcMappingTasklet = this.findParent(APCMappingTasklet.class);
        apcMappingTasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        this.sources.addTextSource("Text");
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (expressionManager.isEvaluateExpressionsOn()) {
            this.sources.addExpressionSource("Expression");
        }
        HashMap<String, String> additionalValidValues = new HashMap<String, String>();
        additionalValidValues.put("TargetResource", "TargetResource");
        this.sources.setAdditionalValidValues(additionalValidValues);
        if (apcMappingTasklet instanceof FragmentMappingTasklet) {
            StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
            for (SourceContextType contextType : SourceContextType.getContextTypesForFragmentInputs()) {
                contextSelectionModel.add(contextType.getDescription(), contextType.getId());
                this.sources.addPropertySelectionSource("Context", "context", "Context", contextSelectionModel);
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return !this.model.isTestingExpression();
    }

    @Override
    public void reset() {
        this.sources = null;
        this.model = new SAML2MappingModel(this.getCurrentUser());
        this.model.setTargetName("Adapter Contract");
    }

    public Set<String> getTarget() {
        APCMappingTasklet parentTasklet = this.findParent(APCMappingTasklet.class);
        return new HashSet<String>(parentTasklet.getContractToFulfill());
    }
}

