/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.model.fieldpaths.oauth.ClientPaths;
import com.pingidentity.admin.api.validator.error.ValidationErrorFactory;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.RefreshTokenRollingIntervalHelper;

public abstract class AbstractOAuthClientRefreshRollingIntervalTaskletState
extends TaskletState {
    private String refreshRollingInterval = null;
    private String selectedRefreshRollingIntervalTimeUnit;
    private StringPairPropertySelectionModel refreshRollingIntervalTimeUnitList;
    private String refreshRollingIntervalType = "SERVER_DEFAULT";

    public AbstractOAuthClientRefreshRollingIntervalTaskletState(IWizard owner, String cardName) {
        super(owner, cardName);
    }

    public AbstractOAuthClientRefreshRollingIntervalTaskletState(IWizard owner) {
        super(owner);
    }

    protected abstract void fillDomainRefreshTokenRolling(Object var1);

    public void populateRefreshTokenRollingInterval(Long refreshRollingInterval, String selectedRefreshRollingIntervalTimeUnit) {
        this.refreshRollingInterval = refreshRollingInterval == null ? null : Long.toString(refreshRollingInterval);
        this.refreshRollingIntervalType = refreshRollingInterval == null ? "SERVER_DEFAULT" : "OVERRIDE_SERVER_DEFAULT";
        this.selectedRefreshRollingIntervalTimeUnit = selectedRefreshRollingIntervalTimeUnit == null ? "h" : selectedRefreshRollingIntervalTimeUnit;
    }

    public String getRefreshRollingInterval() {
        if (this.refreshRollingInterval != null) {
            return this.refreshRollingInterval;
        }
        return null;
    }

    public void setRefreshRollingInterval(String refreshRollingInterval) {
        this.refreshRollingInterval = "SERVER_DEFAULT".equals(this.refreshRollingIntervalType) || StringUtils.isEmpty((String)refreshRollingInterval) ? null : refreshRollingInterval;
    }

    public String getSelectedRefreshRollingIntervalTimeUnit() {
        return this.selectedRefreshRollingIntervalTimeUnit;
    }

    public void setSelectedRefreshRollingIntervalTimeUnit(String selectedRefreshRollingIntervalTimeUnit) {
        this.selectedRefreshRollingIntervalTimeUnit = selectedRefreshRollingIntervalTimeUnit;
    }

    public StringPairPropertySelectionModel getRefreshRollingIntervalTimeUnitList() {
        return this.refreshRollingIntervalTimeUnitList;
    }

    public void setRefreshRollingIntervalTimeUnitList(StringPairPropertySelectionModel refreshRollingIntervalTimeUnitList) {
        this.refreshRollingIntervalTimeUnitList = refreshRollingIntervalTimeUnitList;
    }

    public String getRefreshRollingIntervalType() {
        return this.refreshRollingIntervalType;
    }

    public void setRefreshRollingIntervalType(String refreshRollingIntervalType) {
        this.refreshRollingIntervalType = refreshRollingIntervalType;
        if ("SERVER_DEFAULT".equals(refreshRollingIntervalType)) {
            this.refreshRollingInterval = null;
        }
    }

    public boolean isDefaultRefreshRollingInterval() {
        return "SERVER_DEFAULT".equals(this.refreshRollingIntervalType);
    }

    protected boolean validateRefreshTokenIntervalNumber(IValidationDelegate delegate) {
        boolean validLong = false;
        if (this.getRefreshRollingInterval() == null) {
            validLong = true;
        } else if ("OVERRIDE_SERVER_DEFAULT".equals(this.getRefreshRollingIntervalType())) {
            try {
                Long.parseLong(this.getRefreshRollingInterval());
                validLong = true;
            }
            catch (NumberFormatException numberFormatException) {
                long maxRefreshTokenRollingInterval = RefreshTokenRollingIntervalHelper.getMaxIntervalForUnit((String)this.getSelectedRefreshRollingIntervalTimeUnit());
                this.recordErrors(Collections.singletonList(ValidationErrorFactory.getInstance().create((ApiMessageEnum)ApiMessageKey.oauth_client_mgmt_grant_refresh_token_rolling_interval, ClientPaths.getRefreshTokenRollingInterval(), new Object[]{0, maxRefreshTokenRollingInterval})), delegate);
            }
        }
        return validLong;
    }
}

