/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.state.impl.PolicyBranchUtil;
import com.pingidentity.fsm.state.impl.fragments.FragmentMappingTasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.fragments.PolicyFragmentTasklet;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;

public abstract class AbstractPolicyContractMappingTasklet
extends MappingTasklet
implements AttributeNamesApi {
    protected final transient MetadataDirectory metadataDir = MetaDataFactory.getMetadataDirectory();
    private Tree.Node<AsUiAction> selectedNode;

    public AbstractPolicyContractMappingTasklet(String taskletName, String menuName) {
        super(taskletName, menuName);
    }

    protected String getLabel(AsActionOption selectedOption) {
        switch (selectedOption.getType()) {
            case ADAPTER: {
                return " (" + selectedOption.getId() + ")";
            }
            case CONNECTION: {
                return " (" + this.metadataDir.getIdpConnectionBySystemId(selectedOption.getId(), true).getName() + ")";
            }
            case LOCAL_IDENTITY_PROFILE: {
                String lipName = MgmtFactory.getLocalIdentityProfileManager().getProfile(selectedOption.getId()).getName();
                return " (" + lipName + ")";
            }
            case FRAGMENT: {
                PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(selectedOption.getId());
                if (fragment == null) break;
                return " (" + fragment.getDisplayName() + ")";
            }
        }
        return null;
    }

    protected String getTypeLabel(AsActionOption.Type type) {
        switch (type) {
            case ADAPTER: {
                return "Adapter";
            }
            case CONNECTION: {
                return "IdP Connection";
            }
            case LOCAL_IDENTITY_PROFILE: {
                return "Local Identity";
            }
            case FRAGMENT: {
                return "Fragment";
            }
        }
        return "";
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        this.getUpstreamSources(sources);
        MappingTasklet parent = this.findParent(MappingTasklet.class);
        if (parent.isUseOtherValuesWithOneMapping()) {
            Map<AttributeSource, IPropertySelectionModel> dataStoreModels = parent.getIPropertySelectionModelsForAttributeSources();
            for (Map.Entry<AttributeSource, IPropertySelectionModel> modelEntry : dataStoreModels.entrySet()) {
                String selectionLabel = modelEntry.getKey().getType() + " (" + modelEntry.getKey().getDescription() + ")";
                sources.addPropertySelectionSource(modelEntry.getKey().getType(), modelEntry.getKey().getId(), selectionLabel, modelEntry.getValue());
            }
        }
        this.addTrackedParamsToSelectionSources(sources);
        this.addInputContractToSelectionSources(sources);
        if (!(this instanceof FragmentMappingTasklet)) {
            this.addExtendedPropertiesToSelectionSources(sources);
            this.addContextToSelectionSources(sources);
        }
    }

    public void addInputContractToSelectionSources(DataMap.Sources sources) {
        if (this.getParentTasklet() instanceof PolicyFragmentTasklet) {
            PolicyFragmentTasklet tasklet = (PolicyFragmentTasklet)this.getParentTasklet();
            C2cContract contract = MgmtFactory.getC2cContractManager().getContract(tasklet.getInputContractId());
            if (contract != null) {
                StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
                propSelectionModel.addAllStrings(contract.getAllAttrNamesSorted().toArray(new String[0]));
                sources.addPropertySelectionSource("Inputs", "inputs", "Inputs", propSelectionModel, "fragment.");
            }
        }
    }

    public void getUpstreamSources(DataMap.Sources sources) {
        for (Tree.Node currentNode = this.selectedNode; currentNode != null; currentNode = currentNode.getParent()) {
            Set<String> adapterOrConnectionAttributeContracts;
            AsActionOption selectedOption;
            PolicyBranchUtil branchUtil = new PolicyBranchUtil(currentNode);
            if (!branchUtil.isNodeAuthSourceSuccessBranch()) continue;
            AsActionOption asActionOption = selectedOption = currentNode.getParent() != null && currentNode.getParent().getData() != null ? ((AsUiAction)currentNode.getParent().getData()).getSelectedOption() : null;
            if (selectedOption == null || (adapterOrConnectionAttributeContracts = ((AsUiAction)currentNode.getData()).getState().getAttributeContractsMap().get(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), selectedOption.getType()))) == null) continue;
            String[] arr = new String[adapterOrConnectionAttributeContracts.size()];
            StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
            propSelectionModel.addAllStrings(adapterOrConnectionAttributeContracts.toArray(arr));
            propSelectionModel.sort();
            String selectionLabel = this.getTypeLabel(selectedOption.getType()) + this.getLabel(selectedOption);
            if (selectedOption.getType() == AsActionOption.Type.ADAPTER) {
                sources.addPropertySelectionSource("Adapter", selectedOption.getId(), selectionLabel, propSelectionModel, "ad.");
                continue;
            }
            if (selectedOption.getType() == AsActionOption.Type.CONNECTION) {
                sources.addPropertySelectionSource("IdP Connection", selectedOption.getId(), this.getConnectionEntityId(selectedOption.getId()), selectionLabel, propSelectionModel, "idp.");
                continue;
            }
            if (selectedOption.getType() != AsActionOption.Type.FRAGMENT || adapterOrConnectionAttributeContracts.size() <= 0) continue;
            sources.addPropertySelectionSource("Fragment", selectedOption.getId(), selectionLabel, propSelectionModel, "fragment.");
        }
    }

    private String getConnectionEntityId(String systemId) {
        IdpConnection conn = this.metadataDir.getIdpConnectionBySystemId(systemId, true);
        return conn.getEntityId();
    }

    public Tree.Node<AsUiAction> getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(Tree.Node<AsUiAction> selectedNode) {
        this.selectedNode = selectedNode;
    }

    @Override
    public void addExtendedPropertiesToSelectionSources(DataMap.Sources sources) {
        Map extendedPropertyMap = new ExtendedPropertyAccessor().getExtendedPropertyDefinitions();
        if (!extendedPropertyMap.isEmpty()) {
            StringPairPropertySelectionModel propSelectionModel = new StringPairPropertySelectionModel(true);
            for (Map.Entry entry : extendedPropertyMap.entrySet()) {
                String name = (String)entry.getKey();
                propSelectionModel.add(name, "extproperties." + name);
            }
            propSelectionModel.sort();
            sources.addPropertySelectionSource("Extended Properties", "extproperties", "Extended Properties", propSelectionModel);
        }
    }
}

