/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.pingidentity.access.ExtendedPropertyAccessor;
import com.pingidentity.admin.api.validator.IdValidator;
import com.pingidentity.authnselection.ApcMappingAction;
import com.pingidentity.authnselection.AttributeRule;
import com.pingidentity.authnselection.AuthnSelectionAction;
import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.AuthnSelectorAction;
import com.pingidentity.authnselection.AuthnSourceAction;
import com.pingidentity.authnselection.LocalIdentityMappingAction;
import com.pingidentity.authnselection.NoOpAction;
import com.pingidentity.authnselection.fragment.FragmentAction;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.authnselection.fragment.PolicyFragmentManager;
import com.pingidentity.authnselection.ui.AllChildrenCollapsedVisitor;
import com.pingidentity.authnselection.ui.AllChildrenExpandedVisitor;
import com.pingidentity.authnselection.ui.AsActionOption;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.authnselection.ui.FindDeletedPolicyNodesVisitor;
import com.pingidentity.authnselection.ui.FindInvalidAttributeSourcesVisitor;
import com.pingidentity.authnselection.ui.FindNodeByIdVisitor;
import com.pingidentity.authnselection.ui.FindNodesByIdsVisitor;
import com.pingidentity.authnselection.ui.FindNodesByTypeNodeVisitor;
import com.pingidentity.authnselection.ui.HasMissingOptionVisitor;
import com.pingidentity.authnselection.ui.ResyncSelectorResultsVisitor;
import com.pingidentity.authnselection.ui.UpdateSourceIdsVisitor;
import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.AuthenticationPoliciesUtil;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.APCMappingTasklet;
import com.pingidentity.fsm.state.impl.AttributeContractHolder;
import com.pingidentity.fsm.state.impl.LocalIdentityProfileMappingTasklet;
import com.pingidentity.fsm.state.impl.PolicyBranchUtil;
import com.pingidentity.fsm.state.impl.fragments.FragmentMappingTasklet;
import com.pingidentity.fsm.state.impl.fragments.PolicyFragmentState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityBranchUtil;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.AbstractPolicyTasklet;
import com.pingidentity.fsm.tasklet.impl.AuthnPoliciesTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import com.pingidentity.pingcommons.util.tree.PreOrderTraversal;
import com.pingidentity.pingcommons.util.tree.TraversalVisitor;
import com.pingidentity.pingcommons.util.tree.Tree;
import com.pingidentity.session.CopyAndPastePolicyManager;
import com.pingidentity.util.JsonUtil;
import com.pingidentity.util.TreeHelper;
import com.pingidentity.validator.PFValidationDelegate;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.ConditionType;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.mgmt.AuthnSelectorManager;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.IdpAdapterManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.IdpConnAuthnSourceKey;
import org.sourceid.websso.authn.AuthnPolicyUtil;

public abstract class AbstractPolicyState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private static final String ADAPTER_PREFIX = "Adapter";
    private static final String IDP_CONNECTION_PREFIX = "IdP Connection";
    private static final String FRAGMENT_PREFIX = "Fragment";
    private static final int MAX_LIST_SIZE = 3;
    private static final String USER_ID_CONTEXT = "userIdContext";
    public static final String RULES_CONTEXT = "rulesContext";
    private static final ObjectMapper objectMapper = JsonUtil.buildObjectMapper();
    private Map<String, Set<String>> attributeContractMap;
    protected Map<String, AsActionOption.Type> attributeContractIdType;
    private Map<String, AttributeRuleHolder> attributeRulesMap;
    protected Map<String, NameValuePair> idsToNamesMap;
    private Map<String, String> idsToExpressionIds;
    private List<String> nodeIdsWithError = new ArrayList<String>();
    private List<String> nodeIdsWithMappingErrors = new ArrayList<String>();
    private List<String> ruleNodeIdsWithError = new ArrayList<String>();
    private List<String> userIdNodesWithError = new ArrayList<String>();
    protected Map<String, List<String>> availableSourceIdsMap;
    private Map<String, AttributeContractHolder> inputUserIdMappings;
    private Map<String, List<String>> availableUpstreamAuthenticationSourcesMap;
    private Map<String, String> nodeIdToType;
    private Tree<AsUiAction> authnSelectionTree;
    private transient List<TreeHelper.NodeWrapper<AsUiAction>> authnSelectionList;
    private final transient IdpAdapterManager idpAdapterManager = MgmtFactory.getIdpAdapterManager();
    private final transient ConnectionManager connManager = MgmtFactory.getConnectionManager();
    private final transient C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private final transient PolicyFragmentManager policyFragmentManager = MgmtFactory.getPolicyFragmentManager();
    private final transient LocalIdentityManager localIdentityManager = MgmtFactory.getLocalIdentityProfileManager();
    private final transient AuthnSelectorManager selectorManager = MgmtFactory.getAuthnSelectorManager();
    private Map<String, String> conditionTypesMap;
    private Map<String, APCMappingTasklet> apcMappingTaskletMap;
    private Map<String, LocalIdentityProfileMappingTasklet> lipMappingTaskletMap;
    private Map<String, FragmentMappingTasklet> fragmentMappingTaskletMap;
    CopyAndPastePolicyManager copyAndPastePolicyManager = this.getVisit().getCopyAndPastePolicyManager();
    protected String typeString = "";
    protected String id;
    protected String name;
    protected String description;
    private boolean isSpEnabled = false;
    private boolean isIdpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableIdP();
    private Boolean showAdapterShortList;
    private Boolean showContractShortList;
    private Boolean showFragmentShortList;
    private Boolean showSelectorShortList;

    public AbstractPolicyState(IWizard owner) {
        super(owner);
        this.isSpEnabled = MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSP();
        this.attributeContractMap = this.getBaseAttributeContractsMap();
        this.attributeContractIdType = new HashMap<String, AsActionOption.Type>();
        this.attributeRulesMap = new HashMap<String, AttributeRuleHolder>();
        this.idsToNamesMap = this.getBaseIdToNamesMap();
        this.idsToExpressionIds = new HashMap<String, String>();
        this.conditionTypesMap = new LinkedHashMap<String, String>();
        this.apcMappingTaskletMap = new HashMap<String, APCMappingTasklet>();
        this.lipMappingTaskletMap = new HashMap<String, LocalIdentityProfileMappingTasklet>();
        this.fragmentMappingTaskletMap = new HashMap<String, FragmentMappingTasklet>();
        this.availableSourceIdsMap = new HashMap<String, List<String>>();
        this.availableUpstreamAuthenticationSourcesMap = new HashMap<String, List<String>>();
        for (ConditionType conditionType : ConditionType.values()) {
            this.conditionTypesMap.put(conditionType.name(), conditionType.getDescription());
        }
        this.inputUserIdMappings = new HashMap<String, AttributeContractHolder>();
        this.nodeIdToType = new HashMap<String, String>();
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        AsUiAction newAction = new AsUiAction(this, null);
        Tree newTree = new Tree((Object)newAction);
        newAction.setNode((Tree.Node<AsUiAction>)newTree.getRootNode());
        this.authnSelectionTree = newTree;
        this.id = this.generateId();
    }

    @Override
    public void populate(Object dataFromDisk) {
        Tree.Node rootNode = (Tree.Node)dataFromDisk;
        this.authnSelectionTree = this.buildUiTree((Tree.Node<AuthnSelectionAction>)rootNode);
        this.resyncSelectors();
        this.collapseAll();
    }

    @Override
    public void cancel(Object newData) {
        this.lipMappingTaskletMap.clear();
        this.apcMappingTaskletMap.clear();
        this.fragmentMappingTaskletMap.clear();
        super.cancel(newData);
    }

    private void resyncSelectors() {
        if (!MgmtFactory.getAuthnSelectorManager().getInstances().isEmpty()) {
            PreOrderTraversal preOrderTraversal = new PreOrderTraversal();
            ResyncSelectorResultsVisitor resyncVisitor = new ResyncSelectorResultsVisitor(this);
            preOrderTraversal.traverse(this.authnSelectionTree, (TraversalVisitor)resyncVisitor);
        }
    }

    private Tree<AsUiAction> buildUiTree(Tree.Node<AuthnSelectionAction> node) {
        AuthnSelectorManager authnSelectorMgr = MgmtFactory.getAuthnSelectorManager();
        Stack<Tree.Node> nodeStack = new Stack<Tree.Node>();
        Stack<Tree.Node> uiParentNodeStack = new Stack<Tree.Node>();
        Tree.Node uiRootNode = null;
        Tree.Node parentUiNode = null;
        boolean fallbackToSuccess = false;
        while (node != null) {
            List<AttributeRule> parentsAttributeRules;
            ArrayList<AttributeRule> attrRules = null;
            AttributeMapping attributeMapping = null;
            AuthnSelectionAction asAction = (AuthnSelectionAction)node.getData();
            Object selectedOption = null;
            String apcId = null;
            boolean selectedOptionInvalid = false;
            AttrMappingValue inputUserIdMapping = null;
            LocalIdentityMappingAction map2LipAction = null;
            boolean useridAuthenticated = false;
            AttributeMapping fragmentMapping = null;
            String fragmentOutboundApc = null;
            String fragmentId = null;
            if (asAction instanceof AuthnSelectorAction) {
                String selectorId = ((AuthnSelectorAction)asAction).getAuthnSelectorId();
                if (authnSelectorMgr.getInstance(selectorId) != null) {
                    selectedOption = new AsActionOption(selectorId, AsActionOption.Type.SELECTOR);
                } else {
                    selectedOptionInvalid = true;
                    selectedOption = null;
                }
            } else if (asAction instanceof AuthnSourceAction) {
                AsActionOption.Type optType;
                AuthnSourceAction authnSourceAction = (AuthnSourceAction)asAction;
                AuthnSourceKey authnSourceKey = authnSourceAction.getAuthnSourceKey();
                attrRules = new ArrayList<AttributeRule>();
                for (AttributeRule attrRule : authnSourceAction.getAttributeRules()) {
                    attrRules.add(attrRule.clone());
                }
                fallbackToSuccess = authnSourceAction.isFallbackToSuccess();
                inputUserIdMapping = authnSourceAction.getInputUserIdMapping();
                useridAuthenticated = authnSourceAction.isUserIdAuthenticated();
                if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.ADAPTER) {
                    optType = AsActionOption.Type.ADAPTER;
                } else if (authnSourceKey.getType() == AuthnSourceKey.AuthnSourceType.IDP_CONN) {
                    optType = AsActionOption.Type.CONNECTION;
                } else {
                    throw new IllegalStateException("unrecognized authn source type");
                }
                if (!((optType != AsActionOption.Type.ADAPTER || this.isIdpEnabled && this.idpAdapterManager.getInstance(authnSourceKey.getId()) != null) && (optType != AsActionOption.Type.CONNECTION || this.isSpEnabled && this.connManager.getIdpConnectionBySystemId(authnSourceKey.getId()) != null && MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableProtocolSp(this.connManager.getIdpConnectionBySystemId(authnSourceKey.getId()).getProtocol())))) {
                    selectedOptionInvalid = true;
                    selectedOption = null;
                } else {
                    selectedOption = new AsActionOption(authnSourceKey.getId(), optType);
                    this.loadAttributeContracts((AsActionOption)selectedOption);
                }
            } else if (asAction instanceof LocalIdentityMappingAction) {
                map2LipAction = (LocalIdentityMappingAction)asAction;
                selectedOption = new AsActionOption(map2LipAction.getLipId(), AsActionOption.Type.LOCAL_IDENTITY_PROFILE);
            } else if (asAction instanceof ApcMappingAction) {
                ApcMappingAction map2ApcAction = (ApcMappingAction)asAction;
                attributeMapping = map2ApcAction.getAttributeMapping();
                apcId = map2ApcAction.getApcId();
                selectedOption = new AsActionOption(map2ApcAction.getApcId(), AsActionOption.Type.AUTHN_POLICY_CONTRACT);
            } else if (asAction instanceof FragmentAction) {
                FragmentAction fragmentAction = (FragmentAction)asAction;
                attrRules = new ArrayList();
                for (AttributeRule attrRule : fragmentAction.getAttributeRules()) {
                    attrRules.add(attrRule.clone());
                }
                fallbackToSuccess = fragmentAction.isFallbackToSuccess();
                fragmentMapping = fragmentAction.getAttributeMapping();
                fragmentId = fragmentAction.getFragmentId();
                PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(fragmentAction.getFragmentId());
                if (fragment == null) {
                    selectedOptionInvalid = true;
                    selectedOption = null;
                } else {
                    fragmentOutboundApc = fragment.getOutputContractId();
                    selectedOption = new AsActionOption(fragmentAction.getFragmentId(), AsActionOption.Type.FRAGMENT);
                    this.loadAttributeContracts((AsActionOption)selectedOption);
                }
            } else if (asAction instanceof NoOpAction) {
                NoOpAction.Type noOpType = ((NoOpAction)asAction).getType();
                selectedOption = noOpType == NoOpAction.Type.CONTINUE ? new AsActionOption(null, AsActionOption.Type.CONTINUE) : (noOpType == NoOpAction.Type.RESTART ? new AsActionOption(null, AsActionOption.Type.RESTART) : (noOpType == NoOpAction.Type.EMPTY ? null : new AsActionOption(null, AsActionOption.Type.DONE)));
            } else {
                throw new IllegalStateException("Unrecognized action type");
            }
            String context = asAction.getContext();
            AsUiAction asUiAction = new AsUiAction(this, context, (AsActionOption)selectedOption);
            Tree.Node newUiNode = new Tree.Node((Object)asUiAction);
            asUiAction.setNode((Tree.Node<AsUiAction>)newUiNode);
            List<Object> attributeRulesForUiAction = attrRules;
            if (CollectionUtils.isNotEmpty(attrRules)) {
                attributeRulesForUiAction = attrRules.stream().map(AttributeRule::clone).collect(Collectors.toList());
            }
            asUiAction.setAttributeRules(attributeRulesForUiAction);
            asUiAction.setInputUserIdMapping(inputUserIdMapping);
            asUiAction.setUserIdAuthenticated(useridAuthenticated);
            if (inputUserIdMapping != null) {
                AttributeContractHolder holder = new AttributeContractHolder();
                if (inputUserIdMapping.getType() == SourceType.CONTEXT) {
                    holder.setAttributeContract(SourceContextType.REQUESTED_USER.getDescription());
                    holder.setSourceType(SourceType.CONTEXT.toString());
                } else {
                    holder.setAttributeContract(inputUserIdMapping.getValue());
                    holder.setSourceId(inputUserIdMapping.getAttributeSourceId());
                    holder.setSourceType(inputUserIdMapping.getType().name());
                }
                holder.setUserIdAuthenticated(useridAuthenticated);
                this.updateInputUserIdMaps(asUiAction.getNodeId(), holder);
            }
            if (attrRules != null && attrRules.size() > 0) {
                this.updateAttributeRuleValues(asUiAction.getNodeId(), attrRules, fallbackToSuccess);
            }
            if (selectedOption != null && ((AsActionOption)selectedOption).getType() == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
                this.getApcMappingTasklet(((AsActionOption)selectedOption).getId(), (Tree.Node<AsUiAction>)newUiNode, attributeMapping);
            }
            if (selectedOption != null && ((AsActionOption)selectedOption).getType() == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
                this.getLipMappingTasklet(((AsActionOption)selectedOption).getId(), (Tree.Node<AsUiAction>)newUiNode, map2LipAction);
            }
            if (selectedOption != null && ((AsActionOption)selectedOption).getType() == AsActionOption.Type.FRAGMENT) {
                this.getFragmentMappingTasklet(((AsActionOption)selectedOption).getId(), (Tree.Node<AsUiAction>)newUiNode, fragmentMapping);
            }
            if (parentUiNode != null && (parentsAttributeRules = ((AsUiAction)parentUiNode.getData()).getAttributeRules()) != null && parentsAttributeRules.size() > 0) {
                for (AttributeRule ar : parentsAttributeRules) {
                    if (!ar.getResult().equals(asUiAction.getResultContext())) continue;
                    ar.setNodeId(asUiAction.getNodeId());
                    if (!this.attributeRulesMap.containsKey(((AsUiAction)parentUiNode.getData()).getNodeId())) break;
                    this.attributeRulesMap.get(((AsUiAction)parentUiNode.getData()).getNodeId()).getAttributeRules().stream().filter(attributeRule -> attributeRule.getResult().equals(asUiAction.getResultContext())).findFirst().ifPresent(attributeRule -> attributeRule.setNodeId(asUiAction.getNodeId()));
                    break;
                }
            }
            asUiAction.setFallBackToDefaultSuccess(fallbackToSuccess);
            if (uiRootNode == null) {
                uiRootNode = newUiNode;
            }
            if (parentUiNode != null) {
                parentUiNode.addChildNode(newUiNode);
            }
            if (attributeMapping != null) {
                asUiAction.setMappingApcId(((AsActionOption)selectedOption).getId());
                asUiAction.setApcAttributeMapping(attributeMapping);
                this.getApcMappingTasklet(apcId, (Tree.Node<AsUiAction>)newUiNode, attributeMapping);
            }
            if (map2LipAction != null) {
                LocalIdentityProfile profile = MgmtFactory.getLocalIdentityProfileManager().getProfile(((AsActionOption)selectedOption).getId());
                asUiAction.setMappingApcId(profile.getContractId());
                this.getLipMappingTasklet(map2LipAction.getLipId(), (Tree.Node<AsUiAction>)newUiNode, map2LipAction);
            }
            if (fragmentMapping != null) {
                asUiAction.setMappingApcId(fragmentOutboundApc);
                asUiAction.setFragmentMapping(fragmentMapping);
                this.getFragmentMappingTasklet(fragmentId, (Tree.Node<AsUiAction>)newUiNode, fragmentMapping);
            }
            List<String> availableSourceIds = this.getAvailableSourceIdsOnSuccessBranches((Tree.Node<AsUiAction>)newUiNode);
            this.availableSourceIdsMap.put(((AsUiAction)newUiNode.getData()).getNodeId(), this.addInAdditionalUserIdSourceIds(new LinkedList<String>(availableSourceIds)));
            this.availableUpstreamAuthenticationSourcesMap.put(((AsUiAction)newUiNode.getData()).getNodeId(), this.addInAdditionalUpstreamAvailableSourceIds((Tree.Node<AsUiAction>)newUiNode, new LinkedList<String>(availableSourceIds)));
            if (!selectedOptionInvalid && node.hasChildren()) {
                boolean first = true;
                LinkedList<Tree.Node> otherChildren = new LinkedList<Tree.Node>();
                for (Tree.Node childNode : node.getChildren()) {
                    if (first) {
                        node = childNode;
                        first = false;
                        parentUiNode = newUiNode;
                        continue;
                    }
                    otherChildren.add(childNode);
                }
                Iterator reverseChildIt = otherChildren.descendingIterator();
                while (reverseChildIt.hasNext()) {
                    nodeStack.push((Tree.Node)reverseChildIt.next());
                    uiParentNodeStack.push(parentUiNode);
                }
                continue;
            }
            if (nodeStack.isEmpty()) {
                node = null;
                continue;
            }
            node = (Tree.Node)nodeStack.pop();
            parentUiNode = (Tree.Node)uiParentNodeStack.pop();
        }
        Tree uiTree = new Tree(uiRootNode);
        return uiTree;
    }

    private AttributeRule getAttributeRulesForUi(AttributeRule attributeRule) {
        if (attributeRule.getAuthenticationSourceType() != null && SourceType.CONTEXT.equals((Object)attributeRule.getAuthenticationSourceType())) {
            attributeRule.setAttribute(SourceContextType.getTypeFromId((String)attributeRule.getAttribute()).getDescription());
        }
        return attributeRule;
    }

    public APCMappingTasklet getApcMappingTasklet(String apcId, Tree.Node<AsUiAction> newUiNode, AttributeMapping attributeMapping) {
        APCMappingTasklet apcMappingTasklet = this.createTaskletToLoad(APCMappingTasklet.class);
        apcMappingTasklet.setState(this);
        apcMappingTasklet.setSelectedNode(newUiNode);
        C2cContract c2cContract = this.contractManager.getContract(apcId);
        if (c2cContract != null) {
            apcMappingTasklet.setContractToFulfill(c2cContract.getAllAttrNamesSorted());
            if (attributeMapping != null) {
                apcMappingTasklet.populate(attributeMapping);
            }
            this.apcMappingTaskletMap.put(((AsUiAction)newUiNode.getData()).getNodeId(), apcMappingTasklet);
        }
        return apcMappingTasklet;
    }

    public FragmentMappingTasklet getFragmentMappingTasklet(String fragmentId, Tree.Node<AsUiAction> newUiNode, AttributeMapping attributeMapping) {
        FragmentMappingTasklet fragmentMappingTasklet = this.createTaskletToLoad(FragmentMappingTasklet.class);
        fragmentMappingTasklet.setState(this);
        fragmentMappingTasklet.setSelectedNode(newUiNode);
        C2cContract c2cContract = this.policyFragmentManager.getFragment(fragmentId).getInputContract();
        if (c2cContract != null) {
            fragmentMappingTasklet.setContractToFulfill(c2cContract.getAllAttrNamesSorted());
            fragmentMappingTasklet.populate(attributeMapping);
            this.fragmentMappingTaskletMap.put(((AsUiAction)newUiNode.getData()).getNodeId(), fragmentMappingTasklet);
        }
        return fragmentMappingTasklet;
    }

    public LocalIdentityProfileMappingTasklet getLipMappingTasklet(String policyId, Tree.Node<AsUiAction> newUiNode, LocalIdentityMappingAction localIdentityMappingAction) {
        C2cContract c2cContract;
        LocalIdentityProfileMappingTasklet lipMappingTasklet = this.createTaskletToLoad(LocalIdentityProfileMappingTasklet.class);
        lipMappingTasklet.setState(this);
        lipMappingTasklet.setSelectedNode(newUiNode);
        ((AsUiAction)newUiNode.getData()).setLocalIdentityMappingAction(localIdentityMappingAction);
        LocalIdentityManager manager = MgmtFactory.getLocalIdentityProfileManager();
        LocalIdentityProfile profile = manager.getProfile(policyId);
        lipMappingTasklet.configureTasklet(profile);
        if (localIdentityMappingAction == null) {
            localIdentityMappingAction = new LocalIdentityMappingAction();
        }
        LocalIdentityBranchUtil branchUtil = new LocalIdentityBranchUtil(newUiNode);
        lipMappingTasklet.setBranchUtil(branchUtil);
        if (profile.isRegistrationEnabled() || profile.isProfileEnabled()) {
            if (profile.isRegistrationEnabled()) {
                lipMappingTasklet.setLocalIdentityFields(profile.getFieldConfig().getListOfFieldIds());
            }
            if (localIdentityMappingAction.getInboundAttributeMapping() != null) {
                lipMappingTasklet.getLocalIdentityInboundMappingState().populate(localIdentityMappingAction);
            }
        }
        if ((c2cContract = this.contractManager.getContract(profile.getContractId())) != null) {
            lipMappingTasklet.setContractToFulfill(c2cContract.getAllAttrNamesSorted());
            if (localIdentityMappingAction.getOutboundAttributeMapping() != null) {
                lipMappingTasklet.populate(localIdentityMappingAction);
                lipMappingTasklet.getLocalIdentityOutboundContractMappingState().populate(localIdentityMappingAction);
            }
            this.lipMappingTaskletMap.put(((AsUiAction)newUiNode.getData()).getNodeId(), lipMappingTasklet);
        }
        return lipMappingTasklet;
    }

    private Map<String, Set<String>> getBaseAttributeContractsMap() {
        HashMap<String, Set<String>> attributeContractMap = new HashMap<String, Set<String>>();
        HashSet<String> userIdContextAttributes = new HashSet<String>(Collections.singletonList(SourceContextType.REQUESTED_USER.getDescription()));
        attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(USER_ID_CONTEXT, SourceType.CONTEXT), userIdContextAttributes);
        Set rulesContextAttributes = SourceContextType.getContextTypesForAuthnPolicy().stream().map(SourceContextType::getDescription).collect(Collectors.toSet());
        attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(RULES_CONTEXT, SourceType.CONTEXT), rulesContextAttributes);
        HashSet<String> rulesTrackedParameters = new HashSet<String>(this.getTrackedHttpParameters());
        attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey("trackedparams", SourceType.TRACKED_HTTP_PARAMS), rulesTrackedParameters);
        Map extendedPropertyMap = new ExtendedPropertyAccessor().getExtendedPropertyDefinitions();
        HashSet rulesExtendedProperties = new HashSet(extendedPropertyMap.keySet());
        attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(null, SourceType.EXTENDED_PROPERTIES), rulesExtendedProperties);
        return attributeContractMap;
    }

    private List<String> getTrackedHttpParameters() {
        AuthnPoliciesTasklet policiesTasklet = this.findParent(AuthnPoliciesTasklet.class);
        if (policiesTasklet != null) {
            return policiesTasklet.getTrackedParams().getTrackedParamNames();
        }
        return MgmtFactory.getTrackedHttpParamManager().getTrackedParamSettings().getTrackedParamNames();
    }

    private Map<String, NameValuePair> getBaseIdToNamesMap() {
        HashMap<String, NameValuePair> idsToNamesMap = new HashMap<String, NameValuePair>();
        idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(USER_ID_CONTEXT, SourceType.CONTEXT), new NameValuePair(SourceType.CONTEXT.name(), "Context"));
        idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(RULES_CONTEXT, SourceType.CONTEXT), new NameValuePair(SourceType.CONTEXT.name(), "Context"));
        idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey("trackedparams", SourceType.TRACKED_HTTP_PARAMS), new NameValuePair(SourceType.TRACKED_HTTP_PARAMS.name(), "Tracked HTTP Parameters"));
        idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(null, SourceType.EXTENDED_PROPERTIES), new NameValuePair(SourceType.EXTENDED_PROPERTIES.name(), "Extended Properties"));
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(null, SourceType.EXPRESSION), new NameValuePair(SourceType.EXPRESSION.name(), "Expression"));
        }
        return idsToNamesMap;
    }

    protected List<String> addInAdditionalUpstreamAvailableSourceIds(Tree.Node<AsUiAction> selectedNode, List<String> availableSourceIds) {
        if (selectedNode.getData() != null && !((AsUiAction)selectedNode.getData()).isNoOpActionType() && this.isAuthnSource((AsUiAction)selectedNode.getData())) {
            availableSourceIds.add(0, AbstractPolicyState.getAuthnSourceKey(((AsUiAction)selectedNode.getData()).getSelectedOption().getId(), ((AsUiAction)selectedNode.getData()).getSelectedOption().getType()));
        }
        availableSourceIds.add(AbstractPolicyState.getAuthnSourceKey(null, SourceType.EXTENDED_PROPERTIES));
        availableSourceIds.add(AbstractPolicyState.getAuthnSourceKey("trackedparams", SourceType.TRACKED_HTTP_PARAMS));
        availableSourceIds.add(AbstractPolicyState.getAuthnSourceKey(RULES_CONTEXT, SourceType.CONTEXT));
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            availableSourceIds.add(AbstractPolicyState.getAuthnSourceKey(null, SourceType.EXPRESSION));
        }
        return availableSourceIds;
    }

    protected List<String> addInAdditionalUserIdSourceIds(List<String> availableSourceIds) {
        availableSourceIds.add(AbstractPolicyState.getAuthnSourceKey(USER_ID_CONTEXT, SourceType.CONTEXT));
        return availableSourceIds;
    }

    public List<String> getAvailableSourceIdsOnSuccessBranches(Tree.Node<AsUiAction> selectedNode) {
        ArrayList<String> sourceIdsList = new ArrayList<String>();
        for (Tree.Node currentNode = selectedNode; currentNode != null; currentNode = currentNode.getParent()) {
            AsActionOption selectedOption;
            PolicyBranchUtil branchUtil = new PolicyBranchUtil(currentNode);
            if (!branchUtil.isNodeAuthSourceSuccessBranch()) continue;
            AsActionOption asActionOption = selectedOption = currentNode.getParent() != null && currentNode.getParent().getData() != null ? ((AsUiAction)currentNode.getParent().getData()).getSelectedOption() : null;
            if (selectedOption == null || !this.isMappableSource((AsUiAction)currentNode.getParent().getData(), false)) continue;
            sourceIdsList.add(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), selectedOption.getType()));
        }
        return sourceIdsList;
    }

    public void updatePossibleAttributeSourceOptions(Tree.Node<AsUiAction> node) {
        this.updatePossibleAttributeSourceOptions(node, false);
    }

    public void updatePossibleAttributeSourceOptions(Tree.Node<AsUiAction> node, boolean includeDownstreamNodes) {
        if (this.isAuthnSource((AsUiAction)node.getData())) {
            List<String> availableSourceIds = this.getAvailableSourceIdsOnSuccessBranches(node);
            if (((AsUiAction)node.getData()).getSelectedOption() != null && (((AsUiAction)node.getData()).getSelectedOption().getType() == AsActionOption.Type.ADAPTER || ((AsUiAction)node.getData()).getSelectedOption().getType() == AsActionOption.Type.CONNECTION)) {
                this.availableSourceIdsMap.put(((AsUiAction)node.getData()).getNodeId(), this.addInAdditionalUserIdSourceIds(new LinkedList<String>(availableSourceIds)));
            }
            this.availableUpstreamAuthenticationSourcesMap.put(((AsUiAction)node.getData()).getNodeId(), this.addInAdditionalUpstreamAvailableSourceIds(node, new LinkedList<String>(availableSourceIds)));
        }
        if (includeDownstreamNodes && node.getChildren() != null) {
            node.getChildren().forEach(childNode -> this.updatePossibleAttributeSourceOptions((Tree.Node<AsUiAction>)childNode, true));
        }
    }

    protected boolean isShowAuthnPolicyContracts(AsUiAction node) {
        boolean show = false;
        PolicyBranchUtil branchUtil = new PolicyBranchUtil(node.getNode());
        if (!node.getNode().hasChildren() && branchUtil.isNodeAuthSourceSuccessBranch() || branchUtil.isSuccessPath()) {
            show = true;
        }
        return show;
    }

    protected boolean isShowLocalIdentityProfiles(AsUiAction asUiAction) {
        boolean show = false;
        LocalIdentityBranchUtil branchUtil = new LocalIdentityBranchUtil(asUiAction.getNode());
        if (branchUtil.isRegistrationBranch() || branchUtil.isSuccessPath()) {
            show = true;
        }
        return show;
    }

    @Override
    public void onStateActivated() {
        this.convertTreeToList();
    }

    public String getAllAttributeContracts() {
        this.loadAttributeContracts(null);
        try {
            return objectMapper.writeValueAsString(this.attributeContractMap);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the attribute contract map", (Throwable)e);
            return "";
        }
    }

    public String getIdsToNamesMap() {
        try {
            return objectMapper.writeValueAsString(this.idsToNamesMap);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the ids to namesmap", (Throwable)e);
            return "";
        }
    }

    public String getIdsToExpressionIds() {
        try {
            return objectMapper.writeValueAsString(this.idsToExpressionIds);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the ids to expression ids", (Throwable)e);
            return "";
        }
    }

    public String getAvailableSourceIdsMap() {
        try {
            return objectMapper.writeValueAsString(this.availableSourceIdsMap);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the success paths attribute contracts", (Throwable)e);
            return "";
        }
    }

    public String getAvailableUpstreamAuthenticationSourcesMap() {
        try {
            return objectMapper.writeValueAsString(this.availableUpstreamAuthenticationSourcesMap);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the available upstream authentication sources", (Throwable)e);
            return "";
        }
    }

    public Map<String, Set<String>> getAttributeContractsMap() {
        return this.attributeContractMap;
    }

    public String getAllAttributeRules() {
        if (!this.attributeRulesMap.isEmpty()) {
            try {
                return objectMapper.writeValueAsString(this.attributeRulesMap);
            }
            catch (JsonProcessingException e) {
                this.log.debug((Object)"Failed to parse the attribute rules map", (Throwable)e);
            }
        }
        return null;
    }

    public String getAllInputUserIdMappings() {
        if (!this.inputUserIdMappings.isEmpty()) {
            try {
                return objectMapper.writeValueAsString(this.inputUserIdMappings);
            }
            catch (JsonProcessingException e) {
                this.log.debug((Object)"Failed to parse the input user id map", (Throwable)e);
            }
        }
        return null;
    }

    public String getAllNodeIdToType() {
        if (!this.nodeIdToType.isEmpty()) {
            try {
                return objectMapper.writeValueAsString(this.nodeIdToType);
            }
            catch (JsonProcessingException e) {
                this.log.debug((Object)"Failed to parse the node Id to node type map", (Throwable)e);
            }
        }
        return null;
    }

    public String getAllConditionTypes() {
        try {
            return objectMapper.writeValueAsString(this.conditionTypesMap);
        }
        catch (JsonProcessingException e) {
            this.log.debug((Object)"Failed to parse the attribute contract map", (Throwable)e);
            return null;
        }
    }

    public void loadAttributeContracts(AsActionOption selectedOption) {
        if (selectedOption != null && selectedOption.getId() != null) {
            switch (selectedOption.getType()) {
                case ADAPTER: {
                    IdpAuthnAdapterInstance adapter = (IdpAuthnAdapterInstance)this.idpAdapterManager.getInstance(selectedOption.getId());
                    if (adapter.getAttributeContract() == null) break;
                    this.attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), SourceType.ADAPTER), adapter.getAttributeContract().getAllAttributeNames());
                    this.idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(adapter.getId(), SourceType.ADAPTER), new NameValuePair(SourceType.ADAPTER.name(), "Adapter (" + adapter.getName() + ")"));
                    break;
                }
                case CONNECTION: {
                    IdpConnection conn = this.connManager.getIdpConnectionBySystemId(selectedOption.getId());
                    if (conn.getAttributeContract() == null) break;
                    this.attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), SourceType.IDP_CONNECTION), conn.getAttributeContract().getAllAttributeNames());
                    this.idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(conn.getId(), SourceType.IDP_CONNECTION), new NameValuePair(SourceType.IDP_CONNECTION.name(), "IdP Connection (" + conn.getEntityId() + ")"));
                    this.idsToExpressionIds.put(AbstractPolicyState.getAuthnSourceKey(conn.getId(), SourceType.IDP_CONNECTION), conn.getEntityId());
                    break;
                }
                case FRAGMENT: {
                    PolicyFragment fragment = this.policyFragmentManager.getFragment(selectedOption.getId());
                    Set allAttributeNames = new HashSet();
                    if (fragment.getOutputContractId() != null) {
                        allAttributeNames = fragment.getOutputContractAllAttributes();
                    }
                    this.attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey(selectedOption.getId(), SourceType.FRAGMENT), allAttributeNames);
                    this.idsToNamesMap.put(AbstractPolicyState.getAuthnSourceKey(fragment.getId(), SourceType.FRAGMENT), new NameValuePair(SourceType.FRAGMENT.name(), "Fragment (" + fragment.getName() + ")"));
                    break;
                }
            }
            this.attributeContractMap.putAll(this.getBaseAttributeContractsMap());
            this.idsToNamesMap.putAll(this.getBaseIdToNamesMap());
            this.attributeContractIdType.put(selectedOption.getId(), selectedOption.getType());
        }
    }

    public void performPasteValidation(IValidationDelegate delegate, List<String> messages) {
        PFValidationDelegate tempDelegate = new PFValidationDelegate();
        this.ruleNodeIdsWithError.clear();
        this.nodeIdsWithMappingErrors.clear();
        this.userIdNodesWithError.clear();
        PreOrderTraversal traversal = new PreOrderTraversal();
        this.updateSourceIds(traversal);
        FindInvalidAttributeSourcesVisitor findInvalidAttributeSourcesVisitor = new FindInvalidAttributeSourcesVisitor(this.availableSourceIdsMap, this.attributeContractMap, this.availableUpstreamAuthenticationSourcesMap, this.idsToExpressionIds);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findInvalidAttributeSourcesVisitor);
        this.userIdNodesWithError.addAll(findInvalidAttributeSourcesVisitor.getNodeIdsWithInvalidIncomingUserId());
        this.ruleNodeIdsWithError.addAll(findInvalidAttributeSourcesVisitor.getNodeIdsWithInvalidRule());
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.apcMappingTaskletMap, tempDelegate));
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.lipMappingTaskletMap, tempDelegate));
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.fragmentMappingTaskletMap, tempDelegate));
        for (String nodeId : findInvalidAttributeSourcesVisitor.getNodeIdsWithInvalidIncomingUserId()) {
            this.inputUserIdMappings.remove(nodeId);
        }
        this.expandErrorBranches(delegate);
        if (!messages.isEmpty()) {
            for (String message : messages) {
                AbstractPolicyState.recordErrorMsg(message, delegate);
            }
        }
    }

    protected void updateSourceIds(PreOrderTraversal traversal) {
        UpdateSourceIdsVisitor updateSourceIdsVisitor = new UpdateSourceIdsVisitor(this.availableSourceIdsMap, this.availableUpstreamAuthenticationSourcesMap, this::getAvailableSourceIdsOnSuccessBranches, this::addInAdditionalUserIdSourceIds, this::addInAdditionalUpstreamAvailableSourceIds);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)updateSourceIdsVisitor);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Set availableAttributeNames;
        PreOrderTraversal traversal = new PreOrderTraversal();
        HasMissingOptionVisitor visitor = new HasMissingOptionVisitor();
        Tree<AsUiAction> tree = this.authnSelectionTree;
        traversal.traverse(tree, (TraversalVisitor)visitor);
        if (this.getParent().isModeCreate()) {
            if (StringUtils.isEmpty((String)this.getId())) {
                this.setId(this.generateId());
            }
            if (this.getParent(AbstractPolicyTasklet.class).isIdInUse(this.getId())) {
                AbstractPolicyState.recordErrorMsg(this.getMessage("policy_id_in_use", new Object[]{this.getId()}), delegate);
            } else {
                IdValidator idValidator = new IdValidator(this.getId(), true, false, 0, 33, "Id");
                if (!idValidator.validate()) {
                    this.recordErrors(idValidator.getErrors(), delegate);
                }
            }
        }
        if (StringUtils.isBlank((String)this.name)) {
            AbstractPolicyState.recordErrorMsg(this.getMessage("policy_name_required"), delegate);
        }
        if (this.getParent(AbstractPolicyTasklet.class).isNameInUse(this.name)) {
            AbstractPolicyState.recordErrorMsg(this.getMessage("policy_name_in_use", new Object[]{this.name}), delegate);
        }
        if (visitor.hasMissingOption()) {
            this.expandBranches(visitor.getNodesMissingOptions());
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("authn_tree_missing_option"), ValidationConstraint.CONSISTENCY);
        }
        PFValidationDelegate tempDelegate = new PFValidationDelegate();
        this.ruleNodeIdsWithError.clear();
        this.nodeIdsWithMappingErrors.clear();
        this.userIdNodesWithError.clear();
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.apcMappingTaskletMap, tempDelegate));
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.lipMappingTaskletMap, tempDelegate));
        this.nodeIdsWithMappingErrors.addAll(this.checkMappingTaskletsForErrors(this.fragmentMappingTaskletMap, tempDelegate));
        List nodeIdsWithEmptyAttributeMapping = this.apcMappingTaskletMap.entrySet().stream().filter(apcMappingTaskletEntry -> ((APCMappingTasklet)apcMappingTaskletEntry.getValue()).getPopulateData() == null).map(Map.Entry::getKey).collect(Collectors.toList());
        nodeIdsWithEmptyAttributeMapping.addAll(this.lipMappingTaskletMap.entrySet().stream().filter(apcMappingTaskletEntry -> ((LocalIdentityProfileMappingTasklet)apcMappingTaskletEntry.getValue()).getPopulateData() == null).map(Map.Entry::getKey).collect(Collectors.toList()));
        nodeIdsWithEmptyAttributeMapping.addAll(this.fragmentMappingTaskletMap.entrySet().stream().filter(fragmentMappingTaskletEntry -> ((FragmentMappingTasklet)fragmentMappingTaskletEntry.getValue()).getPopulateData() == null).map(Map.Entry::getKey).collect(Collectors.toList()));
        this.nodeIdsWithMappingErrors.addAll(nodeIdsWithEmptyAttributeMapping);
        HashMap<String, Set<String>> allAvailableAttributeContracts = new HashMap<String, Set<String>>();
        for (IdpConnection idpConnection : this.connManager.getAllIdpConnections()) {
            if (!idpConnection.isActive() || idpConnection.getAttributeContract() == null) continue;
            availableAttributeNames = idpConnection.getAttributeContract().getAllAttributeNames();
            allAvailableAttributeContracts.put(idpConnection.getId(), availableAttributeNames);
        }
        for (IdpAuthnAdapterInstance adapter : this.idpAdapterManager.getInstances()) {
            if (adapter.getAttributeContract() == null) continue;
            availableAttributeNames = adapter.getAttributeContract().getAllAttributeNames();
            allAvailableAttributeContracts.put(adapter.getId(), availableAttributeNames);
        }
        for (PolicyFragment fragment : this.policyFragmentManager.getFragments()) {
            availableAttributeNames = fragment.getOutputContractAllAttributes();
            allAvailableAttributeContracts.put(fragment.getId(), availableAttributeNames);
        }
        this.addOtherInputSourceAttributes(allAvailableAttributeContracts);
        this.updateTrackedHttpParametersInAttributeContractMap();
        this.updateSourceIds(traversal);
        FindInvalidAttributeSourcesVisitor findInvalidAttributeSourcesVisitor = new FindInvalidAttributeSourcesVisitor(this.availableSourceIdsMap, this.attributeContractMap, this.availableUpstreamAuthenticationSourcesMap, this.idsToExpressionIds);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findInvalidAttributeSourcesVisitor);
        this.userIdNodesWithError.addAll(findInvalidAttributeSourcesVisitor.getNodeIdsWithInvalidIncomingUserId());
        this.ruleNodeIdsWithError.addAll(findInvalidAttributeSourcesVisitor.getNodeIdsWithInvalidRule());
        this.expandErrorBranches(delegate);
    }

    private void updateTrackedHttpParametersInAttributeContractMap() {
        HashSet<String> rulesTrackedParameters = new HashSet<String>(this.getTrackedHttpParameters());
        this.attributeContractMap.put(AbstractPolicyState.getAuthnSourceKey("trackedparams", SourceType.TRACKED_HTTP_PARAMS), rulesTrackedParameters);
    }

    protected abstract void addOtherInputSourceAttributes(Map<String, Set<String>> var1);

    private List<Tree.Node<AsUiAction>> convertIdsToNodes(List<String> nodeIdsWithError) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodesByIdsVisitor visitor = new FindNodesByIdsVisitor(nodeIdsWithError);
        Tree<AsUiAction> tree = this.authnSelectionTree;
        traversal.traverse(tree, (TraversalVisitor)visitor);
        return visitor.getErrorNodes();
    }

    private void expandErrorBranches(IValidationDelegate delegate) {
        List<Tree.Node<AsUiAction>> nodes;
        if (!this.nodeIdsWithError.isEmpty()) {
            nodes = this.convertIdsToNodes(this.nodeIdsWithError);
            this.expandBranches(nodes);
            delegate.setFormComponent(null);
        }
        if (!this.nodeIdsWithMappingErrors.isEmpty()) {
            nodes = this.convertIdsToNodes(this.nodeIdsWithMappingErrors);
            this.expandBranches(nodes);
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("apc_mapping_errors"), ValidationConstraint.CONSISTENCY);
        }
        if (!this.ruleNodeIdsWithError.isEmpty()) {
            nodes = this.convertIdsToNodes(this.ruleNodeIdsWithError);
            this.expandBranches(nodes);
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("rule_errors"), ValidationConstraint.CONSISTENCY);
        }
        if (!this.userIdNodesWithError.isEmpty()) {
            nodes = this.convertIdsToNodes(this.userIdNodesWithError);
            this.expandBranches(nodes);
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("option_errors"), ValidationConstraint.CONSISTENCY);
        }
    }

    private void expandBranches(List<Tree.Node<AsUiAction>> nodesMissingOptions) {
        nodesMissingOptions.forEach(this::expandBranch);
    }

    private void expandBranch(Tree.Node<AsUiAction> node) {
        if (node != null) {
            ((AsUiAction)node.getData()).setCollapseChildren(false);
            this.expandBranch((Tree.Node<AsUiAction>)node.getParent());
        }
    }

    private List<String> checkMappingTaskletsForErrors(Map<String, ? extends MappingTasklet> taskletMap, ValidationDelegate delegate) {
        return taskletMap.entrySet().stream().filter(entry -> ((MappingTasklet)entry.getValue()).getPopulateData() != null).map(mappingTaskletEntry -> {
            ((MappingTasklet)mappingTaskletEntry.getValue()).appendErrors((IValidationDelegate)delegate, null, false);
            if (delegate.getHasErrors()) {
                delegate.clear();
                return (String)mappingTaskletEntry.getKey();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<String> getNodeIdsWithError() {
        return this.nodeIdsWithError;
    }

    public boolean doesNodeHaveError(String nodeId) {
        return this.nodeIdsWithError.contains(nodeId);
    }

    public void setNodeIdsWithError(List<String> nodeIdsWithError) {
        this.nodeIdsWithError = nodeIdsWithError;
    }

    public List<String> getNodeIdsWithMappingErrors() {
        return this.nodeIdsWithMappingErrors;
    }

    public boolean getNodeMappingHasError(String nodeId) {
        return this.nodeIdsWithMappingErrors.contains(nodeId);
    }

    public boolean getRuleHasError(String nodeId) {
        return this.ruleNodeIdsWithError.contains(nodeId);
    }

    public boolean getUserIdHasError(String nodeId) {
        return this.userIdNodesWithError.contains(nodeId);
    }

    private void convertTreeToList() {
        this.nodeIdToType.clear();
        this.authnSelectionList = TreeHelper.treeToList(this.authnSelectionTree);
        for (TreeHelper.NodeWrapper<AsUiAction> authnSelection : this.authnSelectionList) {
            if (authnSelection.getNode() == null || authnSelection.getNode().getData() == null || ((AsUiAction)authnSelection.getNode().getData()).getSelectedOption() == null || !this.isAuthnSource((AsUiAction)authnSelection.getNode().getData())) continue;
            this.nodeIdToType.put(((AsUiAction)authnSelection.getNode().getData()).getNodeId(), ((AsUiAction)authnSelection.getNode().getData()).getSelectedOption().getType().name());
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        String submittedRulesStr = cycle.getRequestContext().getParameter("submittedRules");
        String nodeId = cycle.getRequestContext().getParameter("submittedRulesId");
        String defaultSuccess = cycle.getRequestContext().getParameter("defaultSuccess");
        this.updateNodeRules(nodeId, submittedRulesStr, Boolean.valueOf(defaultSuccess));
        String submittedContracts = cycle.getRequestContext().getParameter("submittedContracts");
        String nodeIdContract = cycle.getRequestContext().getParameter("submittedRowId");
        this.updateContracts(nodeIdContract, submittedContracts);
        this.convertTreeToList();
    }

    private void updateContracts(String nodeId, String submittedContracts) {
        if (nodeId == null) {
            return;
        }
        Tree<AsUiAction> tree = this.authnSelectionTree;
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        Tree.Node<AsUiAction> node = nodeIdVisitor.getNode();
        if (node != null) {
            try {
                AttributeContractHolder attributeContractHolder = (AttributeContractHolder)objectMapper.readValue(submittedContracts, AttributeContractHolder.class);
                AttrMappingValue attrMappingValue = this.getAttributeMappingValue(attributeContractHolder);
                ((AsUiAction)node.getData()).setInputUserIdMapping(attrMappingValue);
                ((AsUiAction)node.getData()).setUserIdAuthenticated(attributeContractHolder.getUserIdAuthenticated());
                this.updateInputUserIdMaps(((AsUiAction)node.getData()).getNodeId(), attrMappingValue == null ? null : attributeContractHolder);
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to read contracts for user Ids", (Throwable)e);
            }
        }
    }

    private AttrMappingValue getAttributeMappingValue(AttributeContractHolder attributeContractHolder) {
        if (attributeContractHolder != null) {
            if (StringUtils.isEmpty((String)attributeContractHolder.getAttributeContract()) && StringUtils.isEmpty((String)attributeContractHolder.getSourceId())) {
                return null;
            }
            if (attributeContractHolder.getSourceType().equals(SourceType.CONTEXT.toString())) {
                return new AttrMappingValue(SourceType.CONTEXT, SourceContextType.REQUESTED_USER.getId(), null, null);
            }
            AttrMappingValue attrmappingValue = new AttrMappingValue(SourceType.valueOf((String)attributeContractHolder.getSourceType()), attributeContractHolder.getAttributeContract(), null, attributeContractHolder.getSourceId());
            return attrmappingValue;
        }
        return null;
    }

    private void updateNodeRules(String nodeId, String submittedRulesStr, boolean defaultSuccess) {
        if (nodeId == null) {
            return;
        }
        Tree<AsUiAction> tree = this.authnSelectionTree;
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        Tree.Node<AsUiAction> parentNode = nodeIdVisitor.getNode();
        if (parentNode != null && parentNode.getChildren() != null && parentNode.getChildren().size() > 0) {
            this.ruleNodeIdsWithError.remove(((AsUiAction)parentNode.getData()).getNodeId());
        }
        if (parentNode != null) {
            try {
                List<AttributeRule> attributeRules = this.getAttributeRules(submittedRulesStr);
                HashMap<String, AttributeRule> updatedAttributeRulesMap = new HashMap<String, AttributeRule>();
                for (AttributeRule attributeRule : attributeRules) {
                    if (!StringUtils.isNotEmpty((String)attributeRule.getNodeId())) continue;
                    updatedAttributeRulesMap.put(attributeRule.getNodeId(), attributeRule);
                }
                HashMap<String, Tree.Node> childrenNodeMap = new HashMap<String, Tree.Node>();
                for (Tree.Node childNode : parentNode.getChildren()) {
                    childrenNodeMap.put(((AsUiAction)childNode.getData()).getNodeId(), childNode);
                }
                AsUiAction asUiAction = (AsUiAction)parentNode.getData();
                ArrayList<Tree.Node> modifiedRuleRootChildNodesToUpdate = new ArrayList<Tree.Node>();
                Iterator<Object> iterator = parentNode.getChildren().iterator();
                while (iterator.hasNext()) {
                    Tree.Node node2 = (Tree.Node)iterator.next();
                    if (((AsUiAction)node2.getData()).getResultContext().equals("Success") || ((AsUiAction)node2.getData()).getResultContext().equals("Fail")) continue;
                    if (updatedAttributeRulesMap.get(((AsUiAction)node2.getData()).getNodeId()) == null) {
                        this.removeAttributeRulesAndMappings((Tree.Node<AsUiAction>)node2);
                        iterator.remove();
                        continue;
                    }
                    modifiedRuleRootChildNodesToUpdate.add(node2);
                }
                for (AttributeRule attributeRule : attributeRules) {
                    if (StringUtils.isEmpty((String)attributeRule.getNodeId()) || childrenNodeMap.get(attributeRule.getNodeId()) == null) {
                        AsUiAction newAction = new AsUiAction(this, attributeRule.getResult(), null);
                        attributeRule.setNodeId(newAction.getNodeId());
                        Tree.Node newUiNode = parentNode.addChildData((Object)newAction);
                        newAction.setNode((Tree.Node<AsUiAction>)newUiNode);
                        continue;
                    }
                    Tree.Node childNode = (Tree.Node)childrenNodeMap.get(attributeRule.getNodeId());
                    ((AsUiAction)childNode.getData()).setResultContext(attributeRule.getResult());
                }
                ArrayList copiedChildren = new ArrayList(parentNode.getChildren());
                HashMap<String, Tree.Node> copiedChildrenMap = new HashMap<String, Tree.Node>();
                parentNode.getChildren().clear();
                for (Tree.Node childNode : copiedChildren) {
                    copiedChildrenMap.put(((AsUiAction)childNode.getData()).getResultContext(), childNode);
                }
                parentNode.addChildNode((Tree.Node)copiedChildrenMap.get("Fail"));
                for (AttributeRule orderedAttributeRule : attributeRules) {
                    parentNode.addChildNode((Tree.Node)copiedChildrenMap.get(orderedAttributeRule.getResult()));
                }
                Tree.Node<AsUiAction> successNode = (Tree.Node<AsUiAction>)copiedChildrenMap.get("Success");
                if (defaultSuccess) {
                    parentNode.addChildNode(successNode != null ? successNode : this.getSuccessNode());
                } else if (successNode != null) {
                    this.removeAttributeRulesAndMappings(successNode);
                }
                asUiAction.setAttributeRules(attributeRules);
                asUiAction.setFallBackToDefaultSuccess(defaultSuccess);
                this.updateAttributeRuleValues(nodeId, attributeRules, defaultSuccess);
                if (!modifiedRuleRootChildNodesToUpdate.isEmpty()) {
                    modifiedRuleRootChildNodesToUpdate.forEach(node -> this.updatePossibleAttributeSourceOptions((Tree.Node<AsUiAction>)node, true));
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Unable to read Attribute Rules", (Throwable)e);
            }
        }
    }

    private List<AttributeRule> getAttributeRules(String submittedRulesStr) throws IOException {
        List attributeRules = (List)objectMapper.readValue(submittedRulesStr, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, AttributeRule.class));
        attributeRules.forEach(attributeRule -> {
            if (SourceType.CONTEXT.equals((Object)attributeRule.getAuthenticationSourceType())) {
                attributeRule.setAuthenticationSourceId(null);
                attributeRule.setAttribute(SourceContextType.getTypeFromDescription((String)attributeRule.getAttribute()).getId());
            } else if (SourceType.EXTENDED_PROPERTIES.equals((Object)attributeRule.getAuthenticationSourceType()) || SourceType.EXPRESSION.equals((Object)attributeRule.getAuthenticationSourceType())) {
                attributeRule.setAuthenticationSourceId(null);
            }
        });
        return attributeRules;
    }

    private Tree.Node<AsUiAction> getSuccessNode() {
        AsUiAction asUiAction = new AsUiAction(this, "Success", new AsActionOption(null, AsActionOption.Type.DONE));
        Tree.Node newUiNode = new Tree.Node((Object)asUiAction);
        asUiAction.setNode((Tree.Node<AsUiAction>)newUiNode);
        return newUiNode;
    }

    public void saveMappings() {
        this.apcMappingTaskletMap.values().forEach(apcMappingTasklet -> apcMappingTasklet.save(apcMappingTasklet.getMappingModel().getMapping()));
        this.fragmentMappingTaskletMap.values().forEach(fragmentMappingTasklet -> fragmentMappingTasklet.save(fragmentMappingTasklet.getMappingModel().getMapping()));
        this.lipMappingTaskletMap.values().forEach(registrationMappingTasklet -> registrationMappingTasklet.save(registrationMappingTasklet.getLocalIdentityMappingAction()));
    }

    public AuthnSelectionTree buildDomainTrees() {
        Tree.Node<AuthnSelectionAction> domainRootNode = this.buildTree(null, null);
        AuthnSelectionTree tree = new AuthnSelectionTree(domainRootNode);
        if (StringUtils.isBlank((String)this.id)) {
            tree.setId(this.generateId());
        } else {
            tree.setId(this.id);
        }
        tree.setName(this.name);
        tree.setDescription(this.description);
        return tree;
    }

    protected String generateId() {
        return AuthnPolicyUtil.getDefault().generateId();
    }

    protected Tree.Node<AuthnSelectionAction> buildTree(Tree.Node<AsUiAction> uiNodeToReplace, Tree.Node<AuthnSelectionAction> domainReplacementNode) {
        Stack<Tree.Node> uiNodeStack = new Stack<Tree.Node>();
        Stack<Tree.Node> domainParentNodeStack = new Stack<Tree.Node>();
        Tree.Node uiNode = this.authnSelectionTree.getRootNode();
        Tree.Node domainRootNode = null;
        Tree.Node parentDomainNode = null;
        while (uiNode != null) {
            AsUiAction uiAction = (AsUiAction)uiNode.getData();
            Tree.Node newDomainNode = null;
            boolean replaced = false;
            if (uiNodeToReplace != null && ((AsUiAction)uiNode.getData()).getNodeId().equals(((AsUiAction)uiNodeToReplace.getData()).getNodeId())) {
                newDomainNode = domainReplacementNode;
                ((AuthnSelectionAction)domainReplacementNode.getData()).setContext(uiAction.getResultContext());
                replaced = true;
            }
            if (!replaced) {
                List<AttributeRule> attrRules;
                AuthnSourceAction asa;
                AuthnSelectorAction domainAction;
                AsActionOption selectedOption = uiAction.getSelectedOption();
                Object optionType = selectedOption.getType();
                if (optionType == AsActionOption.Type.SELECTOR) {
                    domainAction = new AuthnSelectorAction(selectedOption.getId());
                } else if (optionType == AsActionOption.Type.ADAPTER || optionType == AsActionOption.Type.CONNECTION) {
                    asa = optionType == AsActionOption.Type.ADAPTER ? new AuthnSourceAction((AuthnSourceKey)new AdapterAuthnSourceKey(selectedOption.getId())) : new AuthnSourceAction((AuthnSourceKey)new IdpConnAuthnSourceKey(selectedOption.getId()));
                    attrRules = uiAction.getAttributeRules();
                    if (CollectionUtils.isNotEmpty(attrRules)) {
                        asa.setAttributeRules(attrRules);
                        asa.setFallbackToSuccess(uiAction.isFallBackToDefaultSuccess());
                    } else {
                        asa.setFallbackToSuccess(true);
                    }
                    if (uiAction.getInputUserIdMapping() != null) {
                        asa.setInputUserIdMapping(uiAction.getInputUserIdMapping());
                        asa.setUserIdAuthenticated(uiAction.isUserIdAuthenticated());
                    }
                    domainAction = asa;
                } else if (optionType == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
                    asa = new ApcMappingAction(selectedOption.getId(), null);
                    domainAction = asa;
                    APCMappingTasklet apcMappingTasklet = this.apcMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (apcMappingTasklet != null && apcMappingTasklet.getMappingModel() != null) {
                        asa.setAttributeMapping(apcMappingTasklet.getMappingModel().getMapping());
                    } else {
                        asa.setAttributeMapping(uiAction.getApcAttributeMapping());
                    }
                } else if (optionType == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
                    LocalIdentityMappingAction localIdentityMappingAction = new LocalIdentityMappingAction(selectedOption.getId(), null, null);
                    domainAction = localIdentityMappingAction;
                    LocalIdentityProfileMappingTasklet lipMappingTasklet = this.lipMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (lipMappingTasklet != null) {
                        localIdentityMappingAction.setInboundAttributeMapping(lipMappingTasklet.getInboundAttributeMapping());
                        localIdentityMappingAction.setOutboundAttributeMapping(lipMappingTasklet.getOutboundAttributeMapping());
                        lipMappingTasklet.setLocalIdentityMappingAction(localIdentityMappingAction);
                    } else {
                        localIdentityMappingAction.setInboundAttributeMapping(uiAction.getLocalIdentityMappingAction().getInboundAttributeMapping());
                        localIdentityMappingAction.setOutboundAttributeMapping(uiAction.getLocalIdentityMappingAction().getOutboundAttributeMapping());
                    }
                } else if (optionType == AsActionOption.Type.FRAGMENT) {
                    FragmentAction fragmentAction = new FragmentAction(selectedOption.getId());
                    attrRules = uiAction.getAttributeRules();
                    if (CollectionUtils.isNotEmpty(attrRules)) {
                        fragmentAction.setAttributeRules(attrRules);
                        fragmentAction.setFallbackToSuccess(uiAction.isFallBackToDefaultSuccess());
                    } else {
                        fragmentAction.setFallbackToSuccess(true);
                    }
                    FragmentMappingTasklet fragmentMappingTasklet = this.fragmentMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (fragmentMappingTasklet != null && fragmentMappingTasklet.getMappingModel() != null) {
                        fragmentAction.setAttributeMapping(fragmentMappingTasklet.getMappingModel().getMapping());
                    } else {
                        fragmentAction.setAttributeMapping(uiAction.getApcAttributeMapping());
                    }
                    domainAction = fragmentAction;
                } else if (optionType == AsActionOption.Type.CONTINUE) {
                    domainAction = new NoOpAction(NoOpAction.Type.CONTINUE);
                } else if (optionType == AsActionOption.Type.RESTART) {
                    domainAction = new NoOpAction(NoOpAction.Type.RESTART);
                } else if (optionType == AsActionOption.Type.DONE) {
                    domainAction = new NoOpAction(NoOpAction.Type.DONE);
                } else {
                    throw new IllegalStateException("Unrecognized action type");
                }
                domainAction.setContext(uiAction.getResultContext());
                newDomainNode = new Tree.Node((Object)domainAction);
            }
            if (domainRootNode == null) {
                domainRootNode = newDomainNode;
            }
            if (parentDomainNode != null) {
                parentDomainNode.addChildNode(newDomainNode);
            }
            if (uiNode.hasChildren() && !replaced) {
                boolean first = true;
                LinkedList<Tree.Node> otherChildren = new LinkedList<Tree.Node>();
                for (Tree.Node childNode : uiNode.getChildren()) {
                    if (first) {
                        uiNode = childNode;
                        first = false;
                        parentDomainNode = newDomainNode;
                        continue;
                    }
                    otherChildren.add(childNode);
                }
                Iterator reverseChildIt = otherChildren.descendingIterator();
                while (reverseChildIt.hasNext()) {
                    uiNodeStack.push((Tree.Node)reverseChildIt.next());
                    domainParentNodeStack.push(parentDomainNode);
                }
                continue;
            }
            if (uiNodeStack.isEmpty()) {
                uiNode = null;
                continue;
            }
            uiNode = (Tree.Node)uiNodeStack.pop();
            parentDomainNode = (Tree.Node)domainParentNodeStack.pop();
        }
        return domainRootNode;
    }

    public Collection<AuthnSelectorInstance> getAuthnSelectorInstances() {
        return MgmtFactory.getAuthnSelectorManager().getInstances();
    }

    public AuthnSelectorInstance getAuthnSelectorInstanceById(String instanceId) {
        return (AuthnSelectorInstance)MgmtFactory.getAuthnSelectorManager().getInstance(instanceId);
    }

    public void toggleCollapseFor(String nodeId) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)nodeIdVisitor);
        if (nodeIdVisitor.getNode() != null) {
            boolean isCollapsed = ((AsUiAction)nodeIdVisitor.getNode().getData()).isCollapseChildren();
            ((AsUiAction)nodeIdVisitor.getNode().getData()).setCollapseChildren(!isCollapsed);
        }
    }

    public void expandAll() {
        this.changeAllCollapseChildrenTo(false);
    }

    public void collapseAll() {
        this.changeAllCollapseChildrenTo(true);
    }

    private void changeAllCollapseChildrenTo(final boolean collapseChildren) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        TraversalVisitor<AsUiAction> visitor = new TraversalVisitor<AsUiAction>(){

            public void visit(AsUiAction asUiAction, Tree.Node<AsUiAction> node) {
                if (node.getParent() != null && node.getChildren() != null) {
                    ((AsUiAction)((AsUiAction)node.getData()).getNode().getData()).setCollapseChildren(collapseChildren);
                }
            }

            public boolean continueTraversal() {
                return true;
            }
        };
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
    }

    public List<String> getAuthSourcesInPolicy() {
        final LinkedList<String> authSources = new LinkedList<String>();
        PreOrderTraversal traversal = new PreOrderTraversal();
        final IdpAdapterManager adapterManager = MgmtFactory.getIdpAdapterManager();
        TraversalVisitor<AsUiAction> visitor = new TraversalVisitor<AsUiAction>(){

            public void visit(AsUiAction asUiAction, Tree.Node<AsUiAction> node) {
                if (asUiAction.getSelectedOption() != null) {
                    String connName;
                    if (AsActionOption.Type.ADAPTER.equals((Object)asUiAction.getSelectedOption().getType())) {
                        String adapter = ((IdpAuthnAdapterInstance)adapterManager.getInstance(asUiAction.getSelectedOption().getId())).getName();
                        if (!authSources.contains(adapter)) {
                            authSources.add(adapter);
                        }
                    } else if (AsActionOption.Type.CONNECTION.equals((Object)asUiAction.getSelectedOption().getType()) && !authSources.contains(connName = AbstractPolicyState.this.connManager.getIdpConnectionBySystemId(asUiAction.getSelectedOption().getId()).getName())) {
                        authSources.add(connName);
                    }
                }
            }

            public boolean continueTraversal() {
                return true;
            }
        };
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return authSources;
    }

    public List<String> getAuthSourcesShortList() {
        List<String> authSources = this.getAuthSourcesInPolicy();
        return authSources.subList(0, Math.min(3, authSources.size()));
    }

    public boolean isAuthSourceListTooLong() {
        return this.getAuthSourcesInPolicy().size() > 3;
    }

    public boolean isShowAdapterShortList() {
        if (this.showAdapterShortList == null) {
            this.showAdapterShortList = this.isAuthSourceListTooLong();
        }
        return this.showAdapterShortList;
    }

    public void setShowAdapterShortList(boolean showLongList) {
        this.showAdapterShortList = showLongList;
    }

    public boolean displayAdaptersShowLess() {
        return this.isAuthSourceListTooLong() && this.showAdapterShortList == false;
    }

    public List<String> getContractsInPolicy() {
        final LinkedList<String> contracts = new LinkedList<String>();
        PreOrderTraversal traversal = new PreOrderTraversal();
        final LocalIdentityManager lipManager = MgmtFactory.getLocalIdentityProfileManager();
        TraversalVisitor<AsUiAction> visitor = new TraversalVisitor<AsUiAction>(){

            public void visit(AsUiAction asUiAction, Tree.Node<AsUiAction> node) {
                LocalIdentityProfile profile;
                String contract;
                if (asUiAction.getSelectedOption() != null && AsActionOption.Type.AUTHN_POLICY_CONTRACT.equals((Object)asUiAction.getSelectedOption().getType())) {
                    String contract2 = AbstractPolicyState.this.contractManager.getContract(asUiAction.getSelectedOption().getId()).getName();
                    if (!contracts.contains(contract2)) {
                        contracts.add(contract2);
                    }
                } else if (asUiAction.getSelectedOption() != null && AsActionOption.Type.LOCAL_IDENTITY_PROFILE.equals((Object)asUiAction.getSelectedOption().getType()) && !contracts.contains(contract = AbstractPolicyState.this.contractManager.getContract((profile = lipManager.getProfile(asUiAction.getSelectedOption().getId())).getContractId()).getName())) {
                    contracts.add(contract);
                }
            }

            public boolean continueTraversal() {
                return true;
            }
        };
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return contracts;
    }

    public List<String> getContractsShortList() {
        List<String> contracts = this.getContractsInPolicy();
        return contracts.subList(0, Math.min(3, contracts.size()));
    }

    public boolean isContractsListTooLong() {
        return this.getContractsInPolicy().size() > 3;
    }

    public boolean isShowContractsShortList() {
        if (this.showContractShortList == null) {
            this.showContractShortList = this.isContractsListTooLong();
        }
        return this.showContractShortList;
    }

    public void setShowContractsShortList(boolean showLongList) {
        this.showContractShortList = showLongList;
    }

    public boolean displayContractsShowLess() {
        return this.isContractsListTooLong() && this.showContractShortList == false;
    }

    public List<String> getFragmentsInPolicy() {
        final LinkedList<String> fragments = new LinkedList<String>();
        PreOrderTraversal traversal = new PreOrderTraversal();
        final PolicyFragmentManager fragmentManager = MgmtFactory.getPolicyFragmentManager();
        TraversalVisitor<AsUiAction> visitor = new TraversalVisitor<AsUiAction>(){

            public void visit(AsUiAction asUiAction, Tree.Node<AsUiAction> node) {
                String fragmentName;
                if (asUiAction.getSelectedOption() != null && AsActionOption.Type.FRAGMENT.equals((Object)asUiAction.getSelectedOption().getType()) && !fragments.contains(fragmentName = fragmentManager.getFragment(asUiAction.getSelectedOption().getId()).getName())) {
                    fragments.add(fragmentName);
                }
            }

            public boolean continueTraversal() {
                return true;
            }
        };
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return fragments;
    }

    public List<String> getFragmentsShortList() {
        List<String> fragments = this.getFragmentsInPolicy();
        return fragments.subList(0, Math.min(3, fragments.size()));
    }

    public boolean isFragmentsListTooLong() {
        return this.getFragmentsInPolicy().size() > 3;
    }

    public boolean isShowFragmentsShortList() {
        if (this.showFragmentShortList == null) {
            this.showFragmentShortList = this.isFragmentsListTooLong();
        }
        return this.showFragmentShortList;
    }

    public void setShowFragmentShortList(boolean showLongList) {
        this.showFragmentShortList = showLongList;
    }

    public boolean displayFragmentsShowLess() {
        return this.isFragmentsListTooLong() && this.showFragmentShortList == false;
    }

    public List<String> getSelectorsInPolicy() {
        final LinkedList<String> selectors = new LinkedList<String>();
        PreOrderTraversal traversal = new PreOrderTraversal();
        TraversalVisitor<AsUiAction> visitor = new TraversalVisitor<AsUiAction>(){

            public void visit(AsUiAction asUiAction, Tree.Node<AsUiAction> node) {
                String selectorName;
                if (asUiAction.getSelectedOption() != null && AsActionOption.Type.SELECTOR.equals((Object)asUiAction.getSelectedOption().getType()) && !selectors.contains(selectorName = ((AuthnSelectorInstance)AbstractPolicyState.this.selectorManager.getInstance(asUiAction.getSelectedOption().getId())).getName())) {
                    selectors.add(selectorName);
                }
            }

            public boolean continueTraversal() {
                return true;
            }
        };
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return selectors;
    }

    public List<String> getSelectorsShortList() {
        List<String> selectors = this.getSelectorsInPolicy();
        return selectors.subList(0, Math.min(3, selectors.size()));
    }

    public boolean isSelectorsListTooLong() {
        return this.getSelectorsInPolicy().size() > 3;
    }

    public boolean isShowSelectorsShortList() {
        if (this.showSelectorShortList == null) {
            this.showSelectorShortList = this.isSelectorsListTooLong();
        }
        return this.showSelectorShortList;
    }

    public void setShowSelectorShortList(boolean showLongList) {
        this.showSelectorShortList = showLongList;
    }

    public boolean displaySelectorsShowLess() {
        return this.isSelectorsListTooLong() && this.showSelectorShortList == false;
    }

    public void removeErrorsFor(String nodeId) {
        this.nodeIdsWithError.remove(nodeId);
        this.nodeIdsWithMappingErrors.remove(nodeId);
        this.ruleNodeIdsWithError.remove(nodeId);
        this.userIdNodesWithError.remove(nodeId);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (this.getParent().isModeCreate()) {
            this.id = id;
        }
    }

    private void updateAttributeRuleValues(String nodeId, List<AttributeRule> attrRules, boolean fallbackToSuccess) {
        AttributeRuleHolder holder = this.attributeRulesMap.get(nodeId);
        if (holder == null) {
            holder = new AttributeRuleHolder();
        }
        if (attrRules != null) {
            List<AttributeRule> uiRules = attrRules.stream().map(attributeRule -> this.getAttributeRulesForUi(attributeRule.clone())).collect(Collectors.toList());
            holder.setAttributeRules(uiRules);
        }
        holder.setDefaultSuccess(fallbackToSuccess);
        this.attributeRulesMap.put(nodeId, holder);
    }

    private void updateInputUserIdMaps(String nodeId, AttributeContractHolder inputUserIdMapping) {
        this.userIdNodesWithError.remove(nodeId);
        this.inputUserIdMappings.put(nodeId, inputUserIdMapping);
    }

    public void removeAttributeRulesAndMappings(Tree.Node<AsUiAction> node) {
        if (node == null) {
            return;
        }
        if (node.getData() != null) {
            String nodeId = ((AsUiAction)node.getData()).getNodeId();
            this.attributeRulesMap.remove(nodeId);
            this.apcMappingTaskletMap.remove(nodeId);
            this.lipMappingTaskletMap.remove(nodeId);
            this.fragmentMappingTaskletMap.remove(nodeId);
            this.availableSourceIdsMap.remove(nodeId);
            this.availableUpstreamAuthenticationSourcesMap.remove(nodeId);
            this.inputUserIdMappings.remove(nodeId);
            this.removeErrorsFor(nodeId);
        }
        if (node.getChildren() != null) {
            node.getChildren().forEach(this::removeAttributeRulesAndMappings);
        }
    }

    public void removeNodeError(Tree.Node<AsUiAction> node) {
        this.nodeIdsWithError.remove(((AsUiAction)node.getData()).getNodeId());
    }

    public boolean isShowAdvancedField(AsUiAction action) {
        if (action.getSelectedOption() != null && action.getSelectedOption().getType() == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
            return this.apcMappingTaskletMap.get(action.getNodeId()) != null;
        }
        return false;
    }

    public boolean isShowLipMappingField(AsUiAction action) {
        if (action.getSelectedOption() != null && action.getSelectedOption().getType() == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
            return this.lipMappingTaskletMap.get(action.getNodeId()) != null;
        }
        return false;
    }

    public boolean isShowFragmentMapping(AsUiAction action) {
        if (action.getSelectedOption() != null && action.getSelectedOption().getType() == AsActionOption.Type.FRAGMENT) {
            return this.fragmentMappingTaskletMap.get(action.getNodeId()) != null;
        }
        return false;
    }

    public boolean isShowDone(AsUiAction action) {
        return action.hasAuthnSourceAncestor();
    }

    public boolean isSelectedOptionFragmentNode(AsUiAction action) {
        if (action != null && action.getSelectedOption() != null) {
            return AsActionOption.Type.FRAGMENT.equals((Object)action.getSelectedOption().getType());
        }
        return false;
    }

    public boolean isMappableSource(AsUiAction action, boolean v2OnlyAdapters) {
        if (action != null && action.getSelectedOption() != null && action.getSelectedOption().getId() != null) {
            switch (action.getSelectedOption().getType()) {
                case CONNECTION: {
                    return AuthenticationPoliciesUtil.isAllowInputUserIdMappingForIdpConnection((String)action.getSelectedOption().getId());
                }
                case ADAPTER: {
                    return AuthenticationPoliciesUtil.isAllowInputUserIdMappingForAdapter((String)action.getSelectedOption().getId(), (boolean)v2OnlyAdapters);
                }
                case FRAGMENT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isAuthnSource(AsUiAction action) {
        if (action != null && action.getSelectedOption() != null && action.getSelectedOption().getId() != null) {
            switch (action.getSelectedOption().getType()) {
                case ADAPTER: 
                case CONNECTION: 
                case FRAGMENT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void showApcState(String nodeId, IRequestCycle cycle) {
        AsActionOption option;
        String c2cId;
        Tree<AsUiAction> tree = this.authnSelectionTree;
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        if (nodeIdVisitor.getNode() != null && (c2cId = (option = ((AsUiAction)nodeIdVisitor.getNode().getData()).getSelectedOption()).getId()) != null) {
            Tree.Node<AsUiAction> node = nodeIdVisitor.getNode();
            APCMappingTasklet apcMappingTasklet = this.apcMappingTaskletMap.get(nodeId);
            if (apcMappingTasklet == null) {
                apcMappingTasklet = this.getApcMappingTasklet(c2cId, node, ((AsUiAction)node.getData()).getApcAttributeMapping());
            }
            apcMappingTasklet.resetCurrentStateToSourceState();
            this.loadTasklet(apcMappingTasklet);
            apcMappingTasklet.gotoSummaryState(cycle);
        }
    }

    public void showFragmentMapping(String nodeId, IRequestCycle cycle) {
        AsActionOption option;
        String fragmentId;
        Tree<AsUiAction> tree = this.authnSelectionTree;
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        if (nodeIdVisitor.getNode() != null && (fragmentId = (option = ((AsUiAction)nodeIdVisitor.getNode().getData()).getSelectedOption()).getId()) != null) {
            Tree.Node<AsUiAction> node = nodeIdVisitor.getNode();
            FragmentMappingTasklet fragmentMappingTasklet = this.fragmentMappingTaskletMap.get(nodeId);
            if (fragmentMappingTasklet == null) {
                fragmentMappingTasklet = this.getFragmentMappingTasklet(fragmentId, node, ((AsUiAction)node.getData()).getFragmentMapping());
            }
            fragmentMappingTasklet.resetCurrentStateToSourceState();
            this.loadTasklet(fragmentMappingTasklet);
            fragmentMappingTasklet.gotoSummaryState(cycle);
        }
    }

    public void showLipState(String nodeId, IRequestCycle cycle) {
        AsActionOption option;
        String lipId;
        Tree<AsUiAction> tree = this.authnSelectionTree;
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(tree, (TraversalVisitor)nodeIdVisitor);
        if (nodeIdVisitor.getNode() != null && (lipId = (option = ((AsUiAction)nodeIdVisitor.getNode().getData()).getSelectedOption()).getId()) != null) {
            Tree.Node<AsUiAction> node = nodeIdVisitor.getNode();
            LocalIdentityProfileMappingTasklet registrationMappingTasklet = this.lipMappingTaskletMap.get(nodeId);
            if (registrationMappingTasklet == null) {
                registrationMappingTasklet = this.getLipMappingTasklet(lipId, node, ((AsUiAction)node.getData()).getLocalIdentityMappingAction());
            }
            registrationMappingTasklet.resetCurrentStateToSourceState();
            this.loadTasklet(registrationMappingTasklet);
            registrationMappingTasklet.gotoSummaryState(cycle);
        }
    }

    public Map<String, APCMappingTasklet> getApcMappingTaskletMap() {
        return this.apcMappingTaskletMap;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes(AsUiAction asUiAction) {
        ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig> searchableTypes = new ArrayList<FilterableSelectionFieldDescriptor.SearchableTypeConfig>();
        if (this.isIdpEnabled) {
            searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_ADAPTER);
        }
        if (this.isSpEnabled) {
            List<FilterableSelectionFieldDescriptor.QueryParam> queryParams = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("spInitSSO", "true"));
            searchableTypes.add(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.IDP_CONNECTION, queryParams));
        }
        searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.SELECTOR);
        searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.POLICY_FRAGMENT);
        return searchableTypes;
    }

    public boolean isExpandAllDisabled() {
        AllChildrenExpandedVisitor visitor = new AllChildrenExpandedVisitor();
        PreOrderTraversal traversal = new PreOrderTraversal();
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return visitor.allAreChildrenExpanded();
    }

    public boolean isCollapseAllDisabled() {
        AllChildrenCollapsedVisitor visitor = new AllChildrenCollapsedVisitor();
        PreOrderTraversal traversal = new PreOrderTraversal();
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)visitor);
        return visitor.areAllChildrenCollapsed();
    }

    public boolean getIsInputSelectionRequired(AsUiAction asUiAction) {
        return asUiAction.getSelectedOption() == null;
    }

    public Tree<AsUiAction> getAuthnSelectionTree() {
        return this.authnSelectionTree;
    }

    public List<TreeHelper.NodeWrapper<AsUiAction>> getAuthnSelectionList() {
        return this.authnSelectionList;
    }

    public TreeHelper.NodeWrapper<AsUiAction> getRootNode() {
        return this.authnSelectionList.get(0);
    }

    public boolean isShowCollapse(int index) {
        TreeHelper.NodeWrapper<AsUiAction> node = this.authnSelectionList.get(index);
        return ((AsUiAction)node.getNode().getData()).getSelectedOption() != null && node.getNode().getParent() != null && node.getNode().getChildren() != null && !node.getNode().getChildren().isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            name = name.trim();
        }
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract String getTypeString();

    public void copyTree(String nodeId) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor findNodeByIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findNodeByIdVisitor);
        Tree.Node<AsUiAction> copyNode = findNodeByIdVisitor.getNode();
        Tree.Node<AuthnSelectionAction> domainNode = this.createCopiedDomainTree(copyNode);
        Tree copiedTree = new Tree(domainNode);
        this.copyAndPastePolicyManager.saveTree((Tree<AuthnSelectionAction>)copiedTree);
    }

    public List<String> pasteTree(String nodeId) {
        PreOrderTraversal traversal = new PreOrderTraversal();
        FindNodeByIdVisitor nodeByIdVisitor = new FindNodeByIdVisitor(nodeId);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)nodeByIdVisitor);
        Tree<AuthnSelectionAction> copyTree = this.copyAndPastePolicyManager.getCopiedTree();
        FindDeletedPolicyNodesVisitor findDeletedPolicyNodesVisitor = new FindDeletedPolicyNodesVisitor(this.contractManager, this.idpAdapterManager, this.connManager, this.policyFragmentManager, this.localIdentityManager, this.selectorManager);
        traversal.traverse(copyTree, (TraversalVisitor)findDeletedPolicyNodesVisitor);
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (!findDeletedPolicyNodesVisitor.isRootValid()) {
            String error = "The root node of the copied tree is no longer valid. Nothing has been pasted.";
            errorMessages.add(error);
            return errorMessages;
        }
        this.copyAndPastePolicyManager.addValidationErrors(findDeletedPolicyNodesVisitor.getErrorMessages());
        Tree<AsUiAction> uiCopyTree = this.buildUiTree((Tree.Node<AuthnSelectionAction>)copyTree.getRootNode());
        Tree.Node<AsUiAction> nodeToPasteInto = nodeByIdVisitor.getNode();
        if (nodeToPasteInto != null) {
            Tree.Node copyRootNode = uiCopyTree.getRootNode();
            Tree.Node parent = nodeToPasteInto.getParent();
            if (parent != null) {
                int index = parent.getChildren().indexOf(nodeToPasteInto);
                LinkedList newChildren = new LinkedList();
                newChildren.addAll(parent.getChildren());
                parent.getChildren().clear();
                newChildren.set(index, copyRootNode);
                ((AsUiAction)copyRootNode.getData()).setResultContext(((AsUiAction)nodeToPasteInto.getData()).getResultContext());
                AttributeRuleHolder attributeRuleHolder = this.attributeRulesMap.get(((AsUiAction)parent.getData()).getNodeId());
                if (attributeRuleHolder != null) {
                    attributeRuleHolder.getAttributeRules().stream().filter(attributeRule -> attributeRule.getNodeId().equals(((AsUiAction)nodeToPasteInto.getData()).getNodeId())).findAny().ifPresent(attributeRule -> attributeRule.setNodeId(((AsUiAction)copyRootNode.getData()).getNodeId()));
                }
                Iterator<Object> iterator = newChildren.iterator();
                while (iterator.hasNext()) {
                    Tree.Node child = (Tree.Node)iterator.next();
                    parent.addChildNode(child);
                }
            } else {
                this.authnSelectionTree = uiCopyTree;
            }
            ((AsUiAction)copyRootNode.getData()).setResultContext(((AsUiAction)nodeToPasteInto.getData()).getResultContext());
            this.updatePossibleAttributeSourceOptions(nodeToPasteInto);
        }
        boolean nodesRemoved = false;
        if (this instanceof PolicyFragmentState) {
            boolean continueNodesRemoved = this.removeNodesOfType(this.authnSelectionTree, AsActionOption.Type.CONTINUE);
            boolean restartNodesRemoved = this.removeNodesOfType(this.authnSelectionTree, AsActionOption.Type.RESTART);
            nodesRemoved = continueNodesRemoved || restartNodesRemoved;
        }
        FindNodesByTypeNodeVisitor findContinueNodesVisitor = new FindNodesByTypeNodeVisitor(AsActionOption.Type.CONTINUE);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findContinueNodesVisitor);
        List<Tree.Node<AsUiAction>> continueNodes = findContinueNodesVisitor.getNodes();
        for (Tree.Node node : continueNodes) {
            if (!((AsUiAction)node.getData()).hasAuthnSourceAncestor()) continue;
            ((AsUiAction)node.getData()).setSelectedOption(null);
            nodesRemoved = true;
        }
        FindNodesByTypeNodeVisitor findApcNodesVisitor = new FindNodesByTypeNodeVisitor(AsActionOption.Type.AUTHN_POLICY_CONTRACT);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findApcNodesVisitor);
        List<Tree.Node<AsUiAction>> list = findApcNodesVisitor.getNodes();
        for (Tree.Node<AsUiAction> apcNode : list) {
            PolicyBranchUtil policyBranchUtil = new PolicyBranchUtil(apcNode);
            if (policyBranchUtil.isSuccessPath()) continue;
            ((AsUiAction)apcNode.getData()).setSelectedOption(null);
            nodesRemoved = true;
        }
        FindNodesByTypeNodeVisitor findLipNodesVisitor = new FindNodesByTypeNodeVisitor(AsActionOption.Type.LOCAL_IDENTITY_PROFILE);
        traversal.traverse(this.authnSelectionTree, (TraversalVisitor)findLipNodesVisitor);
        List<Tree.Node<AsUiAction>> lipNodes = findLipNodesVisitor.getNodes();
        for (Tree.Node<AsUiAction> lipNode : lipNodes) {
            LocalIdentityBranchUtil branchUtil = new LocalIdentityBranchUtil(lipNode);
            if (!branchUtil.isRegistrationBranch() && !branchUtil.isSuccessPath()) {
                ((AsUiAction)lipNode.getData()).setSelectedOption(null);
                nodesRemoved = true;
                continue;
            }
            this.lipMappingTaskletMap.get(((AsUiAction)lipNode.getData()).getNodeId()).setBranchUtil(branchUtil);
        }
        if (nodesRemoved) {
            errorMessages.add("Invalid nodes were removed from the pasted policy tree.");
        }
        errorMessages.addAll(this.copyAndPastePolicyManager.getValidationErrors());
        return errorMessages;
    }

    public boolean removeNodesOfType(Tree tree, AsActionOption.Type type) {
        boolean nodesRemoved = false;
        FindNodesByTypeNodeVisitor findNodesByTypeNodeVisitor = new FindNodesByTypeNodeVisitor(type);
        PreOrderTraversal traversal = new PreOrderTraversal();
        traversal.traverse(tree, (TraversalVisitor)findNodesByTypeNodeVisitor);
        if (!findNodesByTypeNodeVisitor.getNodes().isEmpty()) {
            for (Tree.Node<AsUiAction> nodeToNullOut : findNodesByTypeNodeVisitor.getNodes()) {
                ((AsUiAction)nodeToNullOut.getData()).setSelectedOption(null);
                nodesRemoved = true;
            }
        }
        return nodesRemoved;
    }

    public boolean isShowCopy(AsUiAction node) {
        return node != null && node.getSelectedOption() != null && !this.getVisit().getCurrentUser().isAuditor();
    }

    public boolean isShowPaste(AsUiAction node) {
        boolean isEmptyNode = false;
        if (node == null || node.getSelectedOption() == null) {
            isEmptyNode = true;
        }
        return this.getVisit().getCopyAndPastePolicyManager().hasCopiedTree() && isEmptyNode && !this.getVisit().getCurrentUser().isAuditor();
    }

    public boolean isSelector(AsUiAction action) {
        if (action != null && action.getSelectedOption() != null && action.getSelectedOption().getId() != null) {
            switch (action.getSelectedOption().getType()) {
                case SELECTOR: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Tree.Node<AuthnSelectionAction> createCopiedDomainTree(Tree.Node<AsUiAction> uiNode) {
        Stack<Tree.Node> uiNodeStack = new Stack<Tree.Node>();
        Stack<Tree.Node> domainParentNodeStack = new Stack<Tree.Node>();
        Tree.Node domainRootNode = null;
        Tree.Node parentDomainNode = null;
        Tree.Node newDomainNode = null;
        while (uiNode != null) {
            NoOpAction domainAction;
            AsUiAction uiAction = (AsUiAction)uiNode.getData();
            AsActionOption selectedOption = uiAction.getSelectedOption();
            if (selectedOption != null) {
                List<AttributeRule> attrRules;
                AuthnSourceAction asa;
                AsActionOption.Type optionType = selectedOption.getType();
                if (optionType == AsActionOption.Type.SELECTOR) {
                    domainAction = new AuthnSelectorAction(selectedOption.getId());
                } else if (optionType == AsActionOption.Type.ADAPTER || optionType == AsActionOption.Type.CONNECTION) {
                    asa = optionType == AsActionOption.Type.ADAPTER ? new AuthnSourceAction((AuthnSourceKey)new AdapterAuthnSourceKey(selectedOption.getId())) : new AuthnSourceAction((AuthnSourceKey)new IdpConnAuthnSourceKey(selectedOption.getId()));
                    attrRules = uiAction.getAttributeRules();
                    if (CollectionUtils.isNotEmpty(attrRules)) {
                        asa.setAttributeRules(attrRules);
                        asa.setFallbackToSuccess(uiAction.isFallBackToDefaultSuccess());
                    } else {
                        asa.setFallbackToSuccess(true);
                    }
                    if (uiAction.getInputUserIdMapping() != null) {
                        asa.setInputUserIdMapping(uiAction.getInputUserIdMapping());
                        asa.setUserIdAuthenticated(uiAction.isUserIdAuthenticated());
                    }
                    domainAction = asa;
                } else if (optionType == AsActionOption.Type.AUTHN_POLICY_CONTRACT) {
                    asa = new ApcMappingAction(selectedOption.getId(), null);
                    domainAction = asa;
                    APCMappingTasklet apcMappingTasklet = this.apcMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (apcMappingTasklet != null && apcMappingTasklet.getMappingModel() != null) {
                        asa.setAttributeMapping(apcMappingTasklet.getMappingModel().getMapping());
                    }
                } else if (optionType == AsActionOption.Type.LOCAL_IDENTITY_PROFILE) {
                    LocalIdentityMappingAction localIdentityMappingAction = new LocalIdentityMappingAction(selectedOption.getId(), null, null);
                    domainAction = localIdentityMappingAction;
                    LocalIdentityProfileMappingTasklet lipMappingTasklet = this.lipMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (lipMappingTasklet != null) {
                        localIdentityMappingAction.setInboundAttributeMapping(lipMappingTasklet.getInboundAttributeMapping());
                        localIdentityMappingAction.setOutboundAttributeMapping(lipMappingTasklet.getOutboundAttributeMapping());
                        lipMappingTasklet.setLocalIdentityMappingAction(localIdentityMappingAction);
                    }
                } else if (optionType == AsActionOption.Type.FRAGMENT) {
                    FragmentAction fragmentAction = new FragmentAction(selectedOption.getId());
                    attrRules = uiAction.getAttributeRules();
                    if (CollectionUtils.isNotEmpty(attrRules)) {
                        fragmentAction.setAttributeRules((List)attrRules);
                        fragmentAction.setFallbackToSuccess(uiAction.isFallBackToDefaultSuccess());
                    } else {
                        fragmentAction.setFallbackToSuccess(true);
                    }
                    FragmentMappingTasklet fragmentMappingTasklet = this.fragmentMappingTaskletMap.get(((AsUiAction)uiNode.getData()).getNodeId());
                    if (fragmentMappingTasklet != null && fragmentMappingTasklet.getMappingModel() != null) {
                        fragmentAction.setAttributeMapping(fragmentMappingTasklet.getMappingModel().getMapping());
                    }
                    domainAction = fragmentAction;
                } else if (optionType == AsActionOption.Type.CONTINUE) {
                    domainAction = new NoOpAction(NoOpAction.Type.CONTINUE);
                } else if (optionType == AsActionOption.Type.RESTART) {
                    domainAction = new NoOpAction(NoOpAction.Type.RESTART);
                } else {
                    if (optionType != AsActionOption.Type.DONE) throw new IllegalStateException("Unrecognized action type");
                    domainAction = new NoOpAction(NoOpAction.Type.DONE);
                }
            } else {
                domainAction = new NoOpAction(NoOpAction.Type.EMPTY);
            }
            domainAction.setContext(uiAction.getResultContext());
            newDomainNode = new Tree.Node((Object)domainAction);
            if (domainRootNode == null) {
                domainRootNode = newDomainNode;
            }
            if (parentDomainNode != null) {
                parentDomainNode.addChildNode(newDomainNode);
            }
            if (uiNode.hasChildren()) {
                boolean first = true;
                LinkedList<Tree.Node> otherChildren = new LinkedList<Tree.Node>();
                for (Tree.Node childNode : uiNode.getChildren()) {
                    if (first) {
                        uiNode = childNode;
                        first = false;
                        parentDomainNode = newDomainNode;
                        continue;
                    }
                    otherChildren.add(childNode);
                }
                Iterator reverseChildIt = otherChildren.descendingIterator();
                while (reverseChildIt.hasNext()) {
                    uiNodeStack.push((Tree.Node)reverseChildIt.next());
                    domainParentNodeStack.push(parentDomainNode);
                }
                continue;
            }
            if (uiNodeStack.isEmpty()) {
                uiNode = null;
                continue;
            }
            uiNode = (Tree.Node)uiNodeStack.pop();
            parentDomainNode = (Tree.Node)domainParentNodeStack.pop();
        }
        return domainRootNode;
    }

    public static String getAuthnSourceKey(String sourceId, SourceType sourceType) {
        return sourceId + "|" + sourceType.name();
    }

    public static SourceType getSourceTypeFromAuthnSourceKey(String authnSourceKey) {
        return SourceType.valueOf((String)authnSourceKey.substring(authnSourceKey.lastIndexOf("|") + 1));
    }

    public static String getSourceIdFromAuthnSourceKey(String authnSourceKey) {
        return authnSourceKey.substring(0, authnSourceKey.lastIndexOf("|"));
    }

    public static String getAuthnSourceKey(String sourceId, AsActionOption.Type type) {
        SourceType sourceType;
        switch (type) {
            case ADAPTER: {
                sourceType = SourceType.ADAPTER;
                break;
            }
            case CONNECTION: {
                sourceType = SourceType.IDP_CONNECTION;
                break;
            }
            case FRAGMENT: {
                sourceType = SourceType.FRAGMENT;
                break;
            }
            default: {
                sourceType = SourceType.valueOf((String)type.name());
            }
        }
        return AbstractPolicyState.getAuthnSourceKey(sourceId, sourceType);
    }

    public static class AttributeRuleHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<AttributeRule> attributeRules = new ArrayList<AttributeRule>();
        private Boolean defaultSuccess;

        public List<AttributeRule> getAttributeRules() {
            return this.attributeRules;
        }

        public void setAttributeRules(List<AttributeRule> attributeRules) {
            this.attributeRules = attributeRules;
        }

        public Boolean getDefaultSuccess() {
            return this.defaultSuccess;
        }

        public void setDefaultSuccess(Boolean defaultSuccess) {
            this.defaultSuccess = defaultSuccess;
        }
    }
}

