/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.PluginFieldValidator;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.HashedField;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.HashedTextFieldDescriptor;

public abstract class AdapterActionState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    protected List<ActionDescriptor> actions = Collections.emptyList();
    protected boolean isDownload;
    protected String downloadContentType;
    protected String downloadFilename;
    protected List<List<FieldItem>> fieldItems = Collections.emptyList();
    protected List<String> invocationResults;
    protected int selectedActionIndex = -1;
    protected boolean hasSetActionIndex = false;

    public AdapterActionState(IWizard owner) {
        super(owner, "adapterAction");
        this.setMenuName("Actions");
    }

    public void buildActionList(GuiConfigDescriptor guiConfigDescriptor) {
        this.actions = guiConfigDescriptor.getActions();
        this.fieldItems = new ArrayList<List<FieldItem>>(this.actions.size());
        this.invocationResults = new ArrayList<Object>(Collections.nCopies(this.actions.size(), null));
        this.buildFieldItemsList();
    }

    protected abstract void invoke(int var1);

    public List<ActionDescriptor> getActions() {
        return this.actions;
    }

    @Override
    public void reset() {
        this.isDownload = false;
        this.downloadContentType = null;
        this.downloadFilename = null;
        this.selectedActionIndex = -1;
        this.hasSetActionIndex = false;
        this.invocationResults = new ArrayList<Object>(Collections.nCopies(this.actions.size(), null));
        this.buildFieldItemsList();
    }

    public boolean isShowResult() {
        return this.hasAnyInvocationResult() && !this.isDownload;
    }

    public boolean isShowDownload() {
        return this.hasAnyInvocationResult() && this.isDownload;
    }

    public boolean isShowAction() {
        return !this.isShowResult() && !this.isShowDownload();
    }

    @Override
    public void onStateActivated() {
        this.hasSetActionIndex = false;
    }

    @Override
    public boolean onStateExit() {
        this.reset();
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (ActionDescriptor action : this.actions) {
            summaryList.add(new SummaryInfo(action.getName(), action.getDescription(), this));
        }
    }

    public String getDownloadContentType() {
        return this.downloadContentType;
    }

    public String getDownloadFilename() {
        return this.downloadFilename;
    }

    public byte[] getDownloadBytes() {
        try {
            return this.invocationResults.get(this.selectedActionIndex).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.selectedActionIndex != -1 && this.hasSetActionIndex) {
            this.hasSetActionIndex = false;
            List<String> errorMessages = this.validateFieldItems();
            if (!errorMessages.isEmpty()) {
                this.delegate.setFormComponent(null);
                errorMessages.forEach(errorMessage -> this.delegate.record(errorMessage, ValidationConstraint.CONSISTENCY));
            } else {
                this.invoke(this.selectedActionIndex);
            }
        }
    }

    public boolean hasConfigurableFields() {
        return this.fieldItems.stream().anyMatch(fieldItem -> !fieldItem.isEmpty());
    }

    public List<FieldItem> getFieldItems(int actionIndex) {
        return this.fieldItems.get(actionIndex);
    }

    public int getSelectedActionIndex() {
        return this.selectedActionIndex;
    }

    public void setSelectedActionIndex(int selectedActionIndex) {
        this.selectedActionIndex = selectedActionIndex;
        this.hasSetActionIndex = true;
    }

    protected SimpleFieldList getSimpleFieldList(int actionIndex) {
        return new SimpleFieldList(this.getConfiguredFields(actionIndex));
    }

    public String getInvocationResult(int actionIndex) {
        return this.invocationResults.get(actionIndex);
    }

    private boolean hasAnyInvocationResult() {
        return this.invocationResults.stream().anyMatch(Objects::nonNull);
    }

    private void buildFieldItemsList() {
        this.fieldItems.clear();
        for (ActionDescriptor actionDesc : this.actions) {
            ArrayList<FieldItem> actionFieldItems = new ArrayList<FieldItem>();
            for (FieldDescriptor fieldDesc : actionDesc.getParameters()) {
                FieldItem fieldItem = new FieldItem(fieldDesc);
                if (fieldDesc.getDefaultValue() != null) {
                    fieldItem.setValue(fieldDesc.getDefaultValue());
                }
                actionFieldItems.add(fieldItem);
            }
            this.fieldItems.add(actionFieldItems);
        }
    }

    private List<String> validateFieldItems() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (FieldItem fieldItem : this.fieldItems.get(this.selectedActionIndex)) {
            PluginFieldValidator fieldValidator = new PluginFieldValidator(fieldItem.getFieldDescriptor(), this.buildField(fieldItem), "", null);
            if (fieldValidator.validate()) continue;
            fieldValidator.getErrors().forEach(validationError -> errorMessages.add(validationError.getMessage()));
        }
        return errorMessages;
    }

    private List<Field> getConfiguredFields(int actionIndex) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldItem fieldItem : this.getFieldItems(actionIndex)) {
            FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
            if (fieldDescriptor == null) continue;
            Field field = this.buildField(fieldItem);
            fields.add(field);
        }
        return fields;
    }

    private Field buildField(FieldItem fieldItem) {
        FieldDescriptor fieldDesc = fieldItem.getFieldDescriptor();
        Object field = fieldDesc instanceof HashedTextFieldDescriptor ? new HashedField(fieldDesc.getName(), fieldItem.getHashValue(), fieldItem.getValue()) : new Field(fieldDesc.getName(), fieldDesc.getLabel(), fieldItem.getValue());
        return field;
    }
}

