/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.FieldItem;
import com.pingidentity.component.common.SimpleFieldDescriptor;
import com.pingidentity.component.common.TableEditor;
import com.pingidentity.component.common.TableRow;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.websso.Protocol;

public class AdditionalIssuersState
extends TaskletState
implements TableEditor.TableEditorListener {
    private static final long serialVersionUID = 2L;
    private boolean allowAllIssuersEnabled = false;
    private List<TableRow> additionalIssuersTableRows = new ArrayList<TableRow>();
    private static final SimpleFieldDescriptor ADDITIONAL_ISSUER = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Additional Issuer", 300);
    private static final SimpleFieldDescriptor ADDITIONAL_ISSUER_DESCRIPTION = new SimpleFieldDescriptor(SimpleFieldDescriptor.FieldType.TEXT, "Description", 400);
    private transient Object componentState;

    public AdditionalIssuersState(Tasklet parent) {
        super(parent);
        this.setMenuName("Additional Issuers");
    }

    private IdpConnection getOIDCIdpConnection(Object dataObject) {
        ConnectionBase connection = (ConnectionBase)dataObject;
        if (connection != null && connection instanceof IdpConnection && this.isOidc()) {
            return (IdpConnection)connection;
        }
        return null;
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConnection oidcIdpConnection = this.getOIDCIdpConnection(dataFromDisk);
        if (oidcIdpConnection != null && oidcIdpConnection.isAllowAdditionalEntities()) {
            this.setAllowAllIssuersEnabled(oidcIdpConnection.isAllowAllEntities());
            if (!this.isAllowAllIssuersEnabled()) {
                for (Entity issuer : oidcIdpConnection.getAdditionalAllowedEntities()) {
                    this.additionalIssuersTableRows.add(new TableRow(Arrays.asList(new FieldItem(ADDITIONAL_ISSUER, issuer.getEntityId()), new FieldItem(ADDITIONAL_ISSUER_DESCRIPTION, issuer.getEntityDescription()))));
                }
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection idpConnection = this.getOIDCIdpConnection(dataToDisk);
        if (idpConnection != null && this.isAdditionalIssuersEnabled()) {
            idpConnection.setAllowAllEntities(this.isAllowAllIssuersEnabled());
            if (!this.isAllowAllIssuersEnabled()) {
                idpConnection.setAdditionalAllowedEntities(this.getAdditionalIssuers());
            }
        }
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.isAdditionalIssuersEnabled()) {
            summaryList.add(new SummaryInfo("Accept All Issuers Enabled", Boolean.valueOf(this.isAllowAllIssuersEnabled()).toString(), this));
            if (!this.isAllowAllIssuersEnabled()) {
                for (Entity entry : this.getAdditionalIssuers()) {
                    summaryList.add(new SummaryInfo("Additional Issuer", entry.getEntityId() + (String)(StringUtils.isBlank((String)entry.getEntityDescription()) ? "" : " - " + entry.getEntityDescription()), this));
                }
            }
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public List<SimpleFieldDescriptor> getAdditionalIssuersDescriptors() {
        return Arrays.asList(ADDITIONAL_ISSUER, ADDITIONAL_ISSUER_DESCRIPTION);
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<TableRow> getAdditionalIssuersTableRows() {
        return this.additionalIssuersTableRows;
    }

    public void setAdditionalIssuersTableRows(List<TableRow> additionalIssuersTableRows) {
        this.additionalIssuersTableRows = additionalIssuersTableRows;
    }

    @Override
    public List<String> validate(TableRow row, TableRow originalRow, List<TableRow> list, TableEditor owner) {
        ArrayList<String> validationErrorMessages = new ArrayList<String>();
        if (row.getFields().get(0).getValue().trim().equals(this.getPrimaryIssuer().trim())) {
            validationErrorMessages.add("The primary issuer is always accepted during issuer claim validation.");
        }
        if (this.containDuplicate(list, row, originalRow)) {
            validationErrorMessages.add("Duplicate issuers are not allowed.");
        }
        if (!ValidationUtil.isValidHttpsUrl((String)row.getFields().get(0).getValue().trim())) {
            validationErrorMessages.add("Issuer is malformed. URL must be a valid url with https schema.");
        }
        return validationErrorMessages;
    }

    @Override
    public void onAddItem(TableEditor owner, TableRow newRow) {
    }

    @Override
    public void onUpdateItem(TableEditor owner, TableRow originalRow, TableRow updatedRow) {
    }

    private boolean isSameIssuer(TableRow updatedRow, TableRow originalRow) {
        return updatedRow.getFields().get(0).getValue().trim().equals(originalRow.getFields().get(0).getValue().trim());
    }

    private boolean containDuplicate(List<TableRow> existingRows, TableRow updatedRow, TableRow originalRow) {
        return (updatedRow.isNewRow() || !this.isSameIssuer(updatedRow, originalRow)) && existingRows.stream().anyMatch(existingRow -> this.isSameIssuer(updatedRow, (TableRow)existingRow));
    }

    public boolean isAllowAllIssuersEnabled() {
        return this.allowAllIssuersEnabled;
    }

    public void setAllowAllIssuersEnabled(boolean allowAllIssuersEnabled) {
        this.allowAllIssuersEnabled = allowAllIssuersEnabled;
    }

    public List<Entity> getAdditionalIssuers() {
        return this.additionalIssuersTableRows.stream().filter(issuer -> !issuer.isMarkedForDelete()).map(issuer -> new Entity(issuer.getFields().get(0).getValue(), issuer.getFields().get(1).getValue())).collect(Collectors.toList());
    }

    public String getPrimaryIssuer() {
        IdpConnectionConfigTasklet tasklet = this.getParent(IdpConnectionConfigTasklet.class);
        return tasklet.getConnId();
    }

    public boolean isAdditionalIssuersEnabled() {
        IdpConnectionConfigTasklet tasklet = this.getParent(IdpConnectionConfigTasklet.class);
        return tasklet.isAdditionalIssuersEnabled();
    }

    private boolean isOidc() {
        ConnectionTasklet tasklet = this.getParent(ConnectionTasklet.class);
        return tasklet.isBrowserSsoProfileEnabled() && tasklet.getProtocolType() == Protocol.OIDC;
    }
}

