/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.filter.ConnectionFilter;
import org.sourceid.saml20.domain.util.filter.FilterCriteria;
import org.sourceid.saml20.domain.validation.CommonValidator;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.Protocol;

public class AffiliationGeneralInfoState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String selectedConnectionDisplayName;
    private String affiliationId;
    private String id;
    private String selectedOwnerId;
    private String selectedConnectionTypeAndId;
    private List<String> allSpConnections = new ArrayList<String>();

    public AffiliationGeneralInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("Affiliation General Info");
    }

    @Override
    public void onStateActivated() {
        this.configureLists();
    }

    @Override
    public void populate(Object dataFromDisk) {
        Affiliation affiliation = (Affiliation)dataFromDisk;
        if (affiliation != null) {
            this.affiliationId = affiliation.getAffiliationId();
            this.selectedOwnerId = affiliation.getAffiliationOwnerId();
            this.id = affiliation.getId();
        }
        this.configureLists();
    }

    @Override
    public boolean populateAllStates(Object importedAffiliation) {
        this.populate(importedAffiliation);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        Affiliation affiliation = (Affiliation)dataToDisk;
        affiliation.setAffiliationId(this.affiliationId);
        affiliation.setAffiliationOwnerId(this.selectedOwnerId);
        affiliation.setId(this.id);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        String connectionName = this.selectedOwnerId;
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        SpConnection connection = connectionManager.getSpConnection(this.selectedOwnerId);
        if (connection != null) {
            connectionName = connection.getName();
        }
        summaryList.add(new SummaryInfo(this.getMessage("Affiliation_id"), this.affiliationId, this));
        summaryList.add(new SummaryInfo(this.getMessage("Affiliation_owner"), connectionName, this));
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.affiliationId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Affiliation_id_required"), ValidationConstraint.REQUIRED);
        }
        if (!CommonValidator.isValidEntityId((String)this.affiliationId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Affiliation_id_malformed"), ValidationConstraint.REQUIRED);
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        for (Affiliation affiliation : connectionManager.getAffiliations()) {
            if (!affiliation.getAffiliationId().equals(this.affiliationId) || affiliation.getId().equals(this.id)) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Affiliation_id_duplicate"), ValidationConstraint.REQUIRED);
            break;
        }
        for (SpConnection conn : connectionManager.getFilteredSpConnections()) {
            if (!conn.getEntityId().equals(this.affiliationId)) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Affiliation_id_duplicate_with_sp"), ValidationConstraint.REQUIRED);
            break;
        }
        if (StringUtils.isBlank((String)this.selectedOwnerId)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Owner_required"), ValidationConstraint.REQUIRED);
        }
    }

    private void configureLists() {
        this.allSpConnections = new ArrayList<String>();
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        FilterCriteria idpCriteria = new FilterCriteria();
        idpCriteria.setRoles(new Role[]{Role.SP});
        idpCriteria.setProtocols(new Protocol[]{Protocol.SAML20});
        ConnectionFilter spFilter = new ConnectionFilter(idpCriteria);
        for (ConnectionBase cb : spFilter.filter(connectionManager.getAllConnections())) {
            this.allSpConnections.add(cb.getEntityId());
        }
    }

    public String getAffiliationId() {
        return this.affiliationId;
    }

    public void setAffiliationId(String affiliationId) {
        this.affiliationId = affiliationId;
    }

    public String getSelectedConnectionTypeAndId() {
        if (this.selectedConnectionTypeAndId == null && this.selectedOwnerId != null) {
            this.selectedConnectionTypeAndId = "SP Connections-" + this.selectedOwnerId;
        }
        return this.selectedConnectionTypeAndId;
    }

    public void setSelectedConnectionTypeAndId(String selectedConnectionTypeAndId) {
        SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedConnectionTypeAndId);
        this.selectedOwnerId = option.getId();
        this.selectedConnectionTypeAndId = selectedConnectionTypeAndId;
    }

    public String getSelectedConnectionDisplayName() {
        if (!StringUtils.isBlank((String)this.selectedOwnerId)) {
            ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
            SpConnection conn = connectionManager.getSpConnection(this.selectedOwnerId);
            this.selectedConnectionDisplayName = conn.getName();
        }
        return this.selectedConnectionDisplayName;
    }

    public void setSelectedConnectionDisplayName(String selectedConnectionDisplayName) {
        this.selectedConnectionDisplayName = selectedConnectionDisplayName;
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        List<FilterableSelectionFieldDescriptor.QueryParam> list = Collections.singletonList(new FilterableSelectionFieldDescriptor.QueryParam("saml20Only", "true"));
        return Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.SP_CONNECTION, list));
    }
}

