/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.AffiliationItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public class AffiliationMgmtState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private List<AffiliationItem> affiliationList = new ArrayList<AffiliationItem>();
    private transient Object componentState;

    public AffiliationMgmtState(Tasklet value) {
        super(value);
        this.setMenuName("Manage Affiliations");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.affiliationList.clear();
        this.createAffiliationsList();
    }

    private void createAffiliationsList() {
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        Collection affiliations = connectionManager.getAffiliations();
        for (Affiliation affiliation : affiliations) {
            AffiliationItem item = new AffiliationItem(affiliation);
            if (this.getParent().showFinishButtonIfAuditor()) {
                item.setDisabled(true);
            }
            this.affiliationList.add(item);
        }
    }

    @Override
    public void refreshState() {
        this.populate(null);
    }

    public List<AffiliationItem> getAffiliationList() {
        return this.affiliationList;
    }

    public void setAffiliationList(ArrayList<AffiliationItem> affiliationList) {
        this.affiliationList = affiliationList;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }
}

