/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.MessageCustomizationCard;
import com.pingidentity.fsm.state.impl.ServiceEndpointState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.ServiceEndpointItem;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.SpConnection;

public class AssertionConsumerServiceState
extends ServiceEndpointState {
    private static final long serialVersionUID = 20050515L;
    private LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> messageHooks = new LinkedHashMap();
    private final Map<String, String> name2ContextMap;
    private final StringPairPropertySelectionModel hookTypes = new StringPairPropertySelectionModel();
    private boolean isEditingHook;
    private String selectedHookType;
    private String selectedHookExpr;
    private String linkContextName;

    public AssertionConsumerServiceState(Tasklet value) {
        super(value);
        super.setBaseBindings(new String[]{"Artifact", "POST"});
        this.setMenuName("Assertion Consumer Service URL");
        super.setShowBindingField(true);
        super.setShowEndpointUrlField(true);
        this.name2ContextMap = MessageCustomizationCard.getVarNameToContextMap(this.getIsWsFed(), this.getIsIdpConn());
    }

    @Override
    public void onStateActivated() {
        if (!this.isConnectionProtocol1x()) {
            super.setShowDefaultField(true);
            super.setShowIndexField(true);
        }
        if (this.hookTypes.getOptionCount() == 0) {
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        SpConnection sp = (SpConnection)data;
        IndexedEndpoints assertionConsumerServices = sp.getAssertionConsumerServiceEndpoints();
        this.populate(assertionConsumerServices);
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        SpConnection sp = (SpConnection)dataFromDisk;
        IndexedEndpoints assertionConsumerServices = sp.getAssertionConsumerServiceEndpoints();
        this.populate(assertionConsumerServices);
        if (ExpressionManager.getInstance().isEvaluateExpressionsOn()) {
            this.isEditingHook = false;
            this.selectedHookType = null;
            this.selectedHookExpr = null;
            this.linkContextName = null;
            this.messageHooks.clear();
            MessageCustomizationCard.populateMsgHooks((ConnectionBase)sp, this.name2ContextMap, this.messageHooks);
            MessageCustomizationCard.updateAvailableHookTypes(this.hookTypes, this.name2ContextMap, this.messageHooks.values());
        }
    }

    private void populate(IndexedEndpoints assertionConsumerServices) {
        if (!this.isConnectionProtocol1x()) {
            super.setShowDefaultField(true);
            super.setShowIndexField(true);
        }
        if (assertionConsumerServices != null) {
            Map endpointMap = assertionConsumerServices.getEndpointsMap();
            Set indicies = endpointMap.keySet();
            this.setEndpoints(new ArrayList<ServiceEndpointItem>());
            for (Integer key : indicies) {
                Endpoint endpoint = (Endpoint)endpointMap.get(key);
                ServiceEndpointItem item = new ServiceEndpointItem(endpoint.getLocation(), this.bindingURIToDropdown(endpoint.getBinding()));
                item.setIndex(key.toString());
                if (assertionConsumerServices.hasDefault() && endpoint.equals(assertionConsumerServices.getDefault())) {
                    item.setDefaultService(true);
                }
                this.getEndpoints().add(item);
            }
        }
    }

    @Override
    public boolean save(Object dataToSave) {
        int indexOfDefault = -1;
        int baseIndex = 0;
        IndexedEndpoints assertionConsumerServices = new IndexedEndpoints();
        for (ServiceEndpointItem item : this.getEndpoints()) {
            Endpoint temp = new Endpoint(this.dropdownToBindingURI(item.getBinding()), item.getEndpointUrl());
            int endpointIndex = 0;
            endpointIndex = this.getShowIndexField() ? Integer.parseInt(item.getIndex()) : baseIndex++;
            assertionConsumerServices.setEndpoint(endpointIndex, temp);
            if (!item.getDefaultService()) continue;
            indexOfDefault = endpointIndex;
        }
        SpConnection sp = (SpConnection)dataToSave;
        sp.setAssertionConsumerServiceEndpoints(assertionConsumerServices);
        if (this.getShowDefaultField()) {
            if (indexOfDefault > -1) {
                assertionConsumerServices.setDefault(indexOfDefault);
            }
        } else {
            assertionConsumerServices.setDefault(0);
        }
        if (this.allowExpressionSave()) {
            MessageCustomizationCard.saveMsgHooks((ConnectionBase)sp, this.name2ContextMap, this.messageHooks);
        }
        return true;
    }

    @Override
    public void cancel(Object newData) {
        super.cancelEdit();
        super.cancel(newData);
    }

    @Override
    public void reset() {
        this.messageHooks.clear();
        super.cancelEdit();
        super.resetAll();
    }

    @Override
    public String getNoteKey() {
        return this.isConnectionProtocol1x() ? super.getNoteKey() + "_1x" : super.getNoteKey();
    }

    @Override
    public LinkedHashMap<String, MessageCustomizationCard.MessageHookEntry> getMessageHooks() {
        return this.messageHooks;
    }

    @Override
    public boolean getIsIdpConn() {
        return false;
    }

    @Override
    public boolean getIsWsFed() {
        return false;
    }

    @Override
    public String getAdvancedNote() {
        return this.getMessageWithFullKey("AssertionConsumerServiceState_advancedNote");
    }

    @Override
    public Map<String, String> getName2ContextMap() {
        return this.name2ContextMap;
    }

    @Override
    public boolean getIsEditingHook() {
        return this.isEditingHook;
    }

    @Override
    public void setIsEditingHook(boolean editing) {
        this.isEditingHook = editing;
    }

    @Override
    public StringPairPropertySelectionModel getHookTypes() {
        return this.hookTypes;
    }

    @Override
    public String getSelectedHookType() {
        return this.selectedHookType;
    }

    @Override
    public void setSelectedHookType(String selectedHookType) {
        this.selectedHookType = selectedHookType;
    }

    @Override
    public String getSelectedHookExpression() {
        return this.selectedHookExpr;
    }

    @Override
    public void setSelectedHookExpression(String selectedHookExpr) {
        this.selectedHookExpr = selectedHookExpr;
    }

    @Override
    public String getLinkContextName() {
        return this.linkContextName;
    }

    @Override
    public void setLinkContextName(String linkName) {
        this.linkContextName = linkName;
    }
}

