/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.IdpAdapterMappingState;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.AssertionCreationTasklet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsFedSpSettings;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class AssertionCreationState
extends SingleTaskletState
implements AttributeNamesApi {
    private static final long serialVersionUID = 20050515L;
    private SpConnection spConnection;
    private Object populateAllStatesData;
    private boolean isWsFedJwt;

    public AssertionCreationState(Tasklet value) {
        super(value);
        this.updateKeyContext(false);
    }

    @Override
    public void onStateActivated() {
        this.populateTasklet();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.spConnection = (SpConnection)dataFromDisk;
        this.populateTasklet();
        WsFedSpSettings wsFedSettings = this.spConnection.getWsFedSettings();
        this.updateKeyContext(wsFedSettings != null && wsFedSettings.getTokenType() == WsTrustTokenType.JWT);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.populateAllStatesData = data;
        this.populateTasklet();
        return true;
    }

    private void populateTasklet() {
        AssertionCreationTasklet tasklet = this.getTaskletToEdit(AssertionCreationTasklet.class);
        if (tasklet == null) {
            tasklet = this.createTasklet(AssertionCreationTasklet.class);
            tasklet.configureTasklet();
            if (this.spConnection != null) {
                tasklet.setMode(Mode.edit);
                tasklet.populate(this.spConnection);
            }
            if (this.populateAllStatesData != null) {
                tasklet.populateAllStates(this.populateAllStatesData);
            }
            this.setTasklet(tasklet);
        } else {
            Tasklet parentTasklet = this.getParent();
            if (!parentTasklet.isDraft()) {
                tasklet.configureTasklet();
            }
        }
    }

    @Override
    public void reset() {
        AssertionCreationTasklet tasklet = this.getTaskletToEdit(AssertionCreationTasklet.class);
        if (tasklet != null) {
            tasklet.resetAllStates();
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet == null) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Not_configured"), ValidationConstraint.REQUIRED);
        } else {
            super.appendErrors(delegate, component, fastFail);
        }
    }

    @Override
    public Set<String> getAllAttributeNames() {
        AttributeNamesApi ana = this.getTaskletToEdit(AttributeNamesApi.class);
        return ana != null ? ana.getAllAttributeNames() : new HashSet<String>();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        AttributeNamesApi ana = this.getTaskletToEdit(AttributeNamesApi.class);
        return ana != null ? ana.getAllAttrNamesSorted() : new ArrayList<String>();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        AttributeNamesApi ana = this.getTaskletToEdit(AttributeNamesApi.class);
        return ana != null ? ana.getSortedImmutableAttributeNames() : new ArrayList<String>();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        AttributeNamesApi ana = this.getTaskletToEdit(AttributeNamesApi.class);
        return ana != null ? ana.getSortedMutableAttributeNames() : new ArrayList<String>();
    }

    public String getIdentityMapping() {
        return ((AssertionCreationTasklet)this.getTaskletToEdit()).getIdentityMapping();
    }

    public List<String> getAttributeContractItems() {
        return ((AssertionCreationTasklet)this.getTaskletToEdit()).getAttributeContractItems();
    }

    public int getAdapterCount() {
        AssertionCreationTasklet t = (AssertionCreationTasklet)this.getTaskletToEdit();
        IdpAdapterMappingState idpAdapterMappingState = (IdpAdapterMappingState)t.findState("idpAdapterMapping");
        return idpAdapterMappingState != null ? idpAdapterMappingState.getAdapterTasklets().size() : 0;
    }

    public int getC2cCount() {
        AssertionCreationTasklet t = (AssertionCreationTasklet)this.getTaskletToEdit();
        IdpAdapterMappingState idpAdapterMappingState = (IdpAdapterMappingState)t.findState("idpAdapterMapping");
        return idpAdapterMappingState != null ? idpAdapterMappingState.getC2cTasklets().size() : 0;
    }

    public void updateKeyContext(boolean isWsFedJwt) {
        this.isWsFedJwt = isWsFedJwt;
        if (isWsFedJwt) {
            this.setKeyContext("jwt");
        } else {
            this.setKeyContext("saml");
        }
        this.setMenuName(this.getMessage("menu_name"));
    }

    public boolean isWsFedJwt() {
        return this.isWsFedJwt;
    }

    public String getSubmitLabel() {
        return this.getMessage("submit_label");
    }
}

