/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.AtmAccessControlSetingsValidator;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.OAuthClientMappingItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.validator.ValidatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AtmAccessControlSettingsState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private boolean inheritAccessControlSettings = true;
    private boolean restrictAllowedClients = false;
    private List<OAuthClientMappingItem> allowedClientIds = new ArrayList<OAuthClientMappingItem>();
    private transient Object componentState;
    private transient ClientManager clientMgr = (ClientManager)GlobalRegistry.getService(ClientManager.class);
    private String selectedClientDisplayName;
    private String selectedClientTypeAndId;
    private static final Comparator<String> CLIENT_ID_STRING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null) {
                return -1;
            }
            if (s2 == null) {
                return 1;
            }
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    };

    public AtmAccessControlSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Access Control");
    }

    public boolean isInheritAccessControlSettings() {
        return this.inheritAccessControlSettings;
    }

    public void setInheritAccessControlSettings(boolean inherit) {
        this.inheritAccessControlSettings = inherit;
    }

    public boolean isOverrideAccessControlSettings() {
        return !this.isInheritAccessControlSettings();
    }

    public void setOverrideAccessControlSettings(boolean override) {
        this.setInheritAccessControlSettings(!override);
    }

    public boolean isRestrictAllowedClients() {
        return this.restrictAllowedClients;
    }

    public void setRestrictAllowedClients(boolean restrictAllowedClients) {
        this.restrictAllowedClients = restrictAllowedClients;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public String getSelectedClientDisplayName() {
        return this.selectedClientDisplayName;
    }

    public void setSelectedClientDisplayName(String selectedClientDisplayName) {
    }

    public String getSelectedClientTypeAndId() {
        return this.selectedClientTypeAndId;
    }

    public void setSelectedClientTypeAndId(String selectedClientTypeAndId) {
        SelectedOption option;
        Client client;
        this.selectedClientTypeAndId = selectedClientTypeAndId;
        this.selectedClientDisplayName = StringUtils.isEmpty((String)selectedClientTypeAndId) ? "" : ((client = this.clientMgr.getClient((option = SelectionFilterList.parseSelectedOptionString(selectedClientTypeAndId)).getId())) == null ? option.getId() : client.getName() + " - (" + option.getId() + ")");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.setComponentState(null);
        if (dataFromDisk != null) {
            BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataFromDisk;
            this.inheritAccessControlSettings = pluginInstance.isInheritAccessControlSettings();
            this.restrictAllowedClients = pluginInstance.findEffectiveRestrictClients();
            this.allowedClientIds.clear();
            List allowedClientsStringList = pluginInstance.findEffectiveAllowedClients();
            this.allowedClientIds.addAll(this.domainToUiClientList(allowedClientsStringList));
        }
    }

    private List<OAuthClientMappingItem> domainToUiClientList(List<String> clientList) {
        if (clientList != null) {
            return clientList.stream().map(clientId -> new OAuthClientMappingItem((String)clientId, false)).collect(Collectors.toList());
        }
        return null;
    }

    private List<String> uiToDomainClientList(List<OAuthClientMappingItem> clientList) {
        if (clientList != null) {
            return clientList.stream().map(OAuthClientMappingItem::getClientId).collect(Collectors.toCollection(ArrayList::new));
        }
        return null;
    }

    @Override
    public boolean save(Object dataToDisk) {
        BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataToDisk;
        pluginInstance.setInheritAccessControlSettings(this.inheritAccessControlSettings);
        if (this.inheritAccessControlSettings) {
            pluginInstance.setOwnRestrictClients(false);
            pluginInstance.setOwnAllowedClients(new ArrayList());
        } else {
            pluginInstance.setOwnRestrictClients(this.restrictAllowedClients);
            if (this.restrictAllowedClients) {
                this.allowedClientIds.removeIf(oAuthClientMappingItem -> oAuthClientMappingItem.getIsDeleted());
                List<String> allowedClientsStringList = this.uiToDomainClientList(this.allowedClientIds);
                allowedClientsStringList.sort(CLIENT_ID_STRING_COMPARATOR);
                pluginInstance.setOwnAllowedClients(allowedClientsStringList);
            } else {
                pluginInstance.setOwnAllowedClients(new ArrayList());
            }
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        if (!this.hasParentInstance()) {
            this.inheritAccessControlSettings = false;
        }
        if (this.inheritAccessControlSettings) {
            this.loadParentAccessControlSettings();
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.inheritAccessControlSettings) {
            this.componentState = null;
            this.loadParentAccessControlSettings();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Restrict Allowed Clients", Boolean.toString(this.restrictAllowedClients), this));
        if (this.restrictAllowedClients) {
            for (OAuthClientMappingItem item : this.getEffectiveAllowedClientsList()) {
                summaryList.add(new SummaryInfo("Allowed Client", item.getClientId(), this));
            }
        }
    }

    public boolean hasParentInstance() {
        return this.getParentInstanceId() != null;
    }

    public String getParentInstanceId() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
    }

    private void loadParentAccessControlSettings() {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        BearerAccessTokenMgmtPluginInstance parentInstance = (BearerAccessTokenMgmtPluginInstance)pluginMgr.getInstance(this.getParentInstanceId());
        this.restrictAllowedClients = parentInstance.isRestrictClients();
        this.allowedClientIds.clear();
        this.allowedClientIds.addAll(this.domainToUiClientList(parentInstance.getAllowedClients()));
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return Collections.singletonList(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_CLIENT);
    }

    public List<OAuthClientMappingItem> getOauthClientsList() {
        List<OAuthClientMappingItem> copyOfAllowedClientIds = this.allowedClientIds.stream().collect(Collectors.toList());
        return copyOfAllowedClientIds;
    }

    public void deleteClientFromList(int index) {
        this.allowedClientIds.get(index).setIsDeleted(true);
    }

    public void undoDeleteClientFromList(int index) {
        this.allowedClientIds.get(index).setIsDeleted(false);
    }

    public String getDisabledClass() {
        return "disabled";
    }

    public void addClientToList() {
        SelectedOption option = SelectionFilterList.parseSelectedOptionString(this.selectedClientTypeAndId);
        OAuthClientMappingItem clientMappingItemToAdd = new OAuthClientMappingItem(option.getId(), false);
        if (FilterableSelectionFieldDescriptor.SearchableType.OAUTH_CLIENT.equals(option.getType())) {
            int index = this.allowedClientIds.indexOf(clientMappingItemToAdd);
            if (index == -1) {
                this.allowedClientIds.add(clientMappingItemToAdd);
            } else {
                OAuthClientMappingItem clientFromAllowedList = this.allowedClientIds.get(index);
                if (clientFromAllowedList.getIsDeleted()) {
                    AtmAccessControlSettingsState.recordErrorMsg("The OAuth client you are trying to add is already marked for deletion.", (IValidationDelegate)this.getDelegate());
                }
            }
        } else {
            AtmAccessControlSettingsState.recordErrorMsg("Please select an OAuth client before adding.", (IValidationDelegate)this.getDelegate());
        }
        this.selectedClientTypeAndId = null;
        this.selectedClientDisplayName = null;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        List<String> allowedClientsStringList = this.uiToDomainClientList(this.getEffectiveAllowedClientsList());
        AtmAccessControlSetingsValidator validator = new AtmAccessControlSetingsValidator(this.inheritAccessControlSettings, this.restrictAllowedClients, allowedClientsStringList, new ValidatorContext());
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    private List<OAuthClientMappingItem> getEffectiveAllowedClientsList() {
        return this.allowedClientIds.stream().filter(oAuthClientMappingItem -> !oAuthClientMappingItem.getIsDeleted()).collect(Collectors.toList());
    }
}

