/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.ResourceUriValidator;
import com.pingidentity.component.common.StringListEditor;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.pf.common.api.ApiMessageEnum;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AtmSelectionSettingsState
extends TaskletState
implements StringListEditor.ListItemValidator {
    private static final long serialVersionUID = 1L;
    private boolean inheritSelectionSettings = true;
    private List<String> resourceUris = new ArrayList<String>();
    private transient Object componentState;

    public AtmSelectionSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Resource URIs");
    }

    public boolean isInheritSelectionSettings() {
        return this.inheritSelectionSettings;
    }

    public void setInheritSelectionSettings(boolean inherit) {
        this.inheritSelectionSettings = inherit;
    }

    public boolean isOverrideSelectionSettings() {
        return !this.isInheritSelectionSettings();
    }

    public void setOverrideSelectionSettings(boolean override) {
        this.setInheritSelectionSettings(!override);
    }

    public List<String> getResourceUris() {
        return this.resourceUris;
    }

    public void setResourceUris(List<String> resourceUris) {
        this.resourceUris = resourceUris;
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.setComponentState(null);
        if (dataFromDisk != null) {
            BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataFromDisk;
            this.inheritSelectionSettings = pluginInstance.isInheritSelectionSettings();
            PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            this.resourceUris.clear();
            this.resourceUris.addAll(pluginInstance.findEffectiveResourceUris(pluginMgr));
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        BearerAccessTokenMgmtPluginInstance pluginInstance = (BearerAccessTokenMgmtPluginInstance)dataToDisk;
        pluginInstance.setInheritSelectionSettings(this.inheritSelectionSettings);
        if (this.inheritSelectionSettings) {
            pluginInstance.setOwnResourceUris(new ArrayList());
        } else {
            pluginInstance.setOwnResourceUris(new ArrayList<String>(this.resourceUris));
        }
        return true;
    }

    @Override
    public void onStateActivated() {
        if (!this.hasParentInstance()) {
            this.inheritSelectionSettings = false;
        }
        if (this.inheritSelectionSettings) {
            this.loadParentResourceUris();
        }
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.inheritSelectionSettings) {
            this.componentState = null;
            this.loadParentResourceUris();
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (String item : this.resourceUris) {
            summaryList.add(new SummaryInfo("Resource URI", item, this));
        }
    }

    public boolean hasParentInstance() {
        return this.getParentInstanceId() != null;
    }

    public String getParentInstanceId() {
        return this.getParent(PluginInstanceApi.class).getParentPluginInstanceId();
    }

    @Override
    public String validate(String resourceUri) {
        ResourceUriValidator validator = new ResourceUriValidator(resourceUri, (ApiMessageEnum)ApiMessageKey.oauth_access_token_management_invalid_resource_uri, null);
        validator.validate();
        if (!validator.validate()) {
            return ((ValidationError)validator.getErrors().get(0)).getMessage();
        }
        return null;
    }

    private void loadParentResourceUris() {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        BearerAccessTokenMgmtPluginInstance parentInstance = (BearerAccessTokenMgmtPluginInstance)pluginMgr.getInstance(this.getParentInstanceId());
        this.resourceUris.clear();
        this.resourceUris.addAll(parentInstance.findEffectiveResourceUris(pluginMgr));
    }
}

