/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.IdpConnection;

public class AttrAuthSecurityPolicyState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean signAttributeQuery;
    private boolean encryptNameId;
    private boolean requireSignedResponse;
    private boolean requireSignedAssertion;
    private boolean requireEncryptedAssertion;
    private boolean disableXmlEncryption;
    private boolean maskAttributeValues;

    public AttrAuthSecurityPolicyState(Tasklet value) {
        super(value);
        this.setMenuName("Security Policy");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeAuthority attributeAuthority = ((IdpConnection)dataFromDisk).getAttributeAuthority();
        this.signAttributeQuery = attributeAuthority.isSignAttributeQuery();
        this.encryptNameId = attributeAuthority.isEncryptNameId();
        this.requireSignedResponse = attributeAuthority.isRequireSignedResponse();
        this.requireSignedAssertion = attributeAuthority.isRequireSignedAssertion();
        this.requireEncryptedAssertion = attributeAuthority.isRequireEncryptedAssertion();
        this.maskAttributeValues = attributeAuthority.isMaskAttributeValues();
    }

    @Override
    public boolean populateAllStates(Object data) {
        AttributeAuthority attributeAuthority = ((IdpConnection)data).getAttributeAuthority();
        if (attributeAuthority != null) {
            this.populate(data);
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeAuthority tempAttributeAuthority = ((IdpConnection)dataToDisk).getAttributeAuthority();
        tempAttributeAuthority.setSignAttributeQuery(this.signAttributeQuery);
        tempAttributeAuthority.setEncryptNameId(this.encryptNameId);
        tempAttributeAuthority.setRequireSignedResponse(this.requireSignedResponse);
        tempAttributeAuthority.setRequireSignedAssertion(this.requireSignedAssertion);
        tempAttributeAuthority.setRequireEncryptedAssertion(this.requireEncryptedAssertion);
        tempAttributeAuthority.setMaskAttributeValues(this.maskAttributeValues);
        return true;
    }

    @Override
    public void reset() {
        this.signAttributeQuery = false;
        this.encryptNameId = false;
        this.requireSignedResponse = false;
        this.requireSignedAssertion = false;
        this.requireEncryptedAssertion = false;
        this.maskAttributeValues = false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Require_signed_response"), Boolean.toString(this.requireSignedResponse), this));
        summaryList.add(new SummaryInfo(this.getMessage("Require_signed_assertion"), Boolean.toString(this.requireSignedAssertion), this));
        summaryList.add(new SummaryInfo(this.getMessage("Require_encrypted_assertion"), Boolean.toString(this.requireEncryptedAssertion), this));
        summaryList.add(new SummaryInfo(this.getMessage("Sign_attribute_query"), Boolean.toString(this.signAttributeQuery), this));
        summaryList.add(new SummaryInfo(this.getMessage("Encrypt_name_id"), Boolean.toString(this.encryptNameId), this));
        summaryList.add(new SummaryInfo(this.getMessage("Mask_attribute_values"), Boolean.toString(this.maskAttributeValues), this));
    }

    public boolean isEncryptNameId() {
        return this.encryptNameId;
    }

    public void setEncryptNameId(boolean encryptNameId) {
        this.encryptNameId = encryptNameId;
    }

    public boolean isRequireEncryptedAssertion() {
        return this.requireEncryptedAssertion;
    }

    public void setRequireEncryptedAssertion(boolean requireEncryptedAssertion) {
        this.requireEncryptedAssertion = requireEncryptedAssertion;
    }

    public boolean isRequireSignedAssertion() {
        return this.requireSignedAssertion;
    }

    public void setRequireSignedAssertion(boolean requireSignedAssertion) {
        this.requireSignedAssertion = requireSignedAssertion;
    }

    public boolean isRequireSignedResponse() {
        return this.requireSignedResponse;
    }

    public void setRequireSignedResponse(boolean requireSignedResponse) {
        this.requireSignedResponse = requireSignedResponse;
    }

    public boolean isSignAttributeQuery() {
        return this.signAttributeQuery;
    }

    public void setSignAttributeQuery(boolean signAttributeQuery) {
        this.signAttributeQuery = signAttributeQuery;
    }

    public void setDisableXmlEncryption(boolean val) {
        this.disableXmlEncryption = val;
    }

    public boolean disableXmlEncryption() {
        return this.disableXmlEncryption;
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }
}

