/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.MappingNameItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.AttributeNameMapping;
import org.sourceid.saml20.domain.IdpConnection;

public class AttributeNameMappingState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private transient Object componentState;
    private List<MappingNameItem> list = new ArrayList<MappingNameItem>();

    public AttributeNameMappingState(Tasklet parent) {
        super(parent);
        this.setMenuName("Attribute Name Mapping");
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.componentState = null;
        this.list = new ArrayList<MappingNameItem>();
        AttributeAuthority attributeAuthority = ((IdpConnection)dataFromDisk).getAttributeAuthority();
        Collection mapping = attributeAuthority.getAttributeNameMapping().getNameMappings();
        for (AttributeNameMapping.NameMapping item : mapping) {
            MappingNameItem tempItem = new MappingNameItem(item.getLocalName(), item.getRemoteName());
            this.list.add(tempItem);
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConnection tempConnection = (IdpConnection)dataToDisk;
        AttributeAuthority tempAttributeAuthority = tempConnection.getAttributeAuthority();
        ArrayList<AttributeNameMapping.NameMapping> nameMappingList = new ArrayList<AttributeNameMapping.NameMapping>();
        for (MappingNameItem item : this.list) {
            AttributeNameMapping.NameMapping newItem = new AttributeNameMapping.NameMapping(item.getLocalName(), item.getRemoteName());
            nameMappingList.add(newItem);
        }
        tempAttributeAuthority.getAttributeNameMapping().setNameMappings(nameMappingList);
        return true;
    }

    @Override
    public void reset() {
        this.componentState = null;
        this.list = new ArrayList<MappingNameItem>();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (MappingNameItem item : this.list) {
            summaryList.add(new SummaryInfo(item.getLocalName(), item.getRemoteName(), this));
        }
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<MappingNameItem> getValues() {
        Collections.sort(this.list, MappingNameItem.ALPHABETICAL);
        return this.list;
    }

    public void setValues(List<MappingNameItem> newList) {
        this.list = newList;
    }
}

