/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.ValidationUtil;
import org.sourceid.saml20.domain.AttributeAuthority;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.IdpConnection;

public class AttributeRequestServiceUrlState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    String endpointLocation = "";

    public AttributeRequestServiceUrlState(Tasklet parent) {
        super(parent);
        this.setMenuName("Attribute Request Service URL");
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeAuthority attributeAuthority = ((IdpConnection)dataFromDisk).getAttributeAuthority();
        this.endpointLocation = attributeAuthority.getAttributeService().getLocation();
    }

    @Override
    public boolean populateAllStates(Object data) {
        if (((IdpConnection)data).getAttributeAuthority() != null) {
            this.populate(data);
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeAuthority tempAttributeAuthority = new AttributeAuthority();
        tempAttributeAuthority.setAttributeService(new Endpoint("urn:oasis:names:tc:SAML:2.0:bindings:SOAP", this.endpointLocation));
        ((IdpConnection)dataToDisk).setAttributeAuthority(tempAttributeAuthority);
        return true;
    }

    @Override
    public void reset() {
        this.endpointLocation = "";
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.endpointLocation)) {
            delegate.record(this.getMessage("Url_required"), ValidationConstraint.REQUIRED);
        }
        if (!delegate.getHasErrors() && !ValidationUtil.isValidHttpOrHttpsUrl((String)this.endpointLocation)) {
            if (this.findParent(ConnectionTasklet.class).isBaseUrlConfigured()) {
                if (!ValidationUtil.startsWithForwardSlash((String)this.endpointLocation)) {
                    delegate.record(this.getMessage("Endpoint_base_url_malformed"), ValidationConstraint.URL_FORMAT);
                }
            } else {
                delegate.record(this.getMessage("Malformed_url"), ValidationConstraint.URL_FORMAT);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Endpoint_url"), this.endpointLocation, this));
    }

    public void setEndpoint(String ep) {
        this.endpointLocation = StringUtils.stripToEmpty((String)ep);
    }

    public String getEndpoint() {
        return this.endpointLocation;
    }

    public boolean isXaspEndpointHttps() {
        boolean isHttps = false;
        if (this.endpointLocation.toLowerCase().startsWith("http")) {
            if (this.endpointLocation.toLowerCase().startsWith("https")) {
                isHttps = true;
            }
        } else {
            String baseUrl;
            ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
            if (connectionTasklet.isBaseUrlConfigured() && (baseUrl = connectionTasklet.getBaseUrlString()).toLowerCase().startsWith("https")) {
                isHttps = true;
            }
        }
        return isHttps;
    }
}

