/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SpXaspTasklet;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeRequester;
import org.sourceid.saml20.domain.SpConnection;

public class AttributeRequesterState
extends SingleTaskletState
implements NeededCredentialsApi {
    private static final long serialVersionUID = 20050515L;

    public AttributeRequesterState(Tasklet value) {
        super(value);
        this.setMenuName("Attribute Query");
    }

    @Override
    public void onStateActivated() {
        this.populate(null);
    }

    @Override
    public void populate(Object dataFromDisk) {
        SpXaspTasklet spXaspTasklet = this.getTaskletToEdit(SpXaspTasklet.class);
        if (spXaspTasklet == null) {
            spXaspTasklet = this.createTasklet(SpXaspTasklet.class);
            this.setTasklet(spXaspTasklet);
        }
        if (dataFromDisk != null) {
            AttributeRequester attributeRequester = ((SpConnection)dataFromDisk).getAttributeRequester();
            spXaspTasklet.setMode(Mode.edit);
            spXaspTasklet.populate(attributeRequester);
        }
    }

    @Override
    public boolean populateAllStates(Object data) {
        AttributeRequester attributeRequester;
        SpXaspTasklet spXaspTasklet = this.getTaskletToEdit(SpXaspTasklet.class);
        if (spXaspTasklet == null) {
            spXaspTasklet = this.createTasklet(SpXaspTasklet.class);
            this.setTasklet(spXaspTasklet);
        }
        if (data != null && (attributeRequester = ((SpConnection)data).getAttributeRequester()) != null) {
            spXaspTasklet.setMode(Mode.create);
            spXaspTasklet.populateAllStates(attributeRequester);
        }
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.getTaskletToEdit() != null) {
            SpConnection spConnection = (SpConnection)dataToDisk;
            AttributeRequester attributeRequester = spConnection.getAttributeRequester();
            if (attributeRequester == null) {
                attributeRequester = new AttributeRequester();
                attributeRequester.setAttributeMapping(new AttributeMapping());
                spConnection.setAttributeRequester(attributeRequester);
            }
            this.getTaskletToEdit().save(attributeRequester);
        }
        return true;
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.findParent(SamlProfilesApi.class).isAttributeQuerySelected();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureVerificationNeeded() : false;
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDigitalSignatureNeeded() : false;
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isEncryptionCertificateNeeded() : false;
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        NeededCredentialsApi nca = this.getTaskletToEdit(NeededCredentialsApi.class);
        return nca != null ? nca.isDecryptionKeyNeeded() : false;
    }
}

