/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.OpenIdConnectPolicyScopeAttributeValidator;
import com.pingidentity.component.common.NameValuePair;
import com.pingidentity.component.common.StringPairListEditor;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.CheckboxItem;
import com.pingidentity.fsm.tasklet.data.CheckboxModel;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.oauth20.domain.ScopeManager;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AttributeScopesState
extends TaskletState
implements StringPairListEditor.StringPairListEditorListener {
    private ScopeManager scopeManager = MgmtFactory.getScopeManager();
    private List<NameValuePair> scopeAndGroupDescriptions = new ArrayList<NameValuePair>();
    private List<NameValuePair> scopeAttributeDescriptions = new ArrayList<NameValuePair>();
    private List<String> attributeList = new ArrayList<String>();
    private Map<String, CheckboxModel> scopeAttributeModel = new HashMap<String, CheckboxModel>();
    private Object scopeGroupComponentState;

    public AttributeScopesState(IWizard owner) {
        super(owner);
        this.setMenuName("Attribute Scopes");
    }

    @Override
    public boolean save(Object dataToDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataToDisk;
        this.saveScopeAttributeMappings(policyGroup);
        return true;
    }

    private void saveScopeAttributeMappings(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        LinkedHashMap<String, String> scopeGroups = new LinkedHashMap<String, String>();
        for (NameValuePair entry : this.scopeAttributeDescriptions) {
            if (entry.isMarkedForDelete()) continue;
            scopeGroups.put(entry.getName().trim(), entry.getName().trim());
        }
        HashMap<String, ArrayList<String>> mappings = new HashMap<String, ArrayList<String>>();
        for (Map.Entry<String, CheckboxModel> entry : this.scopeAttributeModel.entrySet()) {
            if (!scopeGroups.containsKey(entry.getKey())) continue;
            mappings.put(entry.getKey(), new ArrayList<String>(entry.getValue().getSelectedNames()));
        }
        policyGroup.setScopeAttributeMappings(mappings);
    }

    @Override
    public void populate(Object dataFromDisk) {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = (OpenIdConnectProviderPolicy.PolicyGroup)dataFromDisk;
        this.populateScopes(policyGroup);
    }

    private void populateScopes(OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        TreeMap savedScopeDescriptions = new TreeMap(Collator.getInstance());
        savedScopeDescriptions.putAll(policyGroup.getScopeAttributeMappings());
        this.scopeAttributeDescriptions = new ArrayList<NameValuePair>();
        this.scopeAttributeModel = new TreeMap<Object, CheckboxModel>(Collator.getInstance());
        for (Map.Entry entry : savedScopeDescriptions.entrySet()) {
            String scopeName = (String)entry.getKey();
            NameValuePair nvpair = new NameValuePair(scopeName, scopeName);
            this.scopeAttributeDescriptions.add(nvpair);
            this.attributeList.clear();
            this.attributeList = this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
            this.attributeList.remove("sub");
            CheckboxModel cbm = new CheckboxModel();
            for (String attribute : this.attributeList) {
                cbm.add(attribute, false, policyGroup.getScopeAttributeMappings().containsKey(scopeName) && ((List)policyGroup.getScopeAttributeMappings().get(scopeName)).contains(attribute), AttributeScopesState.isDisabled(scopeName, attribute));
            }
            this.scopeAttributeModel.put(scopeName, cbm);
        }
    }

    @Override
    public void onStateActivated() {
        this.attributeList.clear();
        this.attributeList = this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
        this.attributeList.remove("sub");
        HashMap<String, String> allScopes = new HashMap<String, String>();
        allScopes.putAll(this.retrieveScopeDescriptions());
        allScopes.putAll(this.retrieveExclusiveScopeDescriptions());
        this.scopeAndGroupDescriptions = new ArrayList<NameValuePair>();
        for (Map.Entry entry : allScopes.entrySet()) {
            NameValuePair nvpair = new NameValuePair((String)entry.getKey(), (String)entry.getValue());
            this.scopeAndGroupDescriptions.add(nvpair);
        }
        this.updateAttributeLists();
    }

    public List<NameValuePair> getScopeAndGroupDescriptions() {
        return this.scopeAndGroupDescriptions;
    }

    public void setScopeAndGroupDescriptions(List<NameValuePair> scopeAndGroupDescriptions) {
        this.scopeAndGroupDescriptions = scopeAndGroupDescriptions;
    }

    public List<NameValuePair> getScopeAttributeDescriptions() {
        return this.scopeAttributeDescriptions;
    }

    public void setScopeAttributeDescriptions(List<NameValuePair> scopeAttributeDescriptions) {
        this.scopeAttributeDescriptions = scopeAttributeDescriptions;
    }

    public List<String> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<String> attributeList) {
        this.attributeList = attributeList;
    }

    public Map<String, CheckboxModel> getScopeAttributeModel() {
        return this.scopeAttributeModel;
    }

    public void setScopeAttributeModel(Map<String, CheckboxModel> scopeAttributeModel) {
        this.scopeAttributeModel = scopeAttributeModel;
    }

    public CheckboxModel getNewCheckboxModel() {
        CheckboxModel cbm = new CheckboxModel();
        for (String attributeName : this.getAttributeList()) {
            cbm.add(attributeName);
        }
        return cbm;
    }

    public CheckboxModel getNewCheckboxModel(String scopeName) {
        CheckboxModel cbm = new CheckboxModel();
        for (String attributeName : this.getAttributeList()) {
            boolean isDisabled = AttributeScopesState.isDisabled(scopeName, attributeName);
            cbm.add(attributeName, false, isDisabled, isDisabled);
        }
        return cbm;
    }

    public static boolean isDisabled(String scope, String attribute) {
        List attributeList = (List)OpenIdConnectPolicyScopeAttributeValidator.scopesEnabledMap.get(scope);
        return attributeList != null && attributeList.contains(attribute);
    }

    public List<String> getSelectedAttributes(String scope) {
        this.updateAttributeLists();
        if (this.scopeAttributeModel != null && this.scopeAttributeModel.get(scope) != null) {
            return this.scopeAttributeModel.get(scope).getSelectedNames();
        }
        return new ArrayList<String>();
    }

    private void updateAttributeLists() {
        this.attributeList = this.findParent(AttributeNamesApi.class).getAllAttrNamesSorted();
        this.attributeList.remove("sub");
        for (Map.Entry<String, CheckboxModel> entry : this.scopeAttributeModel.entrySet()) {
            if (entry.getValue() == null) continue;
            Iterator<CheckboxItem> iterator = entry.getValue().getCheckboxItems().iterator();
            while (iterator.hasNext()) {
                CheckboxItem cbi = iterator.next();
                if (this.attributeList.contains(cbi.getName())) continue;
                iterator.remove();
            }
            CheckboxModel cbm = entry.getValue();
            for (String attr : this.attributeList) {
                boolean foundAttr = cbm.getCheckboxItems().stream().filter(item -> item.getName().equals(attr)).findFirst().isPresent();
                if (foundAttr) continue;
                boolean isDisabled = AttributeScopesState.isDisabled(entry.getKey(), attr);
                cbm.add(attr, false, isDisabled, isDisabled);
            }
        }
    }

    public CheckboxModel getSubScopesModel(String scopeGroup) {
        CheckboxModel subScopesModel;
        if (StringUtils.isEmpty((String)scopeGroup)) {
            subScopesModel = this.getNewCheckboxModel();
        } else if (!this.scopeAttributeModel.containsKey(scopeGroup)) {
            subScopesModel = this.getNewCheckboxModel(scopeGroup);
            this.scopeAttributeModel.put(scopeGroup, this.getNewCheckboxModel(scopeGroup));
        } else {
            subScopesModel = this.scopeAttributeModel.get(scopeGroup);
        }
        subScopesModel.sortAlphabetically();
        return subScopesModel;
    }

    public Object getScopeGroupComponentState() {
        return this.scopeGroupComponentState;
    }

    public void setScopeGroupComponentState(Object scopeGroupComponentState) {
        this.scopeGroupComponentState = scopeGroupComponentState;
    }

    @Override
    public String validate(String name, String value, String originalName, String originalValue, List<NameValuePair> list, StringPairListEditor owner) {
        return null;
    }

    @Override
    public void onAddListItem(StringPairListEditor owner, String newItemName) {
        this.scopeAttributeDescriptions.sort(Comparator.comparing(NameValuePair::getName));
    }

    @Override
    public void onUpdateListItem(StringPairListEditor owner, String originalItemName, String newItemName) {
        this.scopeAttributeDescriptions.sort(Comparator.comparing(NameValuePair::getName));
    }

    @Override
    public void onDeleteListItem(StringPairListEditor owner, String itemToDeleteName) {
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        for (Map.Entry<String, CheckboxModel> entry : this.scopeAttributeModel.entrySet()) {
            Optional<NameValuePair> listItem = this.scopeAttributeDescriptions.stream().filter(item -> item.getName().equals(entry.getKey())).findFirst();
            if (!listItem.isPresent() || listItem.get().isMarkedForDelete()) continue;
            if (entry.getValue().getCheckboxItems() == null || entry.getValue().getSelectedNames().size() == 0) {
                delegate.record("Please select at least one attribute for scope '" + entry.getKey() + "'.", ValidationConstraint.REQUIRED);
                continue;
            }
            long count = entry.getValue().getCheckboxItems().stream().filter(item -> this.attributeList.contains(item.getName())).count();
            if (count != 0L) continue;
            delegate.record("Please select a valid attribute name", ValidationConstraint.REQUIRED);
        }
    }

    private Map<String, String> retrieveScopeDescriptions() {
        return this.scopeManager.getScopeDescriptions();
    }

    private Map<String, String> retrieveExclusiveScopeDescriptions() {
        return this.scopeManager.getExclusiveScopeDescriptions();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.scopeAttributeModel.size() > 0) {
            for (Map.Entry<String, CheckboxModel> entry : this.scopeAttributeModel.entrySet()) {
                summaryList.add(new SummaryInfo(entry.getKey(), String.join((CharSequence)", ", entry.getValue().getSelectedNames()), this));
            }
        }
    }
}

