/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.ConfigurationUtil;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.data.AdapterItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.IdpConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class AttributeValueMaskState
extends TaskletState {
    private static final long serialVersionUID = 20050111L;
    private Set<String> maskedFields = new HashSet<String>();
    protected LinkedHashMap<String, AdapterItem> adapterValues = new LinkedHashMap();
    private boolean maskOgnlValues;
    private boolean parentMaskOgnlValues;
    private boolean isInheritingAttributeSettings;
    private boolean oldIsInheritingAttributeSettings;
    private String oldParentId = null;
    private boolean isDisplayingForFirstTime = true;

    public AttributeValueMaskState(Tasklet value) {
        super(value);
        this.setMenuName("Token Attributes");
    }

    @Override
    public void onStateActivated() {
        boolean addingParent;
        List<String> attributes = this.getSortedAttributes();
        this.populateList(attributes);
        String parentId = this.getParentInstanceId();
        boolean hasParent = parentId != null;
        boolean removingParent = !hasParent && this.oldParentId != null;
        boolean bl = addingParent = hasParent && this.oldParentId == null;
        if (removingParent || hasParent) {
            if (removingParent) {
                this.removeParent();
            } else if (addingParent) {
                this.addParent(parentId, attributes);
            } else if (this.isInheritingAttributeSettings) {
                this.revert(parentId, attributes);
            }
        }
        this.oldParentId = parentId;
    }

    public List<String> getAttributes() {
        LinkedList<String> attributes = new LinkedList<String>();
        PluginInstanceTasklet parentTasklet = this.findParent(PluginInstanceTasklet.class);
        PluginDescriptor descriptor = parentTasklet.getSelectedDescriptor();
        if (descriptor != null) {
            attributes.addAll(descriptor.getAttributeContractSet());
        }
        attributes.addAll(parentTasklet.getAdapterAttributeList());
        return attributes;
    }

    public List<String> getSortedAttributes() {
        List<String> attributes = this.getAttributes();
        Collections.sort(attributes, String.CASE_INSENSITIVE_ORDER);
        return attributes;
    }

    private void removeParent() {
        this.isInheritingAttributeSettings = false;
        this.oldIsInheritingAttributeSettings = false;
    }

    private void addParent(String parentId, List<String> attributes) {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        if (parentTasklet.isNewTasklet() && this.isDisplayingForFirstTime) {
            this.isInheritingAttributeSettings = true;
            this.oldIsInheritingAttributeSettings = true;
            this.isDisplayingForFirstTime = false;
            this.revert(parentId, attributes);
        } else {
            this.isInheritingAttributeSettings = false;
        }
    }

    private void revert() {
        String parentId = this.getParentInstanceId();
        List<String> attrs = this.getSortedAttributes();
        this.revert(parentId, attrs);
    }

    protected void revert(String parentId, List<String> attributes) {
        PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
        PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
        IdpConfigurablePluginInstance parentInstance = (IdpConfigurablePluginInstance)pluginMgr.getInstance(parentId);
        Set maskedFields = ConfigurationUtil.findEffectiveMaskedFields((IdpConfigurablePluginInstance)parentInstance, pluginMgr);
        this.parentMaskOgnlValues = ConfigurationUtil.findEffectiveMaskedOgnlValue((IdpConfigurablePluginInstance)parentInstance, pluginMgr);
        for (String attribute : attributes) {
            AdapterItem adapterItem = new AdapterItem(attribute);
            adapterItem.setMasked(maskedFields.contains(attribute));
            this.adapterValues.put(attribute, adapterItem);
        }
        this.maskOgnlValues = this.parentMaskOgnlValues;
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConfigurablePluginInstance adapterInstance = (IdpConfigurablePluginInstance)dataFromDisk;
        if (adapterInstance != null) {
            PluginInstanceApi parentTasklet = this.getParent(PluginInstanceApi.class);
            PluginManager<?, ?> pluginMgr = parentTasklet.getPluginManager();
            this.maskedFields = ConfigurationUtil.findEffectiveMaskedFields((IdpConfigurablePluginInstance)adapterInstance, pluginMgr);
            this.adapterValues = new LinkedHashMap();
            this.maskOgnlValues = ConfigurationUtil.findEffectiveMaskedOgnlValue((IdpConfigurablePluginInstance)adapterInstance, pluginMgr);
            this.oldParentId = adapterInstance.getParentId();
            this.oldIsInheritingAttributeSettings = this.isInheritingAttributeSettings = adapterInstance.isInheritingAttributeSettings();
        }
        this.populateList(this.getSortedAttributes());
    }

    @Override
    public boolean save(Object dataToDisk) {
        IdpConfigurablePluginInstance tempAdapterInstance = (IdpConfigurablePluginInstance)dataToDisk;
        HashSet<String> tempMaskedFields = new HashSet<String>();
        for (AdapterItem adapterItem : this.adapterValues.values()) {
            if (adapterItem.isMasked()) {
                tempMaskedFields.add(adapterItem.getItem());
            }
            tempAdapterInstance.setOwnMaskedFields(tempMaskedFields);
        }
        tempAdapterInstance.setOwnMaskOgnlValues(this.maskOgnlValues);
        tempAdapterInstance.setInheritingAttributeSettings(this.isInheritingAttributeSettings);
        return true;
    }

    @Override
    public void reset() {
        this.maskedFields = new HashSet<String>();
        this.adapterValues = new LinkedHashMap();
        this.maskOgnlValues = false;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        StringBuffer maskedValues = new StringBuffer();
        for (AdapterItem item : this.adapterValues.values()) {
            if (!item.isMasked()) continue;
            maskedValues.append(item.getItem()).append(", ");
        }
        if (maskedValues.length() > 0) {
            maskedValues.deleteCharAt(maskedValues.lastIndexOf(","));
        }
        if (maskedValues.length() > 0) {
            summaryList.add(new SummaryInfo("Masked Log Values", maskedValues.toString().trim(), this));
        }
        if (this.showOgnlBox()) {
            summaryList.add(new SummaryInfo("Mask all OGNL expression log values", Boolean.toString(this.maskOgnlValues), this));
        }
    }

    void populateList(List<String> attributes) {
        if (this.adapterValues.isEmpty()) {
            for (String contractItem : attributes) {
                AdapterItem adapterItem = new AdapterItem(contractItem);
                if (this.maskedFields.contains(adapterItem.getItem())) {
                    adapterItem.setMasked(true);
                }
                this.adapterValues.put(contractItem, adapterItem);
            }
        } else {
            HashSet<String> tempMaskedFields = new HashSet<String>();
            LinkedHashMap<String, AdapterItem> tempAdapterValues = new LinkedHashMap<String, AdapterItem>();
            for (String contractItem : attributes) {
                AdapterItem adapterItem = this.adapterValues.get(contractItem);
                if (adapterItem == null) {
                    adapterItem = new AdapterItem(contractItem);
                    if (this.maskedFields.contains(adapterItem.getItem())) {
                        adapterItem.setMasked(true);
                    }
                } else if (adapterItem.isMasked()) {
                    tempMaskedFields.add(contractItem);
                }
                tempAdapterValues.put(contractItem, adapterItem);
            }
            this.maskedFields = tempMaskedFields;
            this.adapterValues = tempAdapterValues;
        }
    }

    public LinkedHashMap getAdapterValues() {
        return this.adapterValues;
    }

    public void setAdapterValues(LinkedHashMap adapterValues) {
        this.adapterValues = adapterValues;
    }

    public boolean getMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    public void setMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }

    public boolean showOgnlBox() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        return expressionManager.isEvaluateExpressionsOn();
    }

    public boolean isOverridingAttributeMasks() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        PluginDescriptor descriptor = parentTasklet.getSelectedDescriptor();
        if (descriptor != null && descriptor.isSupportsExtendedContract()) {
            this.oldIsInheritingAttributeSettings = this.isInheritingAttributeSettings = parentTasklet.isInheritingContract();
        }
        return !this.isInheritingAttributeSettings;
    }

    public void setOverridingAttributeMasks(boolean isOverridingAttributeMasks) {
        this.isInheritingAttributeSettings = !isOverridingAttributeMasks;
    }

    public boolean isOverridingAttributeMasksDisabled() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        PluginDescriptor descriptor = parentTasklet.getSelectedDescriptor();
        return descriptor != null && descriptor.isSupportsExtendedContract();
    }

    public boolean getHasParentInstance() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        return parentTasklet.getParentPluginInstanceId() != null;
    }

    public String getParentInstanceId() {
        PluginInstanceTasklet parentTasklet = this.getParent(PluginInstanceTasklet.class);
        return parentTasklet.getParentPluginInstanceId();
    }

    public boolean isDisabled() {
        if (this.oldIsInheritingAttributeSettings != this.isInheritingAttributeSettings) {
            return true;
        }
        return this.isInheritingAttributeSettings;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (this.isInheritingAttributeSettings && !this.oldIsInheritingAttributeSettings) {
            this.revert();
        }
        this.oldIsInheritingAttributeSettings = this.isInheritingAttributeSettings;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isInheritingAttributeSettings) {
            this.revert();
        } else if (this.getHasParentInstance()) {
            this.populateList(this.getSortedAttributes());
        }
    }
}

