/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.AuthenticationApiApplicationValidator;
import com.pingidentity.component.common.SelectedOption;
import com.pingidentity.component.common.SelectionFilterList;
import com.pingidentity.component.common.StringListEditor;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.state.impl.AuthenticationApplicationsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.pf.admin.rest.translator.AuthenticationApiApplicationTranslator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthenticationApplicationState
extends TaskletState
implements StringListEditor.ListItemValidator {
    private static final long serialVersionUID = 5L;
    private String id;
    private String name;
    private String description;
    private String appUrl;
    private String clientIdForRedirectlessMode;
    private String selectedClientDisplayName;
    private String selectedClientTypeAndId;
    private boolean allowRedirectlessMode;
    private transient Object redirectUrisComponentState;
    private List<String> allowedOrigins = new ArrayList<String>();

    public AuthenticationApplicationState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Authentication Application");
    }

    public AuthenticationApplicationState(IWizard owner, String cardName) {
        super(owner, cardName);
        this.setMenuName("Manage Authentication Application");
    }

    @Override
    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            this.redirectUrisComponentState = null;
            AuthnApiApplication apiApplication = (AuthnApiApplication)dataFromDisk;
            this.id = apiApplication.getId();
            this.appUrl = apiApplication.getUrl();
            this.name = apiApplication.getName();
            this.allowedOrigins = new ArrayList<String>(apiApplication.getCorsList());
            this.description = apiApplication.getDescription();
            this.clientIdForRedirectlessMode = apiApplication.getClientIdForRedirectlessMode();
            if (this.clientIdForRedirectlessMode != null) {
                Client client = MgmtFactory.getClientManager().getClient(this.clientIdForRedirectlessMode);
                if (client != null) {
                    this.allowRedirectlessMode = true;
                    this.selectedClientDisplayName = client.getName();
                    this.selectedClientTypeAndId = new SelectedOption(FilterableSelectionFieldDescriptor.SearchableType.OAUTH_CLIENT, this.clientIdForRedirectlessMode).toString();
                } else {
                    this.clientIdForRedirectlessMode = null;
                }
            }
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        AuthnApiApplication application = (AuthnApiApplication)dataToDisk;
        this.fillDomain(application);
        this.redirectUrisComponentState = null;
        return true;
    }

    private void fillDomain(AuthnApiApplication application) {
        if (StringUtils.isBlank((String)this.id)) {
            this.id = application.getId();
        }
        application.setId(this.id);
        application.setName(this.name);
        application.setDescription(this.description);
        application.setCorsList(new ArrayList<String>(this.allowedOrigins));
        application.setUrl(this.appUrl);
        if (this.isRestrictAccessToRedirectlessMode() && this.allowRedirectlessMode) {
            application.setClientIdForRedirectlessMode(this.clientIdForRedirectlessMode);
        } else {
            application.setClientIdForRedirectlessMode(null);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        AuthnApiApplication application = MgmtFactory.getAuthnApiManager().newApiApplication();
        this.fillDomain(application);
        AuthenticationApiApplicationValidator validator = new AuthenticationApiApplicationValidator(new AuthenticationApiApplicationTranslator().domainToApi(application, true), false, this.isRestrictAccessToRedirectlessMode());
        validator.validate();
        this.recordErrors(validator.getErrors(), delegate);
        if (this.allowRedirectlessMode && this.clientIdForRedirectlessMode == null) {
            this.recordErrorMsg("You must select a client for redirectless mode.");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.trim();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAppUrl() {
        return this.appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public Object getRedirectUrisComponentState() {
        return this.redirectUrisComponentState;
    }

    public void setRedirectUrisComponentState(Object componentState) {
        this.redirectUrisComponentState = componentState;
    }

    public static long getSerialVersionUID() {
        return 5L;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(List<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public boolean isCreateMode() {
        Tasklet t = this.getParent();
        return t.getMode() == Mode.create;
    }

    @Override
    public String validate(String value) {
        AuthenticationApiApplicationValidator validator = new AuthenticationApiApplicationValidator(Arrays.asList(value));
        validator.validateCrossOriginResourceSettings();
        if (!validator.validate()) {
            return ((ValidationError)validator.getErrors().get(0)).getMessage();
        }
        return null;
    }

    public boolean isAllowRedirectlessMode() {
        return this.allowRedirectlessMode;
    }

    public void setAllowRedirectlessMode(boolean allowRedirectlessMode) {
        this.allowRedirectlessMode = allowRedirectlessMode;
    }

    public String getSelectedClientDisplayName() {
        return this.selectedClientDisplayName;
    }

    public void setSelectedClientDisplayName(String selectedClientDisplayName) {
        this.selectedClientDisplayName = selectedClientDisplayName;
    }

    public String getSelectedClientTypeAndId() {
        return this.selectedClientTypeAndId;
    }

    public void setSelectedClientTypeAndId(String selectedClientTypeAndId) {
        this.selectedClientTypeAndId = selectedClientTypeAndId;
        if (StringUtils.isNotEmpty((String)selectedClientTypeAndId)) {
            SelectedOption option = SelectionFilterList.parseSelectedOptionString(selectedClientTypeAndId);
            this.clientIdForRedirectlessMode = option.getId();
        }
    }

    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getOAuthClientSearchableTypes() {
        return Collections.singletonList(new FilterableSelectionFieldDescriptor.SearchableTypeConfig(FilterableSelectionFieldDescriptor.SearchableType.OAUTH_CLIENT, Collections.emptyList()));
    }

    public boolean isRestrictAccessToRedirectlessMode() {
        IWizardState parentState = this.getParent().getParentTasklet().getCurrentState();
        if (parentState instanceof AuthenticationApplicationsState) {
            AuthenticationApplicationsState authnApplicationsState = (AuthenticationApplicationsState)parentState;
            return authnApplicationsState.isRestrictAccessToRedirectlessMode();
        }
        return false;
    }
}

