/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.ui.AsUiAction;
import com.pingidentity.fsm.state.impl.AbstractPolicyState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;
import org.sourceid.saml20.domain.AuthnApiApplication;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class AuthnPolicyState
extends AbstractPolicyState {
    private static final long serialVersionUID = 1L;
    public static final String AUTHENTICATION_POLICIES = "Policies";
    private boolean disabled;
    private String selectedAuthnApiApplicationId;
    private StringPairPropertySelectionModel authnApiApplicationList;
    private boolean handleFailuresLocally;

    public AuthnPolicyState(Tasklet value) {
        super(value);
        this.setMenuName(AUTHENTICATION_POLICIES);
        this.setHelpId("AdapterSelectorInstanceTasklet_AdapterSelectorConfigurationState");
        this.createAuthnApiApplicationsList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        AuthnSelectionTree treeFromDisk = (AuthnSelectionTree)dataFromDisk;
        super.populate(treeFromDisk.getRootNode());
        this.id = treeFromDisk.getId();
        this.name = treeFromDisk.getName();
        this.description = treeFromDisk.getDescription();
        this.disabled = treeFromDisk.isDisabled();
        this.selectedAuthnApiApplicationId = treeFromDisk.getOverrideAuthnApiApplicationId();
        this.handleFailuresLocally = treeFromDisk.isHandleFailuresLocally();
    }

    @Override
    public AuthnSelectionTree buildDomainTrees() {
        AuthnSelectionTree tree = super.buildDomainTrees();
        tree.setDisabled(this.disabled);
        tree.setOverrideAuthnApiApplicationId(this.selectedAuthnApiApplicationId);
        tree.setHandleFailuresLocally(this.handleFailuresLocally);
        return tree;
    }

    @Override
    protected void addOtherInputSourceAttributes(Map<String, Set<String>> allAvailableAttributeContracts) {
    }

    @Override
    public boolean save(Object dataToDisk) {
        return true;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    private void createAuthnApiApplicationsList() {
        this.authnApiApplicationList = new StringPairPropertySelectionModel(true);
        Collection instances = MgmtFactory.getAuthnApiManager().getApiApplications();
        for (AuthnApiApplication instance : instances) {
            this.authnApiApplicationList.add(instance.getName(), instance.getId());
        }
    }

    public String getSelectedAuthnApiApplicationId() {
        return this.selectedAuthnApiApplicationId;
    }

    public void setSelectedAuthnApiApplicationId(String selectedAuthnApiApplicationId) {
        this.selectedAuthnApiApplicationId = selectedAuthnApiApplicationId;
    }

    public StringPairPropertySelectionModel getAuthnApiApplicationList() {
        return this.authnApiApplicationList;
    }

    public void setAuthnApiApplicationList(StringPairPropertySelectionModel authnApiApplicationList) {
        this.authnApiApplicationList = authnApiApplicationList;
    }

    public boolean isHandleFailuresLocally() {
        return this.handleFailuresLocally;
    }

    public void setHandleFailuresLocally(boolean handleFailuresLocally) {
        this.handleFailuresLocally = handleFailuresLocally;
    }

    public boolean isEnableAuthnApi() {
        return this.isEnableIdP() && MgmtFactory.getAuthnApiManager().getSettings().isApiEnabled();
    }

    @Override
    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes(AsUiAction asUiAction) {
        List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> searchableTypes = super.getSearchableTypes(asUiAction);
        if (asUiAction != null && this.isShowAuthnPolicyContracts(asUiAction)) {
            searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.AUTH_POLICY_CONTRACT);
        }
        if (this.isEnableIdP() && asUiAction != null && this.isShowLocalIdentityProfiles(asUiAction)) {
            searchableTypes.add(FilterableSelectionFieldDescriptor.SearchableTypeConfig.LOCAL_IDENTITY_PROFILE);
        }
        return searchableTypes;
    }

    @Override
    public String getTypeString() {
        return "policy";
    }
}

