/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.gui.event.ConfigurationListener;
import org.sourceid.saml20.adapter.gui.event.EventException;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class BaseSelectPluginTypeState
extends TaskletState {
    private StringPairPropertySelectionModel sourceList = new StringPairPropertySelectionModel(true);
    private static final long serialVersionUID = 20050515L;
    private ConfigurablePluginInstance pluginInstance;
    private String pluginName = "";
    private String pluginId = "";
    private PluginDescriptor descriptor;
    private boolean newPlugin = true;
    private boolean connectionBasedPlugin;
    private String origPluginName = "";

    public BaseSelectPluginTypeState(IWizard owner) {
        super(owner);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.pluginInstance = (ConfigurablePluginInstance)dataFromDisk;
        if (this.pluginInstance != null) {
            this.newPlugin = false;
            this.pluginName = this.pluginInstance.getName();
            this.origPluginName = this.pluginInstance.getName();
            this.pluginId = this.pluginInstance.getId();
            this.descriptor = this.pluginInstance.getDescriptor();
            this.connectionBasedPlugin = this.pluginInstance.isConnectionBasedPlugin();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConfigurablePluginInstance tempPluginInstance = (ConfigurablePluginInstance)dataToDisk;
        tempPluginInstance.setName(this.pluginName);
        tempPluginInstance.setId(this.pluginId);
        tempPluginInstance.setDescriptor(this.descriptor);
        super.save(tempPluginInstance);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        boolean oldNewPlugin = this.newPlugin;
        super.cancel(newData);
        this.newPlugin = oldNewPlugin;
    }

    public StringPairPropertySelectionModel getDescriptorTypeList() {
        return this.sourceList;
    }

    public void initDescriptorTypeList(Collection<? extends PluginDescriptor> descriptors) {
        this.sourceList = new StringPairPropertySelectionModel(true);
        for (PluginDescriptor pluginDescriptor : descriptors) {
            this.sourceList.add(pluginDescriptor.getType(), pluginDescriptor);
        }
        this.sourceList.sort();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId.trim();
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName.trim();
    }

    public PluginDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(PluginDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isNewPlugin() {
        return this.newPlugin;
    }

    public void setNewPlugin(boolean newPlugin) {
        this.newPlugin = newPlugin;
    }

    @Override
    public boolean onStateExit() {
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        List configurationListenerChain = this.getDescriptor().getGuiConfigDescriptor().getListenerChain();
        if (configurationListenerChain != null && configurationListenerChain.size() > 0) {
            for (ConfigurationListener configurationListener : configurationListenerChain) {
                try {
                    configurationListener.onLoad();
                }
                catch (EventException eventException) {
                    errorMessages.addAll(eventException.getErrorMessages());
                    break;
                }
                catch (Exception exception) {
                    String msg = "Unexpected exception thrown from " + configurationListener;
                    errorMessages.add((CallSite)((Object)msg));
                    this.log.error((Object)msg, (Throwable)exception);
                    break;
                }
            }
        }
        boolean success = true;
        for (String string : errorMessages) {
            success = false;
            this.delegate.setFormComponent(null);
            this.delegate.record(string, ValidationConstraint.REQUIRED);
        }
        return success;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.valideDescriptorRequired(delegate, component);
    }

    protected void valideDescriptorRequired(IValidationDelegate delegate, BaseComponent component) {
        if (this.getDescriptor() == null) {
            IFormComponent ic = (IFormComponent)component.getComponent("pluginList");
            delegate.setFormComponent(ic);
            delegate.record(this.getMessage("Type_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean isConnectionBasedPlugin() {
        return this.connectionBasedPlugin;
    }

    public void setOrigPluginName(String origPluginName) {
        this.origPluginName = origPluginName;
    }

    public String getOrigPluginName() {
        return this.origPluginName;
    }

    public boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }

    public String getFipsStatus() {
        if (this.descriptor != null) {
            return AdapterUtils.getPluginFipsStatus((String)this.descriptor.getPluginClassName(), (Map)this.descriptor.getMetadata()).getDisplayName();
        }
        return "";
    }
}

