/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.card.TaskletListCardUser;
import com.pingidentity.component.common.Pagination;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateReferenceType;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotification;
import com.pingidentity.crypto.expiry.notification.CertificateExpiryNotificationManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.MetadataUrlCertItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.BearerAccessTokenMgmtPluginTasklet;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.CertificateRevocationCheckingTasklet;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MetadataUrlCertTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.util.DisplayPaginationHelper;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.wstrust.mgmt.TokenGeneratorManager;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class CertificateExpiryWarningManagementState
extends TaskletState
implements TaskletListCardUser {
    public static final String CERTIFICATE_EXPIRY_WARNING_TASKLET_NAME = "Manage Certificate Expiry Warnings";
    private static final long serialVersionUID = 1L;
    private final transient CertificateExpiryNotificationManager certificateExpiryNotificationManager = MgmtFactory.getCertificateExpiryNotificationManager();
    private final List<Tasklet> warningTasklets = new LinkedList<Tasklet>();
    private transient Object paginationState;
    private boolean onStateActivated = true;

    public CertificateExpiryWarningManagementState(IWizard owner) {
        super(owner);
        this.setMenuName(CERTIFICATE_EXPIRY_WARNING_TASKLET_NAME);
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.warningTasklets.clear();
        this.loadNotifications();
    }

    private void addTasklate(Tasklet t) {
        if (this.warningTasklets.isEmpty()) {
            this.warningTasklets.add(t);
        } else {
            Tasklet currentTasklet;
            Date expDate;
            int index = 0;
            Iterator<Tasklet> iterator = this.warningTasklets.iterator();
            Date newEntryExpDate = this.getExpiryDate(t);
            while (iterator.hasNext() && ((expDate = this.getExpiryDate(currentTasklet = iterator.next())) == null || newEntryExpDate == null || !expDate.after(newEntryExpDate))) {
                ++index;
            }
            this.warningTasklets.add(index, t);
        }
    }

    private void loadNotifications() {
        block13: for (CertificateExpiryNotification expiryNotification : this.certificateExpiryNotificationManager.getCertificateExpiryEntries()) {
            switch (expiryNotification.getCertificateType()) {
                case TRUSTED_CA: {
                    Cert cert = MgmtFactory.getTrustedCAsManager().getCert(expiryNotification.getCertificateId());
                    this.createCertificateManagementTasklet(cert, expiryNotification.getCertificateType());
                    break;
                }
                case STS_CLIENT_AUTH: 
                case DIGITAL_SIGNATURE_DECRYPTION: {
                    PkCert pkCert = MgmtFactory.getDsigPkCertManager().getPkCert(expiryNotification.getCertificateId());
                    this.createCertificateManagementTasklet((Cert)pkCert, expiryNotification.getCertificateType());
                    break;
                }
                case SSL_CLIENT: {
                    PkCert clientAuthCert = MgmtFactory.getSslAuthPkCertManager().getPkCert(expiryNotification.getCertificateId());
                    this.createCertificateManagementTasklet((Cert)clientAuthCert, expiryNotification.getCertificateType());
                    break;
                }
                case SSL_SERVER: {
                    PkCert sslCert = MgmtFactory.getAdminSslServerPkCertManager().getPkCert(expiryNotification.getCertificateId());
                    this.createCertificateManagementTasklet((Cert)sslCert, expiryNotification.getCertificateType());
                    break;
                }
                case METADATA_VERIFICATION: {
                    this.createMetadataUrlStateManagementTasklet(expiryNotification.getReferenceItemId(), expiryNotification.getCertificateId(), expiryNotification.getCertificateType());
                    break;
                }
                case CONNECTION_VERIFICATION: {
                    this.populateConnectionCertTasklets(expiryNotification, false);
                    break;
                }
                case CONNECTION_ENCRYPTION: 
                case CONNECTION_VERIFICATION_ENCRYPTION: {
                    this.populateConnectionCertTasklets(expiryNotification, true);
                    break;
                }
                case TOKEN_GENERATOR_ENCRYPTION: {
                    TokenGeneratorManager tokenGeneratorManager = MgmtFactory.getTokenGeneratorManager();
                    this.createPluginManagementTasklet(expiryNotification, (PluginManager<?, ?>)tokenGeneratorManager, "TokenGeneratorInstanceTasklet", "Token Generators", PluginManagementSupport.PluginManagementType.TOKEN_GENERATOR, (Class<? extends PluginInstanceTasklet>)PluginInstanceTasklet.class);
                    break;
                }
                case TOKEN_PROCESSOR_ENCRYPTION: {
                    TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
                    this.createPluginManagementTasklet(expiryNotification, (PluginManager<?, ?>)tokenProcessorManager, "TokenProcessorInstanceTasklet", "Manage Token Processors", PluginManagementSupport.PluginManagementType.TOKEN_PROCESSOR, (Class<? extends PluginInstanceTasklet>)PluginInstanceTasklet.class);
                    break;
                }
                case ACCESS_TOKEN_MANAGER_ENCRYPTION: {
                    BearerAccessTokenMgmtPluginManager atmManager = MgmtFactory.getBearerAccessTokenMgmtPluginMgr();
                    this.createPluginManagementTasklet(expiryNotification, (PluginManager<?, ?>)atmManager, "BearerAccessTokenMgmtPluginTasklet", "Access Token Management", PluginManagementSupport.PluginManagementType.ACCESS_TOKEN_MANAGEMENT, (Class<? extends PluginInstanceTasklet>)BearerAccessTokenMgmtPluginTasklet.class);
                    break;
                }
                case OCSP_DSIG_VERIFICATION: {
                    Set ocspCerts = ((PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).getCertsForFeature("Revocation Settings OCSP Responder Certs");
                    for (Cert ocspCert : ocspCerts) {
                        if (!expiryNotification.getCertificateId().equals(ocspCert.getId())) continue;
                        CertificateRevocationCheckingTasklet tasklet = this.createTaskletToLoad(CertificateRevocationCheckingTasklet.class, "CertificateRevocationCheckingTasklet", "Certificate Revocation Checking");
                        tasklet.setFinishAvailable(this.getParent().isAuthorizedForAction());
                        tasklet.setFinishLabel("Save");
                        tasklet.setCancelAvailable(true);
                        tasklet.setMode(Mode.edit);
                        tasklet.populate(null);
                        tasklet.setCertTypeForExpiryNotification(expiryNotification.getCertificateType());
                        tasklet.setCertIdForExpiryNotification(expiryNotification.getCertificateId());
                        this.addTasklate(tasklet);
                    }
                    continue block13;
                }
            }
        }
    }

    private void populateConnectionCertTasklets(CertificateExpiryNotification expiryNotification, boolean useEncryption) {
        SpConnection spConnection;
        if (expiryNotification.getReferenceItemType() == CertificateReferenceType.IDP_CONNECTION) {
            IdpConnection idpConnection = MgmtFactory.getConnectionManager().getIdpConnectionBySystemId(expiryNotification.getReferenceItemId());
            if (idpConnection != null && this.hasCert((ConnectionBase)idpConnection, expiryNotification.getCertificateId(), useEncryption)) {
                IdpConnectionConfigTasklet tasklet = this.createTaskletToLoad(IdpConnectionConfigTasklet.class);
                tasklet.setIdpConnection(idpConnection);
                this.populateConnectionTasklet(expiryNotification, (ConnectionBase)idpConnection, tasklet);
            }
        } else if (expiryNotification.getReferenceItemType() == CertificateReferenceType.SP_CONNECTION && (spConnection = MgmtFactory.getConnectionManager().getSpConnectionBySystemId(expiryNotification.getReferenceItemId())) != null && this.hasCert((ConnectionBase)spConnection, expiryNotification.getCertificateId(), useEncryption)) {
            SpConnectionConfigTasklet tasklet = this.createTaskletToLoad(SpConnectionConfigTasklet.class);
            tasklet.setSpConnection(spConnection);
            this.populateConnectionTasklet(expiryNotification, (ConnectionBase)spConnection, tasklet);
        }
    }

    private void populateConnectionTasklet(CertificateExpiryNotification expiryNotification, ConnectionBase connection, ConnectionTasklet tasklet) {
        if (this.getCurrentUser().isAdmin() || this.getCurrentUser().isAuditor()) {
            tasklet.setExistingConnection(true);
            tasklet.setMode(Mode.edit);
            tasklet.setFinishAvailable(this.isAuthorizedForAction());
            tasklet.setFinishLabel("Save");
            tasklet.populate(connection);
            tasklet.setCertTypeForExpiryNotification(expiryNotification.getCertificateType());
            tasklet.setCertIdForExpiryNotification(expiryNotification.getCertificateId());
            this.addTasklate(tasklet);
        }
    }

    private boolean hasCert(ConnectionBase connection, String certID, boolean useEncryptionCert) {
        Set connectionVerificationCerts = null;
        if (useEncryptionCert) {
            if (connection.getEncryptionSettings() != null && connection.getEncryptionSettings().getEncryptionCert() != null) {
                return certID.equals(connection.getEncryptionSettings().getEncryptionCert().getId());
            }
        } else {
            connectionVerificationCerts = connection.getDsigVerificationCerts().getAllVerificationCerts();
        }
        if (connectionVerificationCerts != null) {
            for (Cert verificationCert : connectionVerificationCerts) {
                if (!verificationCert.getId().equals(certID)) continue;
                return true;
            }
        }
        return false;
    }

    private void createCertificateManagementTasklet(Cert currentCert, CertificateType certificateType) {
        if (currentCert == null) {
            return;
        }
        CertManagementTasklet tasklet = this.createTaskletToLoad(CertManagementTasklet.class);
        tasklet.setCertType(CertificateTypes.ValidTypes.getCertType(certificateType));
        tasklet.setSelectedCert(currentCert);
        tasklet.setMode(Mode.edit);
        tasklet.populate(null);
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        tasklet.setFinishAvailable(this.isAuthorizedForAction());
        tasklet.setMenuName(certificateType.getTypeName());
        tasklet.setCertTypeForExpiryNotification(certificateType);
        if (certificateType == CertificateType.DIGITAL_SIGNATURE_DECRYPTION) {
            tasklet.setActivatable(false);
        }
        this.addTasklate(tasklet);
    }

    private void createMetadataUrlStateManagementTasklet(String metadataId, String certId, CertificateType certType) {
        MetadataUrlCertPair metadataUrlCertPair = MgmtFactory.getMetadataUrlManager().getMetadataUrlPair(metadataId);
        if (metadataUrlCertPair == null || metadataUrlCertPair.getVerificationCert() == null || !certId.equals(metadataUrlCertPair.getVerificationCert().getId())) {
            return;
        }
        MetadataUrlCertTasklet urlCertTasklet = this.createTaskletToLoad(MetadataUrlCertTasklet.class);
        urlCertTasklet.setMode(Mode.edit);
        urlCertTasklet.populate(new MetadataUrlCertItem(metadataUrlCertPair));
        urlCertTasklet.setFinishAvailable(this.isAuthorizedForAction());
        urlCertTasklet.setCertTypeForExpiryNotification(certType);
        this.addTasklate(urlCertTasklet);
    }

    private void createPluginManagementTasklet(CertificateExpiryNotification expiryNotification, PluginManager<?, ?> pluginManager, String taskletName, String taskletMenuName, PluginManagementSupport.PluginManagementType pluginManagementType, Class<? extends PluginInstanceTasklet> taskletType) {
        ConfigurablePluginInstance pluginInstance = pluginManager.getInstance(expiryNotification.getReferenceItemId());
        if (pluginInstance == null && !this.getCurrentUser().isAdmin()) {
            return;
        }
        PluginInstanceTasklet tasklet = this.createTaskletToLoad(taskletType, taskletName, taskletMenuName);
        tasklet.setPluginType(pluginManagementType);
        tasklet.setPluginManager(pluginManager);
        if (pluginInstance instanceof TokenProcessorInstance) {
            tasklet.setTokenProcessorInstanceTasklet(true);
        }
        tasklet.setMode(Mode.edit);
        tasklet.populate(pluginInstance);
        tasklet.setFinishLabel("Save");
        if (this.getCurrentUser().isAuditor()) {
            tasklet.setDisabled(true);
        }
        tasklet.setCertTypeForExpiryNotification(expiryNotification.getCertificateType());
        tasklet.setCertIdForExpiryNotification(expiryNotification.getCertificateId());
        this.addTasklate(tasklet);
    }

    @Override
    public String getFirstColumnData(Tasklet t) {
        Cert currentCert = this.getCert(t);
        return currentCert.getSerialNumberForDisplay();
    }

    private Cert getCert(Tasklet t) {
        Cert currentCert = null;
        if (t instanceof CertManagementTasklet) {
            CertManagementTasklet certTasklet = (CertManagementTasklet)t;
            currentCert = certTasklet.getSelectedCert();
        } else if (t instanceof CertificateExpiryDisplay) {
            CertificateExpiryDisplay certTasklet = (CertificateExpiryDisplay)((Object)t);
            currentCert = certTasklet.getCertForExpiryNotification();
        }
        return currentCert;
    }

    @Override
    public String getSecondColumnData(Tasklet t) {
        Cert currentCert = this.getCert(t);
        return currentCert.getX509Certificate().getSubjectDN().toString();
    }

    @Override
    public String getThirdColumnData(Tasklet t) {
        Date expDate = this.getExpiryDate(t);
        if (expDate == null) {
            return "";
        }
        return expDate.toString();
    }

    private Date getExpiryDate(Tasklet t) {
        Cert currentCert = this.getCert(t);
        if (currentCert != null) {
            return currentCert.getX509Certificate().getNotAfter();
        }
        return null;
    }

    @Override
    public String getFourthColumnData(Tasklet t) {
        if (t instanceof CertificateExpiryDisplay) {
            CertificateExpiryDisplay certTasklet = (CertificateExpiryDisplay)((Object)t);
            return certTasklet.getCertTypeForExpiryNotification().getTypeName();
        }
        return null;
    }

    @Override
    public boolean enableActionColumn() {
        return false;
    }

    public List<Tasklet> getWarningTasklets() {
        return Collections.unmodifiableList(this.warningTasklets);
    }

    @Override
    public void refreshState() {
        this.populate(null);
    }

    public Object getPaginationState() {
        return this.paginationState;
    }

    public void setPaginationState(Object paginationState) {
        this.paginationState = paginationState;
    }

    public void resetPaginationState() {
        if (this.paginationState != null) {
            ((Pagination.State)this.paginationState).reset();
        }
    }

    public Integer getLookAheadAvailableIndex() {
        return DisplayPaginationHelper.getLookAheadAvailableIndex(this.paginationState, this.getWarningTasklets());
    }

    public List<Tasklet> getPageWarningTasklets() {
        return DisplayPaginationHelper.getPagedTasklets(this.paginationState, this.getWarningTasklets());
    }

    public boolean isOnStateActivated() {
        return this.onStateActivated;
    }

    public void setOnStateActivated(boolean onStateActivated) {
        this.onStateActivated = onStateActivated;
    }

    @Override
    public void onStateActivated() {
        this.onStateActivated = true;
    }
}

