/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.CertManagementTasklet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class CertificateState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private transient Cert selectedCert;
    private transient Cert secondarySelectedCert;
    private transient LinkedHashSet<Cert> activeCerts = new LinkedHashSet();
    private transient Set<Cert> inactiveCerts = new HashSet<Cert>();
    protected CertificateTypes.ValidTypes certType;

    public CertificateState(Tasklet value) {
        super(value);
    }

    public CertificateState(Tasklet value, String stateName) {
        super(value, stateName);
    }

    @Override
    public void loadTaskletToEdit() {
        CertManagementTasklet tasklet = this.createTasklet(CertManagementTasklet.class);
        tasklet.setCertType(this.certType);
        tasklet.setSelectedCert(this.getSelectedCert());
        tasklet.setSecondarySelectedCert(this.getSecondarySelectedCert());
        tasklet.setActiveCerts(this.getActiveCerts());
        tasklet.setInactiveCerts(this.getInactiveCerts());
        tasklet.setMode(Mode.edit);
        tasklet.setActivatable(this.isActivatable());
        tasklet.populate(this.getObjectForPopulate());
        tasklet.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
        this.loadTasklet(tasklet);
    }

    protected Object getObjectForPopulate() {
        return null;
    }

    @Override
    public void refreshState() {
        CertManagementTasklet tasklet = (CertManagementTasklet)this.getTaskletToEdit();
        this.setRawSelectedCert(tasklet.getSelectedCert());
        this.setRawSecondarySelectedCert(tasklet.getSecondarySelectedCert());
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
    }

    public boolean hasSelectedCert() {
        return this.getSelectedCert() != null;
    }

    public Cert getSelectedCert() {
        return this.selectedCert;
    }

    public void setSelectedCert(Cert selectedCert) {
        this.selectedCert = selectedCert;
    }

    protected void setRawSelectedCert(Cert selectedCert) {
        this.selectedCert = selectedCert;
    }

    public Cert getSecondarySelectedCert() {
        return this.secondarySelectedCert;
    }

    public void setSecondarySelectedCert(Cert secondarySelectedCert) {
        this.secondarySelectedCert = secondarySelectedCert;
    }

    public void setRawSecondarySelectedCert(Cert secondarySelectedCert) {
        this.secondarySelectedCert = secondarySelectedCert;
    }

    public LinkedHashSet<Cert> getActiveCerts() {
        return this.activeCerts;
    }

    public void setActiveCerts(LinkedHashSet<Cert> activeCerts) {
        this.activeCerts = activeCerts;
    }

    public Set<Cert> getInactiveCerts() {
        return this.inactiveCerts;
    }

    public void setInactiveCerts(Set<Cert> inactiveCerts) {
        this.inactiveCerts = inactiveCerts;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.getSecondarySelectedCert() != null) {
            summaryList.add(new SummaryInfo(this.getMessage("Common", "Primary_cert"), this.getSelectedCert() == null ? "None" : this.getSelectedCert().getDescriptionForDisplay(), this));
            summaryList.add(new SummaryInfo(this.getMessage("Common", "Secondary_cert"), this.getSecondarySelectedCert().getDescriptionForDisplay(), this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Common", "SelectedCert"), this.getSelectedCert() == null ? "None" : this.getSelectedCert().getDescriptionForDisplay(), this));
        }
    }

    @Override
    public void reset() {
        this.setRawSelectedCert(null);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject((Object)this.certType);
        this.serializeSelectedCert(out);
        this.serializeSecondarySelectedCert(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.certType = (CertificateTypes.ValidTypes)((Object)in.readObject());
        this.deserializeSelectedCert(in);
        this.deserializeSecondarySelectedCert(in);
    }

    protected void serializeSelectedCert(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getSelectedCert());
    }

    protected void serializeSecondarySelectedCert(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getSecondarySelectedCert());
    }

    protected void deserializeSelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setRawSelectedCert((Cert)in.readObject());
    }

    protected void deserializeSecondarySelectedCert(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.setSecondarySelectedCert((Cert)in.readObject());
    }

    protected boolean isActivatable() {
        return true;
    }
}

