/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;

@AutoSaveState
public class CibaPoliciesManagementState
extends TaskletListState
implements Serializable {
    private static final long serialVersionUID = 20130444L;
    private String defaultPolicyId;

    public CibaPoliciesManagementState(IWizard owner, String name) {
        super(owner, name);
        this.setMenuName("Manage Policies");
    }

    public CibaPoliciesManagementState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Policies");
    }

    @Override
    public void populate(Object dataFromDisk) {
        CibaServerPolicyManager cibaServerPolicyManager = (CibaServerPolicyManager)GlobalRegistry.getService(CibaServerPolicyManager.class);
        CibaServerPolicy cibaServerPolicy = cibaServerPolicyManager.getCibaServerPolicy();
        this.defaultPolicyId = cibaServerPolicy.getDefaultRequestHandlingPolicyId();
        this.deleteAllTasklets();
        for (CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy : cibaServerPolicy.getRequestHandlingPolicies().values()) {
            CibaPolicyManagementTasklet cibaPolicyManagementTasklet = this.createTasklet(CibaPolicyManagementTasklet.class);
            cibaPolicyManagementTasklet.setMode(Mode.edit);
            cibaPolicyManagementTasklet.populate(requestHandlingPolicy);
            cibaPolicyManagementTasklet.setFinishLabel("Save");
            this.addTasklet(cibaPolicyManagementTasklet);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        delegate.setFormComponent(null);
        if (!this.isDefaultDefined()) {
            delegate.record(this.getMessage("Default_required"), ValidationConstraint.REQUIRED);
        }
        for (Tasklet t : this.getTasklets()) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            CibaPolicyManagementTasklet tasklet = (CibaPolicyManagementTasklet)t;
            if (tasklet.isItDeleted()) continue;
            tasklet.appendErrors((IValidationDelegate)tempDelegate, null, fastFail);
            if (!tempDelegate.getHasErrors()) continue;
            delegate.record(tasklet.getPolicyId() + " has error(s), please review and fix", ValidationConstraint.REQUIRED);
        }
    }

    private boolean isDefaultDefined() {
        int size = 0;
        for (Tasklet t : this.getTasklets()) {
            CibaPolicyManagementTasklet policyManagementTasklet = (CibaPolicyManagementTasklet)t;
            if (policyManagementTasklet.isItDeleted()) continue;
            ++size;
            if (!StringUtils.equals((String)policyManagementTasklet.getPolicyId(), (String)this.defaultPolicyId)) continue;
            return true;
        }
        return size == 0;
    }

    public void delete(String policyToDelete) {
        boolean reloadList = false;
        for (Tasklet tasklet : this.getTasklets()) {
            CibaPolicyManagementTasklet t = (CibaPolicyManagementTasklet)tasklet;
            if (!StringUtils.equals((String)t.getPolicyId(), (String)policyToDelete)) continue;
            t.setItDeleted(true);
            CibaServerPolicyManager cibaServerPolicyManager = (CibaServerPolicyManager)GlobalRegistry.getService(CibaServerPolicyManager.class);
            CibaServerPolicy cibaServerPolicy = cibaServerPolicyManager.getCibaServerPolicy();
            CibaServerPolicy.RequestHandlingPolicy deletedPolicy = t.getCibaPolicy();
            cibaServerPolicy.removeRequestHandlingPolicy(deletedPolicy.getId());
            cibaServerPolicyManager.saveCibaServerPolicy(cibaServerPolicy);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl((Tasklet)this.getWizard());
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)DependencyType.AUTH_SERVER_SETTINGS, DependencyType.OOB_AUTH_PLUGIN);
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)DependencyType.OOB_AUTH_PLUGIN, DependencyType.OOB_AUTH_PLUGIN);
            if (cibaServerPolicy.getRequestHandlingPolicies() == null || cibaServerPolicy.getRequestHandlingPolicies().size() != 1) break;
            reloadList = true;
            break;
        }
        if (reloadList) {
            this.populate(null);
        }
    }

    public void setDefaultPolicy(String policyId) {
        this.defaultPolicyId = policyId;
        CibaServerPolicyManager cibaServerPolicyManager = (CibaServerPolicyManager)GlobalRegistry.getService(CibaServerPolicyManager.class);
        CibaServerPolicy cibaServerPolicy = cibaServerPolicyManager.getCibaServerPolicy();
        if (StringUtils.isEmpty((String)this.defaultPolicyId)) {
            this.defaultPolicyId = cibaServerPolicy.getDefaultRequestHandlingPolicyId();
        }
        cibaServerPolicy.setDefaultRequestHandlingPolicyId(this.defaultPolicyId);
        cibaServerPolicyManager.saveCibaServerPolicy(cibaServerPolicy);
    }

    public boolean isDefaultPolicy(String policyId) {
        return StringUtils.equals((String)this.defaultPolicyId, (String)policyId);
    }

    public boolean isDefaultPolicyAndMoreThanOnePolicy(String policyId) {
        boolean moreThanOnePolicy;
        long undeletedPolicyCount = this.getTasklets().stream().filter(tasklet -> !tasklet.isItDeleted()).count();
        boolean bl = moreThanOnePolicy = undeletedPolicyCount > 1L;
        return this.isDefaultPolicy(policyId) && moreThanOnePolicy;
    }

    public String getDefaultPolicyId() {
        return this.defaultPolicyId;
    }

    public Tasklet getTaskletFromList(String policyId) {
        for (Tasklet tasklet : this.getTasklets()) {
            CibaPolicyManagementTasklet t = (CibaPolicyManagementTasklet)tasklet;
            if (!StringUtils.equals((String)t.getPolicyId(), (String)policyId)) continue;
            return tasklet;
        }
        return null;
    }

    public List<Tasklet> getPolicyList() {
        return this.getTasklets();
    }

    public boolean policyNameExists(String policyName, String taskletId) {
        for (Tasklet tasklet : this.getTasklets()) {
            CibaPolicyManagementTasklet t = (CibaPolicyManagementTasklet)tasklet;
            if (!t.getDescription().equals(policyName) || t.getTaskletId().equals(taskletId)) continue;
            return true;
        }
        return false;
    }
}

