/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.state.impl.CibaPolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.util.SAML2MappingModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.saml20.domain.AttributeMapping;

public class CibaPolicyContractFulfillmentState
extends MappingState
implements Serializable {
    private static final long serialVersionUID = 1L;

    public CibaPolicyContractFulfillmentState(Tasklet value, String name) {
        super(value, name);
        this.model.setTargetName("Contract");
        this.setMenuName("Contract Fulfillment");
    }

    @Override
    public void populate(Object dataFromDisk) {
        CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)dataFromDisk;
        this.attributeMapping = policy.getHintContractToOOBAuthPluginMapping();
        this.model = new SAML2MappingModel("Contract", this.attributeMapping, this.getCurrentUser());
    }

    @Override
    public boolean save(Object dataToDisk) {
        CibaServerPolicy.RequestHandlingPolicy policy = (CibaServerPolicy.RequestHandlingPolicy)dataToDisk;
        AttributeMapping hintContractToOOBAuthPluginMapping = policy.getHintContractToOOBAuthPluginMapping();
        hintContractToOOBAuthPluginMapping.setAttributeMap2(this.model.getMapping().getAttributeMapping());
        return true;
    }

    public LinkedHashSet<String> getTarget() {
        CibaPolicyManagementTasklet tasklet = this.findParent(CibaPolicyManagementTasklet.class);
        return tasklet.getAllAttributeNames();
    }

    @Override
    public void onStateActivated() {
        super.onStateActivated();
        this.sources.addNoMappingSource("No Mapping");
        CibaPolicyManagementTasklet tasklet = this.findParent(CibaPolicyManagementTasklet.class);
        tasklet.addStandardSourcesToPropertySelectionSources(this.sources);
        tasklet.addRequestHintToSources(this.sources);
    }

    public List<String> getDataMapListOrder() {
        return new ArrayList<String>(this.getTarget());
    }
}

