/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.component.card.TaskletListCardUser;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigSessionMappingTasklet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;

public class ConfigAdapterMappingState
extends TaskletState
implements TaskletListCardUser {
    private static final long serialVersionUID = 20050515L;
    private static final String ADAPTER_TYPE = "adapter";
    private static final String C2C_CONTRACT_TYPE = "c2cContract";
    private List<TargetAttributeMapping> adapterMappings = new ArrayList<TargetAttributeMapping>();
    private List<C2cContractAttributeMapping> c2cMappings = new ArrayList<C2cContractAttributeMapping>();
    private final List<String> closedDataStoreConnections = new ArrayList<String>();
    private final List<IdpConfigAdapterMappingTasklet> adapterTasklets = new ArrayList<IdpConfigAdapterMappingTasklet>();
    private final List<IdpC2cContractMappingTasklet> c2cTasklets = new ArrayList<IdpC2cContractMappingTasklet>();

    public ConfigAdapterMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Target Session Mapping");
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.doesOneMappingExist()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_required"), ValidationConstraint.REQUIRED);
        } else {
            for (Tasklet tasklet : this.adapterTasklets) {
                if (tasklet.isItDeleted()) continue;
                tasklet.appendErrors(delegate, component, fastFail);
            }
            for (Tasklet tasklet : this.c2cTasklets) {
                if (tasklet.isItDeleted()) continue;
                tasklet.appendErrors(delegate, component, fastFail);
            }
        }
    }

    private boolean doesOneMappingExist() {
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            return true;
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            if (tasklet.isItDeleted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onResumeDraft() {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.onResumeDraft();
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.onResumeDraft();
        }
    }

    @Override
    public void updateVisit(Visit freshVisit) {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.updateVisit(freshVisit);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.updateVisit(freshVisit);
        }
    }

    @Override
    public boolean onStateExit() {
        this.removeDeletedTasklets(this.adapterTasklets);
        this.removeDeletedTasklets(this.c2cTasklets);
        return true;
    }

    private void removeDeletedTasklets(List<? extends Tasklet> tasklets) {
        Iterator<? extends Tasklet> taskletIterator = tasklets.iterator();
        while (taskletIterator.hasNext()) {
            Tasklet t = taskletIterator.next();
            if (!t.isItDeleted()) continue;
            taskletIterator.remove();
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        super.getSummary(summaryList);
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            tasklet.getSummary(summaryList);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            if (tasklet.isItDeleted()) continue;
            tasklet.getSummary(summaryList);
        }
    }

    @Override
    public void initialize() {
        for (Tasklet tasklet : this.adapterTasklets) {
            tasklet.initialize();
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            tasklet.initialize();
        }
    }

    @Override
    public void setQueue(Queue<String> returnPath) {
        LinkedBlockingQueue<String> temp;
        super.setQueue(returnPath);
        for (Tasklet tasklet : this.adapterTasklets) {
            temp = new LinkedBlockingQueue<String>(this.path);
            temp.add(ADAPTER_TYPE);
            temp.add(tasklet.getTaskletId());
            tasklet.setQueue(temp);
        }
        for (Tasklet tasklet : this.c2cTasklets) {
            temp = new LinkedBlockingQueue(this.path);
            temp.add(C2C_CONTRACT_TYPE);
            temp.add(tasklet.getTaskletId());
            tasklet.setQueue(temp);
        }
    }

    @Override
    public void jumpToState(IRequestCycle cycle, Queue<String> returnPath) {
        block3: {
            String taskletId;
            String taskletType;
            block2: {
                taskletType = returnPath.poll();
                taskletId = returnPath.poll();
                if (!ADAPTER_TYPE.equals(taskletType)) break block2;
                for (Tasklet tasklet : this.adapterTasklets) {
                    if (!taskletId.equals(tasklet.getTaskletId())) continue;
                    Tasklet currentTasklet = (Tasklet)this.getWizard();
                    currentTasklet.loadTasklet(tasklet);
                    tasklet.jumpToState(cycle, returnPath);
                    this.setTaskletToEdit(tasklet);
                }
                break block3;
            }
            if (!C2C_CONTRACT_TYPE.equals(taskletType)) break block3;
            for (Tasklet tasklet : this.c2cTasklets) {
                if (!taskletId.equals(tasklet.getTaskletId())) continue;
                Tasklet currentTasklet = (Tasklet)this.getWizard();
                currentTasklet.loadTasklet(tasklet);
                tasklet.jumpToState(cycle, returnPath);
                this.setTaskletToEdit(tasklet);
            }
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        IdpConfigSessionMappingTasklet tasklet;
        IdpConnection idp = (IdpConnection)dataFromDisk;
        this.adapterMappings = new ArrayList<TargetAttributeMapping>(idp.getTargetAttributeMappings());
        this.c2cMappings = new ArrayList<C2cContractAttributeMapping>(idp.getC2cContractMappings());
        this.adapterTasklets.clear();
        this.c2cTasklets.clear();
        this.closedDataStoreConnections.clear();
        for (TargetAttributeMapping targetAttributeMapping : this.adapterMappings) {
            tasklet = this.doCreateTasklet(IdpConfigAdapterMappingTasklet.class, (AttributeMapping)targetAttributeMapping);
            this.adapterTasklets.add((IdpConfigAdapterMappingTasklet)tasklet);
        }
        Collections.sort(this.adapterTasklets);
        if (this.getIsC2cEnabled()) {
            for (C2cContractAttributeMapping c2cContractAttributeMapping : this.c2cMappings) {
                tasklet = this.doCreateTasklet(IdpC2cContractMappingTasklet.class, (AttributeMapping)c2cContractAttributeMapping);
                this.c2cTasklets.add((IdpC2cContractMappingTasklet)tasklet);
            }
            Collections.sort(this.c2cTasklets);
        }
    }

    private <T extends Tasklet> T doCreateTasklet(Class<T> taskletClass, AttributeMapping mapping) {
        T tasklet = this.createTasklet(taskletClass);
        ((Tasklet)tasklet).setMode(Mode.edit);
        ((Tasklet)tasklet).populate(mapping);
        return tasklet;
    }

    @Override
    public boolean save(Object dataToDisk) {
        TargetAttributeMapping mapping;
        IdpConnection conn = (IdpConnection)dataToDisk;
        ArrayList<TargetAttributeMapping> adapterMappings = new ArrayList<TargetAttributeMapping>();
        ArrayList<TargetAttributeMapping> c2cMappings = new ArrayList<TargetAttributeMapping>();
        for (Tasklet tasklet : this.adapterTasklets) {
            if (tasklet.isItDeleted()) continue;
            mapping = new TargetAttributeMapping();
            tasklet.save(mapping);
            adapterMappings.add(mapping);
        }
        conn.setTargetAttributeMappings(adapterMappings);
        if (this.getIsC2cEnabled()) {
            for (Tasklet tasklet : this.c2cTasklets) {
                if (tasklet.isItDeleted()) continue;
                mapping = new C2cContractAttributeMapping();
                tasklet.save(mapping);
                c2cMappings.add(mapping);
            }
            conn.setC2cContractMappings(c2cMappings);
        }
        return true;
    }

    @Override
    public void reset() {
        this.adapterTasklets.clear();
        this.adapterMappings = new ArrayList<TargetAttributeMapping>();
        this.c2cTasklets.clear();
        this.c2cMappings = new ArrayList<C2cContractAttributeMapping>();
        this.closedDataStoreConnections.clear();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        ArrayList<SummaryInfo> sortedAdapterSummaryInfo = new ArrayList<SummaryInfo>();
        ArrayList<SummaryInfo> sortedC2cSummaryInfo = new ArrayList<SummaryInfo>();
        for (IdpConfigAdapterMappingTasklet idpConfigAdapterMappingTasklet : this.adapterTasklets) {
            sortedAdapterSummaryInfo.add(new SummaryInfo("Adapter instance name", idpConfigAdapterMappingTasklet.getSelectedPlugin().getName(), this));
        }
        for (IdpC2cContractMappingTasklet idpC2cContractMappingTasklet : this.c2cTasklets) {
            sortedC2cSummaryInfo.add(new SummaryInfo("Authentication policy contract name", idpC2cContractMappingTasklet.getContractName(), this));
        }
        Collections.sort(sortedAdapterSummaryInfo);
        Collections.sort(sortedC2cSummaryInfo);
        summaryList.addAll(sortedAdapterSummaryInfo);
        summaryList.addAll(sortedC2cSummaryInfo);
    }

    @Override
    public String getNoteKey() {
        if (this.getIsC2cEnabled()) {
            if (this.getIsOidc()) {
                return super.getNoteKey() + "WithC2cWithOidc";
            }
            return super.getNoteKey() + "WithC2c";
        }
        if (this.getIsOidc()) {
            return super.getNoteKey() + "WithOidc";
        }
        return super.getNoteKey();
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        if (this.isAdapterTasklet(taskletToEdit)) {
            if (!taskletToEdit.isCancelled() && !this.adapterTasklets.contains(taskletToEdit)) {
                IdpConfigAdapterMappingTasklet adapterTaskletToAdd = (IdpConfigAdapterMappingTasklet)taskletToEdit;
                adapterTaskletToAdd.setNewAdapter(false);
                this.adapterTasklets.add(adapterTaskletToAdd);
                Collections.sort(this.adapterTasklets);
            }
        } else if (!taskletToEdit.isCancelled() && !this.c2cTasklets.contains(taskletToEdit)) {
            IdpC2cContractMappingTasklet c2cTaskletToAdd = (IdpC2cContractMappingTasklet)taskletToEdit;
            c2cTaskletToAdd.setNewContract(false);
            this.c2cTasklets.add(c2cTaskletToAdd);
            Collections.sort(this.c2cTasklets);
        }
    }

    private boolean isAdapterTasklet(Tasklet t) {
        return t instanceof IdpConfigAdapterMappingTasklet;
    }

    public List<IdpConfigAdapterMappingTasklet> getAdapterTasklets() {
        return this.adapterTasklets;
    }

    public List<IdpC2cContractMappingTasklet> getC2cTasklets() {
        return this.c2cTasklets;
    }

    @Override
    public String getFirstColumnData(Tasklet t) {
        if (this.isAdapterTasklet(t)) {
            IdpConfigAdapterMappingTasklet at = (IdpConfigAdapterMappingTasklet)t;
            return at.getDescription();
        }
        IdpC2cContractMappingTasklet at = (IdpC2cContractMappingTasklet)t;
        return at.getDescription();
    }

    @Override
    public String getSecondColumnData(Tasklet t) {
        IdpConfigSessionMappingTasklet sessionMappingTasklet = (IdpConfigSessionMappingTasklet)t;
        return this.buildVirtualIdsString(sessionMappingTasklet.getVirtualServerIds());
    }

    @Override
    public String getThirdColumnData(Tasklet t) {
        return null;
    }

    @Override
    public String getFourthColumnData(Tasklet t) {
        return null;
    }

    private String buildVirtualIdsString(List<String> ids) {
        StringBuilder result = new StringBuilder();
        for (String virtualId : ids) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(virtualId);
        }
        return result.toString();
    }

    public boolean getIsC2cEnabled() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        return connTasklet.isC2cEnabled();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    @Override
    public boolean enableActionColumn() {
        return true;
    }
}

