/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.ArtifactLifetimeValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.ConnectionBase;

public class ConfigArtifactLifetimeState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String artifactLifetime = String.valueOf(60);

    public ConfigArtifactLifetimeState(Tasklet parent) {
        super(parent);
        this.setMenuName("Artifact Lifetime");
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConnectionBase connectionBase = (ConnectionBase)dataFromDisk;
        this.setArtifactLifetime(Integer.valueOf(connectionBase.getArtifactTimeoutSeconds()).toString());
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ArtifactLifetimeValidator validator = new ArtifactLifetimeValidator(this.artifactLifetime);
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Artifact_lifetime_in_seconds"), this.artifactLifetime, this));
    }

    @Override
    public boolean save(Object dataToDisk) {
        ConnectionBase tempCon = (ConnectionBase)dataToDisk;
        tempCon.setArtifactTimeoutSeconds(Integer.parseInt(this.artifactLifetime));
        return true;
    }

    @Override
    public void reset() {
        this.artifactLifetime = String.valueOf(60);
    }

    public String getArtifactLifetime() {
        return this.artifactLifetime;
    }

    public void setArtifactLifetime(String artifactLifetime) {
        this.artifactLifetime = artifactLifetime;
    }
}

