/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.JdbcFilterValidator;
import com.pingidentity.fsm.state.impl.ConfigPluginContractTasklet;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MappingTasklet;
import com.pingidentity.fsm.tasklet.impl.SpAttributeSourceTasklet;
import com.pingidentity.fsm.tasklet.impl.SpXaspTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.JdbcDataSource;

public class ConfigDatabaseFilterState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private JdbcDataSource dataSource;
    protected String whereTextArea;
    private Collection<String> adapterValues;
    protected List<String> assertionValues = new ArrayList<String>();
    private String tableName;
    public static final String LOCAL_USER_ID = IdpConnection.getLocalIdSubstitutionKey();

    public ConfigDatabaseFilterState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Database Filter");
    }

    @Override
    public void initialize() {
        AttributeSourceApi attrSrcTasklet = (AttributeSourceApi)((Object)this.getWizard());
        JdbcDataSource tempDataSource = (JdbcDataSource)attrSrcTasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.equals((Object)this.dataSource)) {
            this.dataSource = tempDataSource;
            this.reset();
        }
        this.populateLists();
    }

    @Override
    public void onStateActivated() {
        this.initialize();
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        AttributeSource source = mapping.getAttributeSource();
        this.dataSource = (JdbcDataSource)source.getDataSource();
        this.whereTextArea = mapping.getAttributeSource().getParameter("filter").trim();
        this.populateLists();
    }

    protected void populateLists() {
        AttributeSourceApi attrSrcTasklet = (AttributeSourceApi)((Object)this.getWizard());
        this.tableName = attrSrcTasklet.getTableName();
        this.createPluginList();
        this.createAssertionList();
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
        tempMapping.getAttributeSource().setParameter("filter", this.whereTextArea);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void reset() {
        this.whereTextArea = "";
    }

    protected ConfigurablePluginInstance getCurrentlySelectedPlugin() {
        MappingTasklet parent = this.findParent(MappingTasklet.class);
        return parent != null ? parent.getSelectedPlugin() : null;
    }

    public void createPluginList() {
        this.adapterValues = this.buildInputAttributesForFilter();
        if (this.adapterValues == null) {
            this.adapterValues = new LinkedHashSet<String>();
        }
    }

    public void createAssertionList() {
        AttributeNamesApi ana = this.findParent(AttributeNamesApi.class);
        List<String> items = ana.getAllAttrNamesSorted();
        if (this.accountLinkingEnabled()) {
            items.add(LOCAL_USER_ID);
        }
        this.assertionValues = items;
    }

    protected boolean accountLinkingEnabled() {
        return false;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        JdbcFilterValidator validator;
        this.initialize();
        if (!this.isViewOnly() && !(validator = new JdbcFilterValidator(this.whereTextArea, this.getSubstitutionVariables(), this.getSubstitutionVariableSourceName(), "", false)).validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    protected Set<String> getSubstitutionVariables() {
        Set<String> inputAttributesForFilter = this.buildInputAttributesForFilter();
        if (inputAttributesForFilter != null) {
            if (this.isShowPreviousAttributeSourceValues()) {
                inputAttributesForFilter.addAll(this.getPreviousAttributeSourceValues());
            }
            return inputAttributesForFilter;
        }
        return null;
    }

    protected Set<String> buildInputAttributesForFilter() {
        ArrayList<String> attrs;
        if (!this.isValidatingFilterVariables()) {
            return null;
        }
        ConfigPluginContractTasklet cpcTasklet = this.findParent(ConfigPluginContractTasklet.class);
        if (cpcTasklet != null) {
            return cpcTasklet.getAllAttributeNames();
        }
        LinkedHashSet<String> result = null;
        ConfigurablePluginInstance pluginInstance = null;
        pluginInstance = this.getCurrentlySelectedPlugin();
        if (pluginInstance == null) {
            attrs = new ArrayList<String>();
        } else {
            AttributeContract contract = pluginInstance.getAttributeContract();
            attrs = new ArrayList(contract.getAllAttributeNames());
        }
        MappingTasklet mappingTasklet = this.findParent(MappingTasklet.class);
        if (mappingTasklet != null) {
            Collection<String> additionalAttrsForFilter = mappingTasklet.getAdditionalInputAttributesForFilter();
            attrs.addAll(additionalAttrsForFilter);
        }
        Collections.sort(attrs);
        result = new LinkedHashSet<String>(attrs);
        return result;
    }

    public String getWhereTextArea() {
        return this.whereTextArea;
    }

    public void setWhereTextArea(String whereTextArea) {
        this.whereTextArea = whereTextArea.trim();
    }

    public Collection<String> getAdapterValues() {
        return this.adapterValues;
    }

    public void setAdapterValues(Collection<String> adapterValues) {
        this.adapterValues = adapterValues;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Collection<String> getAssertionValues() {
        return this.assertionValues;
    }

    public void setAssertionValues(List<String> assertionValues) {
        this.assertionValues = assertionValues;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Filter", this.getWhereTextArea(), this));
    }

    public boolean showAdapterValues() {
        return this.adapterValues != null && !this.adapterValues.isEmpty();
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }

    public String getValuesHeader() {
        String pluginTypeForDisplay = null;
        MappingTasklet parent = this.findParent(MappingTasklet.class);
        if (parent != null) {
            pluginTypeForDisplay = parent.getMappingSourceForDisplay();
        } else if (this.findParent(ConnectionTasklet.class) instanceof IdpConnectionConfigTasklet) {
            if (this.getIsOidc()) {
                return "Provider Claims";
            }
            pluginTypeForDisplay = "Assertion";
        }
        return pluginTypeForDisplay != null ? pluginTypeForDisplay + " Values" : "Values";
    }

    public List<String> getPreviousAttributeSourceValues() {
        SpAttributeSourceTasklet spAttributeSourceTasklet = this.findParent(SpAttributeSourceTasklet.class);
        return spAttributeSourceTasklet == null ? Collections.emptyList() : this.findParent(SpAttributeSourceTasklet.class).getPreviousAttributeSourceValues();
    }

    public boolean isShowPreviousAttributeSourceValues() {
        List<String> previousAttributeSourceValues = this.getPreviousAttributeSourceValues();
        return previousAttributeSourceValues != null && !previousAttributeSourceValues.isEmpty();
    }

    protected String getSubstitutionVariableSourceName() {
        return "adapter";
    }

    private boolean isValidatingFilterVariables() {
        return this.findParent(SpXaspTasklet.class) == null;
    }
}

