/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ProtocolSettingsTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConfigDomainCookieSettingsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean enableCommonDomainServer;
    private boolean enableSpUsingCDC;
    private boolean enableIdpUsingCDC;

    public ConfigDomainCookieSettingsState(Tasklet value) {
        super(value);
        this.setMenuName("Domain Cookie Settings");
    }

    @Override
    public void populate(Object dataFromDisk) {
        LocalSettings localSettings = (LocalSettings)dataFromDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        this.enableCommonDomainServer = idpDiscovery.isCommonDomainServer();
        this.enableSpUsingCDC = idpDiscovery.isSpCommonDomainClient();
        this.enableIdpUsingCDC = idpDiscovery.isIdpCommonDomainClient();
    }

    @Override
    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        idpDiscovery.setCommonDomainServer(this.enableCommonDomainServer);
        idpDiscovery.setSpCommonDomainClient(this.enableSpUsingCDC);
        idpDiscovery.setIdpCommonDomainClient(this.enableIdpUsingCDC);
        return true;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Common_domain_server"), Boolean.valueOf(this.enableCommonDomainServer).toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Sp_using_cdc"), Boolean.valueOf(this.enableSpUsingCDC).toString(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Idp_using_cdc"), Boolean.valueOf(this.enableIdpUsingCDC).toString(), this));
    }

    public boolean spOrIdpClientSelected() {
        return this.enableIdpUsingCDC || this.enableSpUsingCDC;
    }

    public boolean isSpEnabled() {
        ProtocolSettingsTasklet protocolSettingsTasklet = this.findParent(ProtocolSettingsTasklet.class);
        if (protocolSettingsTasklet != null) {
            return protocolSettingsTasklet.isSpEnabled();
        }
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        return localSettings.isEnableSP();
    }

    public boolean isIdpEnabled() {
        ProtocolSettingsTasklet protocolSettingsTasklet = this.findParent(ProtocolSettingsTasklet.class);
        if (protocolSettingsTasklet != null) {
            return protocolSettingsTasklet.isIdpEnabled();
        }
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        return localSettings.isEnableIdP();
    }

    public boolean isEnableSpUsingCDC() {
        return this.enableSpUsingCDC;
    }

    public void setEnableSpUsingCDC(boolean enableSpUsingCDC) {
        this.enableSpUsingCDC = enableSpUsingCDC;
    }

    public boolean isEnableIdpUsingCDC() {
        return this.enableIdpUsingCDC;
    }

    public void setEnableIdpUsingCDC(boolean enableIdpUsingCDC) {
        this.enableIdpUsingCDC = enableIdpUsingCDC;
    }

    public boolean isEnableCommonDomainServer() {
        return this.enableCommonDomainServer;
    }

    public void setEnableCommonDomainServer(boolean enableCommonDomainServer) {
        this.enableCommonDomainServer = enableCommonDomainServer;
    }
}

