/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.SingleTaskletState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.IdpDiscoveryTasklet;
import java.util.ArrayList;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConfigIdpDiscoveryState
extends SingleTaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final String NOT_CONFIGURED = "Not Configured";
    private static final String CONFIGURED = "Configured";
    private static final String SP = "SP";
    private static final String IDP = "IdP";
    private static final String BOTH = "IdP & SP";
    private String role;
    private boolean serverConfigured;
    private boolean spClient;
    private boolean idpClient;

    public ConfigIdpDiscoveryState(IWizard owner) {
        super(owner);
        this.setMenuName("IdP Discovery");
    }

    @Override
    public void refreshState() {
        this.populateAllStates(null);
    }

    @Override
    public boolean populateAllStates(Object data) {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings localSettings = localSettingsMgr.getLocalSettings();
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        this.serverConfigured = idpDiscovery.isCommonDomainServer();
        this.spClient = idpDiscovery.isSpCommonDomainClient();
        this.idpClient = idpDiscovery.isIdpCommonDomainClient();
        if (this.spClient && this.idpClient) {
            this.role = BOTH;
        } else if (this.spClient) {
            this.role = SP;
        } else if (this.idpClient) {
            this.role = IDP;
        }
        if (this.role != null) {
            this.createTaskletToEdit();
        }
        return true;
    }

    public Tasklet createTaskletToEdit() {
        IdpDiscoveryTasklet idpDiscoveryTasklet = (IdpDiscoveryTasklet)this.getTaskletToEdit();
        if (idpDiscoveryTasklet == null) {
            idpDiscoveryTasklet = this.createTaskletToLoad(IdpDiscoveryTasklet.class);
            LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
            LocalSettings localSettings = localSettingsMgr.getLocalSettings();
            idpDiscoveryTasklet.setMode(Mode.edit);
            idpDiscoveryTasklet.populate(localSettings);
            this.setTaskletToEdit(idpDiscoveryTasklet);
        }
        return idpDiscoveryTasklet;
    }

    @Override
    public boolean save(Object dataToDisk) {
        return true;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        Tasklet tasklet = this.getTaskletToEdit();
        if (tasklet != null) {
            tasklet.getSummary(summaryList);
        } else {
            summaryList.add(new SummaryInfo(this.getMenuName(), "", this, true));
            this.doSummary(summaryList);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Common Domain Server", this.getServerConfigured(), this));
        summaryList.add(new SummaryInfo("Common Domain Client", this.getClientConfigured(), this));
    }

    public String getClientConfigured() {
        return this.spClient || this.idpClient ? this.role : NOT_CONFIGURED;
    }

    public String getServerConfigured() {
        return this.serverConfigured ? CONFIGURED : NOT_CONFIGURED;
    }

    @Override
    public void reset() {
        this.populateAllStates(null);
    }
}

