/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.IdpDefaultUrlValidator;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConfigIdpEventsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private String successUrl;
    private String errMsg;
    private boolean confirmIdpSlo;
    private LocalSettings localSettings;

    public ConfigIdpEventsState(Tasklet value) {
        super(value);
        this.setMenuName("IdP Default URL");
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.localSettings = (LocalSettings)data;
        this.successUrl = this.localSettings.getIdpSloSuccessUrl();
        this.errMsg = this.localSettings.getIdpErrMsg();
        this.confirmIdpSlo = this.localSettings.isConfirmSlo();
        return true;
    }

    @Override
    public void reset() {
        this.populateAllStates(this.localSettings);
    }

    @Override
    public boolean save(Object dataFromDisk) {
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        LocalSettings tempLocalSettings = localSettingsMgr.getLocalSettings();
        tempLocalSettings.setIdpSloSuccessUrl(this.successUrl);
        tempLocalSettings.setIdpErrMsg(this.errMsg);
        tempLocalSettings.setConfirmSlo(this.confirmIdpSlo);
        localSettingsMgr.saveLocalSettings(tempLocalSettings, AdminAuditLogger.Component.IDP_CONFIG_DEFAULT_URLS);
        this.localSettings = tempLocalSettings;
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        IdpDefaultUrlValidator validator = new IdpDefaultUrlValidator.Builder().setIdpErrMsg(this.errMsg).setIdpSloSuccessUrl(this.isEnableSaml20IdpOrWsFedIdp() ? this.successUrl : "").build();
        if (!validator.validate()) {
            this.recordErrors(validator.getErrors(), delegate);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Success_url"), this.successUrl, this));
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public boolean isConfirmIdpSlo() {
        return this.confirmIdpSlo;
    }

    public void setConfirmIdpSlo(boolean confirmIdpSlo) {
        this.confirmIdpSlo = confirmIdpSlo;
    }

    public boolean isEnableSaml() {
        return this.localSettings.isEnableSamlIdP() || this.localSettings.isEnableSamlOneOneAp() || this.localSettings.isEnableSamlOneZeroAp();
    }

    public boolean isEnableSaml20IdpOrWsFedIdp() {
        return this.localSettings.isEnableSamlIdP() || this.localSettings.isEnableWsFedIdP();
    }
}

