/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenProcessorMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;

public class ConfigLdapDirAttrTypeState
extends TaskletState
implements Serializable {
    private static final long serialVersionUID = 20120601L;
    protected LdapDataSource dataSource;
    protected LinkedHashMap<String, LdapDataSource.LdapAttrEncodingType> selectedAttributesTypes;

    public ConfigLdapDirAttrTypeState(IWizard owner, String cardName) {
        super(owner, "LDAP Binary Attribute Encoding Types");
    }

    public ConfigLdapDirAttrTypeState(IWizard owner) {
        super(owner);
        this.setMenuName("LDAP Binary Attribute Encoding Types");
    }

    @Override
    public String getHelpId() {
        WsTrustTokenProcessorMappingTasklet parent = this.findParent(WsTrustTokenProcessorMappingTasklet.class);
        if (parent != null) {
            return super.getHelpId() + "_STS";
        }
        return super.getHelpId();
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.selectedAttributesTypes != null) {
            for (Map.Entry<String, LdapDataSource.LdapAttrEncodingType> entry : this.selectedAttributesTypes.entrySet()) {
                summaryList.add(new SummaryInfo(entry.getKey(), entry.getValue().getDisplayName(), this));
            }
        }
    }

    public Map<String, LdapDataSource.LdapAttrEncodingType> getSelectedAttributesTypes() {
        return this.selectedAttributesTypes;
    }

    @Override
    public void onStateActivated() {
        this.populateDefaultAttributeTypes();
    }

    private void populateDefaultAttributeTypes() {
        AttributeSourceApi parent = this.findParent(AttributeSourceApi.class);
        List<String> selectedAttributes = parent.getSelectedAttributes();
        this.dataSource = (LdapDataSource)parent.getSelectedDataSource();
        if (this.selectedAttributesTypes == null) {
            this.selectedAttributesTypes = new LinkedHashMap();
            if (selectedAttributes != null) {
                for (String attributeName : selectedAttributes) {
                    if (this.dataSource == null || this.dataSource.getBinaryAttributes() == null || !this.dataSource.getBinaryAttributes().contains(attributeName)) continue;
                    this.selectedAttributesTypes.put(attributeName, LdapDataSource.LdapAttrEncodingType.BASE64);
                }
            }
        } else {
            LinkedHashMap<String, LdapDataSource.LdapAttrEncodingType> tmpSelectedAttributesTypes = new LinkedHashMap<String, LdapDataSource.LdapAttrEncodingType>();
            if (selectedAttributes != null) {
                for (String attributeName : selectedAttributes) {
                    if (this.dataSource == null || this.dataSource.getBinaryAttributes() == null || !this.dataSource.getBinaryAttributes().contains(attributeName)) continue;
                    if (this.selectedAttributesTypes.get(attributeName) == null) {
                        tmpSelectedAttributesTypes.put(attributeName, LdapDataSource.LdapAttrEncodingType.BASE64);
                        continue;
                    }
                    tmpSelectedAttributesTypes.put(attributeName, this.selectedAttributesTypes.get(attributeName));
                }
                this.selectedAttributesTypes.clear();
                this.selectedAttributesTypes.putAll(tmpSelectedAttributesTypes);
            }
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        this.selectedAttributesTypes = new LinkedHashMap();
        this.populateDefaultAttributeTypes();
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        AttributeSource source = mapping.getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        if (source.getAttributeEncodingTypeMap() != null) {
            for (Map.Entry entry : source.getAttributeEncodingTypeMap().entrySet()) {
                this.selectedAttributesTypes.put((String)entry.getKey(), LdapDataSource.LdapAttrEncodingType.valueOf((String)((String)entry.getValue())));
            }
        }
    }

    public StringPairPropertySelectionModel getTypeModel() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        for (LdapDataSource.LdapAttrEncodingType ldapAttrDataType : LdapDataSource.LdapAttrEncodingType.values()) {
            model.add(ldapAttrDataType.getDisplayName(), ldapAttrDataType);
        }
        return model;
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping tempMapping = (AttributeMapping)dataToDisk;
        AttributeSource source = tempMapping.getAttributeSource();
        if (this.selectedAttributesTypes != null) {
            for (Map.Entry<String, LdapDataSource.LdapAttrEncodingType> attributeTypeEntry : this.selectedAttributesTypes.entrySet()) {
                source.setAttributeEncodingType(attributeTypeEntry.getKey(), attributeTypeEntry.getValue().toString());
            }
        }
        return true;
    }
}

