/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.validator.LdapSearchFilterValidator;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.LdapDataSource;

public abstract class ConfigLdapFilterState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    protected LdapDataSource dataSource;
    protected String origFilter;
    protected String filter;

    public ConfigLdapFilterState(Tasklet parent, String cardName) {
        super(parent, cardName);
        this.setMenuName("LDAP Filter");
    }

    @Override
    public void onStateActivated() {
        AttributeSourceApi attrSrcTasklet = (AttributeSourceApi)((Object)this.getWizard());
        LdapDataSource tempDataSource = (LdapDataSource)attrSrcTasklet.getSelectedDataSource();
        if (this.dataSource == null || tempDataSource != null && !tempDataSource.getId().equals(this.dataSource.getId())) {
            this.dataSource = tempDataSource;
            this.origFilter = "";
            this.filter = "";
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        AttributeMapping mapping = (AttributeMapping)dataFromDisk;
        AttributeSource source = mapping.getAttributeSource();
        this.dataSource = (LdapDataSource)source.getDataSource();
        this.filter = this.origFilter = mapping.getAttributeSource().getParameter("filter");
    }

    @Override
    public boolean save(Object dataToDisk) {
        AttributeMapping mapping = (AttributeMapping)dataToDisk;
        mapping.getAttributeSource().setParameter("filter", this.filter);
        return true;
    }

    @Override
    public void cancel(Object newData) {
        if (!this.isViewOnly()) {
            super.cancel(newData);
        }
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        String searchScope = this.getSelectedSearchScope();
        LdapSearchFilterValidator emptyFilterValidator = new LdapSearchFilterValidator(this.getFilter(), this.getLdapFilterRequiredMessage(), null, searchScope);
        if (!emptyFilterValidator.validate()) {
            this.recordErrors(emptyFilterValidator.getErrors(), delegate);
        } else if (this.isValidateFilter()) {
            LdapSearchFilterValidator validator;
            List<String> filterValues = this.getValues();
            List<String> previousAttributeSourceValues = this.getPreviousAttributeSourceValues();
            if (previousAttributeSourceValues != null) {
                filterValues.addAll(previousAttributeSourceValues);
            }
            if (!(validator = new LdapSearchFilterValidator(this.getFilter(), filterValues, "", this.getLdapFilterRequiredMessage(), ApiMessageKey.ldap_attribute_source_search_filter_var_not_found, null, searchScope, false)).validate()) {
                this.recordErrors(validator.getErrors(), delegate);
            }
        }
    }

    public ApiMessageKey getLdapFilterRequiredMessage() {
        return ApiMessageKey.ldap_attribute_source_search_filter_required;
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Filter"), this.filter, this));
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter.trim();
    }

    public String getValueText() {
        return "Adapter Values";
    }

    public abstract List<String> getValues();

    public List<String> getPreviousAttributeSourceValues() {
        return null;
    }

    private String getSelectedSearchScope() {
        String searchScope = "";
        Collection<TaskletState> states = this.getParent().getStateList();
        for (TaskletState state : states) {
            if (!(state instanceof ConfigLdapDirSearchState)) continue;
            ConfigLdapDirSearchState configLdapDirSearchState = (ConfigLdapDirSearchState)state;
            searchScope = configLdapDirSearchState.getSelectedSearchScope();
        }
        return searchScope;
    }

    public boolean isValidateFilter() {
        return true;
    }

    public boolean getIsOidc() {
        ConnectionTasklet connTasklet = this.findParent(ConnectionTasklet.class);
        if (connTasklet != null) {
            return connTasklet.isConnectionProtocolOIDC();
        }
        return false;
    }
}

