/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.ConfigurationArchiveUtil;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.ConfigurationArchiveTasklet;
import java.io.IOException;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class ConfigurationArchiveExportState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private final transient Mediator mediator;

    public ConfigurationArchiveExportState(IWizard owner) {
        this(owner, MgmtFactory.getMediator(), "Export");
    }

    public ConfigurationArchiveExportState(IWizard owner, Mediator mediator, String menuName) {
        super(owner);
        this.mediator = mediator;
        this.setMenuName(menuName);
    }

    public String getFilename() {
        return ConfigurationArchiveUtil.getFilename();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        ConfigurationArchiveTasklet tasklet = (ConfigurationArchiveTasklet)this.getParent();
        if (!tasklet.isExported()) {
            this.recordErrorMsg(this.getMessage("Common", "Export_not_clicked"));
        }
    }

    @Override
    public void reset() {
        ConfigurationArchiveTasklet tasklet = (ConfigurationArchiveTasklet)this.getParent();
        tasklet.setExported(false);
    }

    public byte[] getRawBytes() {
        ConfigurationArchiveTasklet tasklet = (ConfigurationArchiveTasklet)this.getParent();
        tasklet.setExported(true);
        try {
            return this.mediator.getZippedConfigFromFileSystem();
        }
        catch (IOException e) {
            this.log.error((Object)"Configuration archive creation failed.", (Throwable)e);
            return null;
        }
    }

    public AdminAuditLogger.Component getAuditLoggerComponent() {
        return AdminAuditLogger.Component.CONFIG_ARCHIVE;
    }
}

