/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.ApiMessageKey;
import com.pingidentity.admin.api.ApiMessages;
import com.pingidentity.admin.api.validator.ConfigArchiveValidator;
import com.pingidentity.common.upgrade.FilesUtils;
import com.pingidentity.common.upgrade.Utils;
import com.pingidentity.common.upgrade.Version;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.config.DataUpgradeConfigUtils;
import org.sourceid.saml20.domain.mgmt.impl.DataDeployer;

public class ConfigurationArchiveImportState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private transient IUploadFile archiveFile;
    private boolean forceImport = false;
    private boolean reencryptArchive = false;
    private boolean importSuccessful = false;
    private boolean errorsFound = false;
    private boolean confirmImportArchive = false;
    private boolean displayVersionWarning = false;
    private String versionWarningMessage;
    private boolean displayDataUpgradeWarning = false;
    private String dataUpgradeWarningMessage;
    Map<String, byte[]> archiveMap;

    public ConfigurationArchiveImportState(IWizard owner) {
        super(owner);
        this.setMenuName(this.getMessage("Menu_name"));
    }

    public void confirmImportArchive() {
        this.importSuccessful = false;
        if (this.archiveFile == null || StringUtils.isBlank((String)this.archiveFile.getFileName())) {
            String errMsg = ApiMessages.getMessage((ApiMessageKey)ApiMessageKey.config_archive_archive_not_selected);
            this.recordErrorMsg(errMsg);
        } else if (this.archiveFile.getSize() == 0L) {
            this.delegate.setFormComponent(null);
            this.delegate.record(this.getMessage("Archive_empty"), ValidationConstraint.REQUIRED);
        } else {
            ConfigArchiveValidator validator = new ConfigArchiveValidator(this.archiveFile.getStream());
            if (validator.validate()) {
                boolean enableDataUpgrade = DataUpgradeConfigUtils.isEnableDataUpgrade();
                Version sourceVersion = Utils.getSourceVersionFromConfigArchive((Map)validator.getArchiveMap());
                Version currentVersion = Utils.getCurrentPingFederateVersion();
                if (enableDataUpgrade && sourceVersion != null && Utils.eligibleForForceUpgrade((Version)sourceVersion, (Version)currentVersion)) {
                    this.displayDataUpgradeWarning = true;
                    this.dataUpgradeWarningMessage = this.getMessage("Data_upgrade_warning", new Object[]{sourceVersion.toString(), currentVersion.toString()});
                } else if (validator.hasVersionError()) {
                    this.displayVersionWarning = true;
                    this.versionWarningMessage = validator.getVersionError().getMessage();
                }
                this.archiveMap = validator.getArchiveMap();
                this.confirmImportArchive = true;
            } else {
                this.recordErrors(validator.getErrors(), (IValidationDelegate)this.delegate);
            }
        }
    }

    public void importArchive() {
        block13: {
            DataDeployer.DeployArchiveResult result;
            String archiveFileName;
            block12: {
                DataDeployer dataDeployer = new DataDeployer();
                archiveFileName = FilesUtils.removeZipExtension((String)this.archiveFile.getFileName());
                result = dataDeployer.deployArchive(this.archiveMap, archiveFileName, this.forceImport, true, this.reencryptArchive, this.getVisit().getCurrentUser());
                if (!result.isSuccess()) break block12;
                switch (result.getType()) {
                    case UPGRADE: {
                        this.log.info((Object)String.format("Upgrade from config archive \"%s\" completed successfully.", archiveFileName));
                        break block13;
                    }
                    case IMPORT: {
                        this.log.info((Object)"Config archive import completed successfully.");
                        break block13;
                    }
                    default: {
                        this.log.error((Object)("Unexpected DeployArchiveResult type: " + result.getType()));
                        throw new IllegalStateException("Unexpected DeployArchiveResult type: " + result.getType());
                    }
                }
            }
            switch (result.getType()) {
                case UPGRADE: {
                    if (!result.getUpgradeErrors().isEmpty()) {
                        this.recordErrorMessages(result.getUpgradeErrors());
                    }
                    if (result.getUpgradeErrors().isEmpty()) {
                        if (!this.forceImport && !result.getValidationErrors().isEmpty()) {
                            this.recordErrorMessages(result.getValidationErrors());
                        }
                        if (this.forceImport || result.getValidationErrors().isEmpty()) {
                            this.log.info((Object)String.format("Upgrade from config archive \"%s\" completed successfully.", archiveFileName));
                        }
                    }
                    this.errorsFound = !result.getUpgradeErrors().isEmpty() || !result.getValidationErrors().isEmpty();
                    break;
                }
                case IMPORT: {
                    if (this.forceImport) break;
                    this.recordErrorMessages(result.getValidationErrors());
                    break;
                }
                default: {
                    this.log.error((Object)("Unexpected DeployArchiveResult type: " + result.getType()));
                    throw new IllegalStateException("Unexpected DeployArchiveResult type: " + result.getType());
                }
            }
        }
        this.importSuccessful = !this.delegate.getHasErrors();
        this.confirmImportArchive = false;
        this.getVisit().getCurrentTasklet().setupNavMenuReload();
    }

    @Override
    public void reset() {
        this.importSuccessful = false;
        this.errorsFound = false;
        this.forceImport = false;
        this.reencryptArchive = false;
        this.displayVersionWarning = false;
        this.displayDataUpgradeWarning = false;
        this.cancelImportArchive();
    }

    public void cancelImportArchive() {
        this.confirmImportArchive = false;
        this.displayVersionWarning = false;
        this.displayDataUpgradeWarning = false;
        this.archiveMap = null;
    }

    public IUploadFile getArchiveFile() {
        return this.archiveFile;
    }

    public void setArchiveFile(IUploadFile archiveFile) {
        this.archiveFile = archiveFile;
    }

    public boolean isForceImport() {
        return this.forceImport;
    }

    public void setForceImport(boolean forceImport) {
        this.forceImport = forceImport;
    }

    public boolean isReencryptArchive() {
        return this.reencryptArchive;
    }

    public void setReencryptArchive(boolean reencryptArchive) {
        this.reencryptArchive = reencryptArchive;
    }

    public boolean isImportSuccessful() {
        return this.importSuccessful;
    }

    public boolean isErrorsFound() {
        return this.errorsFound;
    }

    public boolean isConfirmImportArchive() {
        return this.confirmImportArchive;
    }

    public void setConfirmImportArchive(boolean confirmImportArchive) {
        this.confirmImportArchive = confirmImportArchive;
    }

    public boolean isDisplayDataUpgradeWarning() {
        return this.displayDataUpgradeWarning;
    }

    public String getDataUpgradeWarningMessage() {
        return this.dataUpgradeWarningMessage;
    }

    public boolean isDisplayVersionWarning() {
        return this.displayVersionWarning;
    }

    public void setDisplayVersionWarning(boolean displayVersionWarning) {
        this.displayVersionWarning = displayVersionWarning;
    }

    public void setVersionWarningMessage(String versionWarningMessage) {
        this.versionWarningMessage = versionWarningMessage;
    }

    public String getVersionWarningMessage() {
        return "Warning: " + this.versionWarningMessage;
    }

    private void recordErrorMessages(List<String> errorMessages) {
        for (String errorMessage : errorMessages) {
            this.delegate.setFormComponent(null);
            this.delegate.record(errorMessage, ValidationConstraint.REQUIRED);
        }
    }
}

