/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.util.AdapterUtils;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.CustomDataSourceState;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.tasklet.api.RetrieveAttributeSourceInstance;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.DataSourceTasklet;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConfigureAttributeSourceAdapterState
extends CustomDataSourceState {
    private static final long serialVersionUID = 20050515L;
    private SourceDescriptor descriptor;
    private String sourceName;
    private String id;
    private boolean maskAttributeValues;

    public ConfigureAttributeSourceAdapterState(IWizard owner) {
        super(owner);
        this.setMenuName("Configure Data Store Instance");
    }

    @Override
    public void onStateActivated() {
        RetrieveAttributeSourceInstance parent = this.findParent(RetrieveAttributeSourceInstance.class);
        if (parent != null) {
            CustomDataSource source = parent.getSelectedCustomDataSource();
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            SourceDescriptor tempDescriptor = dsMgr.getSourceDescriptor(source.getDriverClassName());
            if (this.descriptor == null || !tempDescriptor.equals((Object)this.descriptor)) {
                this.descriptor = tempDescriptor;
                this.buildFieldAndTableItemsLists((PluginDescriptor)this.descriptor, null, null, null, false);
            }
            if (!this.isShowSourceName()) {
                this.sourceName = ((DataSourceTasklet)parent).getSourceName();
            }
            if (!this.isShowMaskLogValues()) {
                this.maskAttributeValues = ((DataSourceTasklet)parent).isMaskAttributeValues();
            }
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.customSource = (CustomDataSource)dataFromDisk;
        if (this.customSource != null) {
            this.populate();
        }
    }

    @Override
    protected void populate() {
        if (this.customSource != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            this.descriptor = dsMgr.getSourceDescriptor(this.customSource.getDriverClassName());
            this.buildFieldAndTableItemsLists((PluginDescriptor)this.descriptor, this.customSource.getConfiguration(), null, null, false);
            this.sourceName = this.customSource.getDescription();
            this.maskAttributeValues = this.customSource.isMaskAttributeValues();
            this.id = this.customSource.getId();
        }
    }

    @Override
    public boolean save(Object dataToDisk) {
        CustomDataSource tempSource = (CustomDataSource)dataToDisk;
        Configuration configuration = this.buildConfiguration();
        tempSource.setConfiguration(configuration);
        tempSource.setDescription(this.sourceName);
        tempSource.setDriverClassName(this.descriptor.getDriverClassName());
        tempSource.setMaskAttributeValues(this.maskAttributeValues);
        if (this.customSource != null) {
            tempSource.setId(this.customSource.getId());
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        super.appendErrors(delegate, component, fastFail);
        if (!this.isViewOnly() && component != null) {
            if (this.isShowSourceName() && StringUtils.isBlank((String)this.sourceName)) {
                IFormComponent ic = (IFormComponent)component.getComponent("instanceName");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Name_required"), ValidationConstraint.REQUIRED);
            }
            DataSourceTasklet dataSourceTasklet = this.getParent(DataSourceTasklet.class);
            if (this.isShowSourceName() && dataSourceTasklet.isDuplicate(this.sourceName, this.findParentState(ManageDataSourcesState.class), true)) {
                IFormComponent ic = (IFormComponent)component.getComponent("instanceName");
                delegate.setFormComponent(ic);
                delegate.record(this.getMessage("Instance_name_in_use"), ValidationConstraint.REQUIRED);
            }
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("InstanceName"), this.sourceName, this));
        if (this.isShowFIPSStatus()) {
            summaryList.add(new SummaryInfo(this.getMessage("Fips_status"), this.getFipsStatus(), this));
        }
        super.doSummary(summaryList);
        summaryList.add(new SummaryInfo(this.getMessage("Mask_attribute_values"), Boolean.toString(this.maskAttributeValues), this));
    }

    public CustomDataSource getCustomAttributeSource() {
        return this.customSource;
    }

    public CustomDataSource getTempCustomSource() {
        return this.createCustomAttributeSource(new CustomDataSource());
    }

    private CustomDataSource createCustomAttributeSource(CustomDataSource instance) {
        CustomDataSource tempcustomSource = instance;
        if (this.descriptor != null) {
            tempcustomSource.setDriverClassName(this.descriptor.getDriverClassName());
        }
        return tempcustomSource;
    }

    public void setAdapterInstance(CustomDataSource attributeSource) {
        this.customSource = attributeSource;
    }

    public String getId() {
        return this.id;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public String getName() {
        return this.sourceName;
    }

    public boolean isMaskAttributeValues() {
        return this.maskAttributeValues;
    }

    public void setMaskAttributeValues(boolean maskAttributeValues) {
        this.maskAttributeValues = maskAttributeValues;
    }

    @Override
    public boolean isShowSourceName() {
        return this.getParent().getMode() == Mode.edit;
    }

    @Override
    public boolean isShowMaskLogValues() {
        return this.getParent().getMode() == Mode.edit;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isShowFIPSStatus() {
        return PropertyInfo.isBCFIPSMode();
    }

    public String getFipsStatus() {
        return AdapterUtils.getPluginFipsStatus((String)this.descriptor.getPluginClassName(), (Map)this.descriptor.getMetadata()).getDisplayName();
    }
}

