/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.ConnMappingContractsState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.common.IDGenerator;

public class ConnMappingContractInfoState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String originalName = null;

    public ConnMappingContractInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("Contract Info");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.name)) {
            delegate.record(this.getMessage("name_empty"), ValidationConstraint.REQUIRED);
        } else if (this.isNameInUse()) {
            delegate.record(this.getMessage("duplicate_name", new Object[]{this.name}), ValidationConstraint.CONSISTENCY);
        }
    }

    private boolean isNameInUse() {
        ConnMappingContractsState state = this.findParentState(ConnMappingContractsState.class);
        return state.isDuplicateContractName(this.name, this.id);
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Contract Name", this.name, this));
    }

    @Override
    public void populate(Object obj) {
        C2cContract contract = (C2cContract)obj;
        this.id = contract.getId();
        this.name = contract.getName();
        this.originalName = contract.getName();
    }

    @Override
    public boolean save(Object obj) {
        C2cContract contract = (C2cContract)obj;
        this.createIdIfNeeded();
        contract.setId(this.id);
        contract.setName(this.name);
        return true;
    }

    public void createIdIfNeeded() {
        if (this.id == null) {
            this.id = IDGenerator.rndAlphaNumeric((int)16);
        }
    }
}

