/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.AutoSaveState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnMappingContractTasklet;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

@AutoSaveState
public class ConnMappingContractsState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    private final transient C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private static final Comparator<Tasklet> COMPARE_BY_NAME_DOWN = (Comparator & Serializable)(o1, o2) -> {
        ConnMappingContractTasklet tasklet1 = (ConnMappingContractTasklet)o1;
        ConnMappingContractTasklet tasklet2 = (ConnMappingContractTasklet)o2;
        return tasklet1.getContractName().compareToIgnoreCase(tasklet2.getContractName());
    };

    public ConnMappingContractsState(IWizard owner) {
        super(owner);
        this.setMenuName("Manage Contracts");
        this.buildTaskletList();
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.buildTaskletList();
    }

    private void buildTaskletList() {
        this.deleteAllTasklets();
        for (C2cContract contract : this.contractManager.getContracts()) {
            ConnMappingContractTasklet cmcTasklet = this.createTaskletToLoad(ConnMappingContractTasklet.class);
            cmcTasklet.setMode(Mode.edit);
            cmcTasklet.populate(contract);
            cmcTasklet.setFinishLabel("Save");
            this.addTasklet(cmcTasklet);
        }
        this.sort(COMPARE_BY_NAME_DOWN);
    }

    @Override
    public void deleteTasklet(Integer taskletToDelete) {
        ConnMappingContractTasklet contractTasklet = (ConnMappingContractTasklet)this.getTasklet(taskletToDelete);
        String contractId = contractTasklet.getContractId();
        contractTasklet.setItDeleted(true);
        if (contractId != null) {
            this.contractManager.deleteContract(contractId);
        }
    }

    @Override
    public void setTaskletToEdit(Tasklet taskletToEdit) {
        ConnMappingContractTasklet cmct = (ConnMappingContractTasklet)taskletToEdit;
        cmct.createIdIfNeeded();
        super.setTaskletToEdit(cmct);
        this.sort(COMPARE_BY_NAME_DOWN);
    }

    public boolean isDuplicateContractName(String name, String id) {
        for (Tasklet t : this.getTasklets()) {
            String cmcId;
            ConnMappingContractTasklet cmct = (ConnMappingContractTasklet)t;
            if (!cmct.getContractName().equalsIgnoreCase(name) || (cmcId = cmct.getContractId()) != null && cmcId.equals(id)) continue;
            return true;
        }
        return false;
    }

    public void createNewTasklet() {
        ConnMappingContractTasklet tasklet = this.createTaskletToLoad(ConnMappingContractTasklet.class, "ConnMappingContractTasklet", "Authentication Policy Contract");
        tasklet.setMode(Mode.create);
        tasklet.setFinishLabel("Save");
        tasklet.initialize();
        this.loadTasklet(tasklet);
    }

    public void edit(Integer indexToEdit, IRequestCycle cycle) {
        Tasklet tasklet = this.getTasklet(indexToEdit);
        this.loadTasklet(tasklet);
        tasklet.gotoSummaryState(cycle);
    }
}

