/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.admin.api.validator.LicenseConnectionValidator;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.ProtocolType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.module.connection.ConnectionModuleManager;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.module.connection.admin.AdminConnectionModuleManager;
import com.pingidentity.module.connection.admin.AdminConnectionModuleSupport;
import com.pingidentity.module.connection.admin.ConnectionModuleState;
import com.pingidentity.module.connection.admin.ModuleType;
import com.pingidentity.templates.connection.ConnectionTemplate;
import com.pingidentity.templates.connection.ConnectionTemplateManager;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsFedSpSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.scim.ScimVersion;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.license.LicenseConnectionGroup;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.handlers.WSTrustLicenseChecker;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class ConnRoleAndProtocolState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private static final String SALESFORCE_CRM_SAML2_SAAS_PLUGIN_DESC = "Salesforce.com CRM & Chatter";
    private static final String INBOUND_PROV_USER_TYPE = "InboundProvUser";
    private static final String INBOUND_PROV_USER_AND_GROUP_TYPE = "InboundProvUserAndGroup";
    private Protocol protocol;
    private WsTrustTokenType wsFedTokenType;
    private StringPairPropertySelectionModel wsFedTokenList;
    private boolean browserSsoProfileEnabled;
    private boolean browserSsoProfileEnabledOnPopulate = false;
    private boolean wsTrustStsEnabled;
    private boolean oAuthEnabled;
    private boolean inboundProvisioningEnabled;
    private boolean groupInboundProvisioningEnabled;
    private String selectedInboundProvisioningScimVersion = "SCIM 2.0";
    private ConnectionBase connection;
    private final Map<String, String> groupName2DisplayValue = new HashMap<String, String>();
    private final Map<String, String> displayValue2GroupName = new HashMap<String, String>();
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    private String selectedLicenseConnectionGroup = "";
    private final List<ConnectionModuleSelector> connectionModuleSelectors;
    private static final String jwtFriendlyName = "JWT";
    private Map<String, String> connectionTemplateProperties;
    private String selectedTargetType = "Standard";

    public ConnRoleAndProtocolState(Tasklet parent) {
        super(parent);
        this.setMenuName("Connection Type");
        if (this.isSpConnection()) {
            this.wsFedTokenType = WsTrustTokenType.SAML11;
            this.wsFedTokenList = new StringPairPropertySelectionModel();
            this.wsFedTokenList.add(ProtocolType.SAML11.getLabel(), WsTrustTokenType.SAML11);
            this.wsFedTokenList.add(ProtocolType.SAML20.getLabel(), WsTrustTokenType.SAML20);
            this.wsFedTokenList.add(jwtFriendlyName, WsTrustTokenType.JWT);
        }
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        this.protocol = localSettings.getDefaultProtocol(this.getConnectionType().equals(ConnectionType.SP.getName()));
        Role role = parent instanceof SpConnectionConfigTasklet ? Role.SP : Role.IDP;
        this.connectionModuleSelectors = this.buildConnectionModulesList(role);
        this.autoSelectSingleRole();
    }

    private void autoSelectSingleRole() {
        int numCheckboxesEnabled = 0;
        if (this.isBrowserSsoProfileCheckboxEnabled()) {
            ++numCheckboxesEnabled;
        }
        if (this.isWsTrustStsCheckboxEnabled()) {
            ++numCheckboxesEnabled;
        }
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            if (!moduleSelector.isCheckboxEnabled()) continue;
            ++numCheckboxesEnabled;
        }
        if (this.isOAuthCheckboxEnabled()) {
            ++numCheckboxesEnabled;
        }
        if (this.isInboundProvisioningCheckboxEnabled()) {
            ++numCheckboxesEnabled;
        }
        if (numCheckboxesEnabled == 1) {
            boolean connModuleSelected = false;
            if (this.isBrowserSsoProfileCheckboxEnabled()) {
                this.browserSsoProfileEnabled = true;
            } else if (this.isWsTrustStsCheckboxEnabled()) {
                this.wsTrustStsEnabled = true;
            } else if (!connModuleSelected) {
                for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
                    if (!moduleSelector.isCheckboxEnabled()) continue;
                    moduleSelector.setSelected(true);
                    connModuleSelected = true;
                }
            }
            if (!connModuleSelected) {
                if (this.isOAuthCheckboxEnabled()) {
                    this.oAuthEnabled = true;
                }
                if (this.isInboundProvisioningCheckboxEnabled()) {
                    this.inboundProvisioningEnabled = true;
                }
            }
        }
    }

    @Override
    public void onStateActivated() {
        this.enableDisableConnectionModuleCheckboxes();
        this.getParent().reconfigureTransitions();
    }

    @Override
    public boolean onStateExit() {
        if (this.isWsTrustStsEnabled() && !this.isBrowserSsoProfileEnabled()) {
            this.protocol = Protocol.SAML20;
        }
        if (this.isOAuthEnabled() && !this.isBrowserSsoProfileEnabled()) {
            this.protocol = Protocol.SAML20;
        }
        if (this.isInboundProvisioningEnabled() && !this.isBrowserSsoProfileEnabled() && !this.isWsTrustStsEnabled()) {
            this.protocol = Protocol.SAML20;
        }
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            if (!moduleSelector.isSelected()) continue;
            if (this.isBrowserSsoProfileEnabled()) break;
            this.protocol = Protocol.SAML20;
            break;
        }
        return true;
    }

    @Override
    public void populate(Object dataFromDisk) {
        SpConnection spConnection;
        this.connection = (ConnectionBase)dataFromDisk;
        this.browserSsoProfileEnabled = this.browserSsoProfileEnabledOnPopulate = this.connection.isBrowserSsoProfileConfigured();
        if (this.isSpConnection()) {
            spConnection = (SpConnection)dataFromDisk;
            this.selectedTargetType = spConnection.getConnectionTargetType();
        }
        this.protocol = ((ConnectionBase)dataFromDisk).getProtocol();
        this.wsTrustStsEnabled = this.connection.doesWsTrustSettingsExist();
        if (this.isIdpConnection()) {
            IdpConnection idpConnection = (IdpConnection)dataFromDisk;
            this.oAuthEnabled = idpConnection.doesOAuthSettingsExist();
            this.inboundProvisioningEnabled = idpConnection.doesInboundProvisioningExist();
            if (this.inboundProvisioningEnabled) {
                this.groupInboundProvisioningEnabled = idpConnection.doesInboundGroupProvisioningExist();
                this.selectedInboundProvisioningScimVersion = idpConnection.getInboundProvisioning().getVersion().getDisplayName();
            }
        } else {
            spConnection = (SpConnection)dataFromDisk;
            WsFedSpSettings wsFedSettings = spConnection.getWsFedSettings();
            if (wsFedSettings != null) {
                this.wsFedTokenType = wsFedSettings.getTokenType();
            }
        }
        if (this.isConnectionGroupDefined()) {
            this.selectedLicenseConnectionGroup = this.connection.getLicenseConnectionGroupAssignment();
        }
        this.connectionTemplateProperties = this.connection.getConnectionTemplateProperties();
        Role role = this.isIdpConnection() ? Role.IDP : Role.SP;
        AdminConnectionModuleSupport moduleSupport = AdminConnectionModuleSupport.getInstance();
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            Class<? extends ConnectionModuleConfiguration> configurationClass = moduleSupport.getConfigurationClassFromConnState(moduleSelector.getKey(), role);
            ConnectionModuleConfiguration connModuleConfig = this.connection.getModuleConfiguration(configurationClass);
            boolean moduleEnabled = connModuleConfig != null;
            moduleSelector.setSelected(moduleEnabled);
            if (!moduleSelector.hasConnectionModuleTypes()) continue;
            if (connModuleConfig != null && connModuleConfig.getType() != null) {
                if ("SaasProvisioner".equals(moduleSelector.getModuleId()) && "SalesforceCrmSaml2".equals(this.selectedTargetType) && moduleSelector.getAvailableTypes().getDescription("SalesforceCrmSaml2") == null) {
                    moduleSelector.getAvailableTypes().add(SALESFORCE_CRM_SAML2_SAAS_PLUGIN_DESC, "SalesforceCrmSaml2");
                    moduleSelector.getAvailableTypes().sort();
                }
                moduleSelector.setSelectedType(connModuleConfig.getType());
                continue;
            }
            if (!moduleSelector.isModuleSupportedByTargetType()) continue;
            if ("SaasProvisioner".equals(moduleSelector.getModuleId()) && "SalesforceCrmSaml2".equals(this.selectedTargetType)) {
                moduleSelector.setSelectedType("SalesForce");
                continue;
            }
            moduleSelector.setSelectedType(this.selectedTargetType);
        }
        this.getParent().reconfigureTransitions();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.connection = (ConnectionBase)dataToDisk;
        if (this.isSpConnection()) {
            SpConnection spConn = (SpConnection)this.connection;
            spConn.setConnectionTargetType(this.selectedTargetType);
            if (this.protocol == Protocol.WSFED) {
                WsFedSpSettings wsFedSettings = new WsFedSpSettings();
                wsFedSettings.setTokenType(this.wsFedTokenType);
                spConn.setWsFedSettings(wsFedSettings);
            }
        }
        this.connection.setProtocol(this.protocol);
        this.connection.setLicenseConnectionGroupAssignment(this.selectedLicenseConnectionGroup);
        this.connection.setConnectionTemplateProperties(this.connectionTemplateProperties);
        AdminConnectionModuleSupport moduleSupport = AdminConnectionModuleSupport.getInstance();
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            ConnectionModuleSupport runtimeModuleSupport;
            if (!moduleSelector.isSelected()) {
                ConnectionModuleManager manager = moduleSupport.getManagerFromState(moduleSelector.getKey(), this.connection.getRoleType());
                String entityId = ((ConnectionTasklet)this.getParent()).getConnId();
                manager.deleteConfiguration(entityId);
                continue;
            }
            Role role = this.isIdpConnection() ? Role.IDP : Role.SP;
            Class<? extends ConnectionModuleConfiguration> configurationClass = moduleSupport.getConfigurationClassFromConnState(moduleSelector.getKey(), role);
            ConnectionModuleConfiguration moduleConfig = this.connection.getModuleConfiguration(configurationClass);
            if (moduleConfig == null && (moduleConfig = (runtimeModuleSupport = ConnectionModuleSupport.getInstance()).createNewConfiguration(moduleSelector.getModuleId(), this.connection.getRoleType())) != null) {
                this.connection.addConnectionModuleConfiguration(moduleConfig);
            }
            if (moduleConfig == null || !moduleSelector.hasConnectionModuleTypes()) continue;
            moduleConfig.setType(moduleSelector.getSelectedType());
        }
        return true;
    }

    public boolean isStandardConnection() {
        return "Standard".equals(this.selectedTargetType);
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        boolean atLeastOneSelected;
        boolean bl = atLeastOneSelected = this.browserSsoProfileEnabled || this.wsTrustStsEnabled || this.oAuthEnabled || this.inboundProvisioningEnabled;
        if (!atLeastOneSelected) {
            for (ConnectionModuleSelector connectionModuleSelector : this.connectionModuleSelectors) {
                if (!connectionModuleSelector.isSelected()) continue;
                atLeastOneSelected = true;
                break;
            }
        }
        if (!atLeastOneSelected) {
            ArrayList writeValidOptions = new ArrayList();
            if (this.isBrowserSsoProfileCheckboxEnabled()) {
                writeValidOptions.add(this.getMessage("Browser_sso_profiles"));
            }
            if (this.isWsTrustStsCheckboxEnabled()) {
                writeValidOptions.add(this.getMessage("WS_trust_sts"));
            }
            if (this.isOAuthCheckboxEnabled()) {
                writeValidOptions.add(this.getMessage("OAuth_as"));
            }
            if (this.isInboundProvisioningCheckboxEnabled()) {
                writeValidOptions.add(this.getMessage("InboundProv"));
            }
            for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
                if (!moduleSelector.isCheckboxEnabled()) continue;
                writeValidOptions.add(moduleSelector.getDescription());
            }
            if (writeValidOptions.size() == 1) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("minimum_requirements_not_met_1", new Object[]{writeValidOptions.get(0)}), ValidationConstraint.REQUIRED);
            } else if (writeValidOptions.size() > 1) {
                StringBuffer stringBuffer = new StringBuffer();
                int lastElementIndex = writeValidOptions.size() - 1;
                for (int i = 0; i < lastElementIndex; ++i) {
                    stringBuffer.append((String)writeValidOptions.get(i));
                    if (i >= lastElementIndex - 1) continue;
                    stringBuffer.append(", ");
                }
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("minimum_requirements_not_met_2", new Object[]{stringBuffer.toString(), writeValidOptions.get(lastElementIndex)}), ValidationConstraint.REQUIRED);
            }
        }
        for (ConnectionModuleSelector connectionModuleSelector : this.connectionModuleSelectors) {
            if (!connectionModuleSelector.isSelected() || !connectionModuleSelector.hasConnectionModuleTypes() || connectionModuleSelector.getSelectedType() != null) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Type_not_selected", new Object[]{connectionModuleSelector.getDescription()}), ValidationConstraint.REQUIRED);
        }
        List errors = LicenseConnectionValidator.getInstance().validate(this.connection, this.selectedLicenseConnectionGroup, this.browserSsoProfileEnabled, this.wsTrustStsEnabled);
        this.recordErrors(errors, delegate);
        if (this.protocol == null && this.isBrowserSsoProfileCheckboxEnabled() && this.isBrowserSsoProfileEnabled()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Protocol_required"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Connection Role", this.getConnectionType(), this));
        summaryList.add(new SummaryInfo(this.getMessage("Browser_sso_profiles"), Boolean.toString(this.isBrowserSsoProfileEnabled()), this));
        if (this.isBrowserSsoProfileEnabled()) {
            summaryList.add(new SummaryInfo("Protocol", ProtocolType.getProtocolStringForType(this.protocol), this));
            if (Protocol.WSFED == this.protocol && this.wsFedTokenType != null) {
                summaryList.add(new SummaryInfo("WS-Federation Token Type", this.wsFedTokenType.name(), this));
            }
            if (this.isSpConnection()) {
                String selectedTargetDescription = this.getSelectedTargetTypeDescription();
                summaryList.add(new SummaryInfo("Connection Template", selectedTargetDescription, this));
            }
        }
        summaryList.add(new SummaryInfo(this.getMessage("WS_trust_sts"), new Boolean(this.isWsTrustStsEnabled()).toString(), this));
        if (this.isIdpConnection()) {
            summaryList.add(new SummaryInfo(this.getMessage("OAuth_as"), new Boolean(this.isOAuthEnabled()).toString(), this));
            String inboundProvMode = null;
            if (this.isInboundProvisioningEnabled()) {
                inboundProvMode = this.isGroupInboundProvisioningEnabled() ? this.getMessage("UserAndGroupInboundProv") : this.getMessage("UserInboundProv");
                summaryList.add(new SummaryInfo(this.getMessage("InboundProv"), inboundProvMode, this));
                if (StringUtils.isNotEmpty((String)this.selectedInboundProvisioningScimVersion)) {
                    summaryList.add(new SummaryInfo(this.getMessage("InboundProvVersion"), this.selectedInboundProvisioningScimVersion, this));
                }
            } else {
                summaryList.add(new SummaryInfo(this.getMessage("InboundProv"), Boolean.FALSE.toString(), this));
            }
        }
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            summaryList.add(new SummaryInfo(moduleSelector.getDescription(), new Boolean(moduleSelector.isSelected()).toString(), this));
            if (!moduleSelector.isSelected()) continue;
            summaryList.add(new SummaryInfo(moduleSelector.getDescription() + " Type", moduleSelector.getSelectedTypeDescription(), this));
            if (!this.isBCFIPSMode()) continue;
            summaryList.add(new SummaryInfo(moduleSelector.getDescription() + " FIPS Status", moduleSelector.getSelectedTypeFipsStatus(), this));
        }
        if (!StringUtils.isEmpty((String)this.selectedLicenseConnectionGroup)) {
            summaryList.add(new SummaryInfo(this.getMessage("License_group"), this.selectedLicenseConnectionGroup, this));
        }
    }

    public boolean isSpConnection() {
        Tasklet t = this.getParent();
        return t instanceof SpConnectionConfigTasklet;
    }

    public String getConnectionType() {
        ConnectionTasklet t = (ConnectionTasklet)this.getWizard();
        return t.getConnectionType().getName();
    }

    public boolean isNewConnection() {
        return this.connection == null;
    }

    public String getSelectedConnectionModuleType(Class<? extends ConnectionModuleState> connectionModuleStateClass) {
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            if (!moduleSelector.getKey().equals(connectionModuleStateClass)) continue;
            return moduleSelector.getSelectedType();
        }
        return null;
    }

    public String getSelectedTargetType() {
        return this.selectedTargetType;
    }

    public String getSelectedTargetTypeDescription() {
        String description = "No Template";
        ConnectionTemplateManager templateManager = new ConnectionTemplateManager();
        Role role = this.isSpConnection() ? Role.SP : Role.IDP;
        ConnectionTemplate selectedConnectionTemplate = templateManager.getConnectionTemplate(role, this.selectedTargetType);
        if (selectedConnectionTemplate != null) {
            description = selectedConnectionTemplate.getDescription();
        }
        return description;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (protocol != null && this.protocol != protocol) {
            this.protocol = protocol;
            this.clearOtherProtocolsForOIDC(protocol);
            this.getParent().reconfigureTransitions();
        }
    }

    private void clearOtherProtocolsForOIDC(Protocol protocol) {
        if (Protocol.OIDC == protocol) {
            this.setWsTrustStsEnabled(false);
            this.setOAuthEnabled(false);
            this.setInboundProvisioningEnabled(false);
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.isStandardConnection() || !this.browserSsoProfileEnabled) {
            this.setProtocol(this.getProtocol());
        }
        this.enableDisableConnectionModuleCheckboxes();
    }

    public boolean isIdpConnection() {
        return this.findParent(IdpConnectionConfigTasklet.class) != null;
    }

    public boolean isBrowserSsoProfileEnabledOnPopulate() {
        return this.browserSsoProfileEnabledOnPopulate;
    }

    public boolean isBrowserSsoProfileEnabled() {
        return this.browserSsoProfileEnabled;
    }

    public void setBrowserSsoProfileEnabled(boolean browserSsoProfileEnabled) {
        this.browserSsoProfileEnabled = browserSsoProfileEnabled;
        if (this.browserSsoProfileEnabled) {
            this.clearOtherProtocolsForOIDC(this.getProtocol());
        }
    }

    public boolean isOAuthEnabled() {
        return this.oAuthEnabled;
    }

    public void setOAuthEnabled(boolean oAuthEnabled) {
        this.oAuthEnabled = oAuthEnabled;
    }

    public boolean isInboundProvisioningEnabled() {
        return this.inboundProvisioningEnabled;
    }

    public void setInboundProvisioningEnabled(boolean inboundProvisioningEnabled) {
        this.inboundProvisioningEnabled = inboundProvisioningEnabled;
    }

    public boolean isWsTrustStsEnabled() {
        return this.wsTrustStsEnabled;
    }

    public void setWsTrustStsEnabled(boolean wsTrustStsEnabled) {
        this.wsTrustStsEnabled = wsTrustStsEnabled;
    }

    public boolean isWsTrustEnabledInServerSettings() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return this.isSpConnection() ? localSettings.isEnableWsTrustIdP() : localSettings.isEnableWsTrustSp();
    }

    public boolean isOAuthEnabledInServerSettings() {
        return MgmtFactory.getAuthzServerManager().isEnableOAuth();
    }

    public boolean isInboundProvisioningEnabledInServerSettings() {
        return MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableInboundProvisioning();
    }

    public boolean isBrowserSsoProfileCheckboxEnabled() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        return this.isSpConnection() ? localSettings.isEnableProtocolIdP(this.protocol) : localSettings.isEnableProtocolSp(this.protocol);
    }

    public boolean isWsTrustStsCheckboxEnabled() {
        return this.isWsTrustEnabledInServerSettings() && WSTrustLicenseChecker.isEnabled() && !this.isOIDCProtocolSelected();
    }

    public boolean isOAuthCheckboxEnabled() {
        PingLicense license = LicenseManager.getLicense();
        return this.isIdpConnection() && this.isOAuthEnabledInServerSettings() && MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getDefaultInstance() != null && license.isOAuthEnabled();
    }

    private boolean isOIDCProtocolSelected() {
        return this.browserSsoProfileEnabled && this.protocol == Protocol.OIDC;
    }

    public boolean isInboundProvisioningCheckboxEnabled() {
        return this.isIdpConnection() && this.isInboundProvisioningEnabledInServerSettings() && !this.isOIDCProtocolSelected();
    }

    public boolean isConnectionGroupDefined() {
        return LicenseManager.isConnectionGroupDefined();
    }

    public StringPairPropertySelectionModel getLicenseConnectionGroupList() {
        List availableGroups = LicenseConnectionValidator.getInstance().getAvailableLicenseConnectionGroups(this.connection, this.browserSsoProfileEnabled, this.wsTrustStsEnabled);
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(true);
        if (availableGroups != null && !availableGroups.isEmpty()) {
            Collections.sort(availableGroups);
            for (LicenseConnectionGroup grp : availableGroups) {
                String groupName = grp.getGroupName();
                String displayValue = this.makeDisplayValue(grp);
                this.groupName2DisplayValue.put(groupName, displayValue);
                this.displayValue2GroupName.put(displayValue, groupName);
                model.add(displayValue, displayValue);
            }
        }
        return model;
    }

    public String getSelectedLicenseConnectionGroup() {
        return this.groupName2DisplayValue.get(this.selectedLicenseConnectionGroup);
    }

    public void setSelectedLicenseConnectionGroup(String selectedLicenseConnectionGroup) {
        this.selectedLicenseConnectionGroup = this.displayValue2GroupName.get(selectedLicenseConnectionGroup);
    }

    private String makeDisplayValue(LicenseConnectionGroup grp) {
        Object retV = "";
        if (grp != null) {
            retV = grp.getGroupName() + " (" + this.dateFormatter.format(grp.getEffectiveDate()) + "-" + this.dateFormatter.format(grp.getExpirationDate()) + ", " + grp.getConnectionLimit() + ")";
        }
        return retV;
    }

    private List<ConnectionModuleSelector> buildConnectionModulesList(Role role) {
        AdminConnectionModuleSupport connectionModuleSupport = AdminConnectionModuleSupport.getInstance();
        List<AdminConnectionModuleManager> connectionModuleManagers = connectionModuleSupport.getAdminManagers(role);
        ArrayList<ConnectionModuleSelector> modules = new ArrayList<ConnectionModuleSelector>();
        for (AdminConnectionModuleManager adminConnectionModuleManager : connectionModuleManagers) {
            Class<? extends ConnectionModuleState> key = connectionModuleSupport.getConnectionStateClass(adminConnectionModuleManager.getClass(), role);
            String description = adminConnectionModuleManager.getDescription();
            ConnectionModuleSelector moduleSelector = new ConnectionModuleSelector(adminConnectionModuleManager.getModuleId(), key, description, false, adminConnectionModuleManager.getConnectionModuleTypes());
            modules.add(moduleSelector);
        }
        return modules;
    }

    public boolean isConnectionModuleSelected(Class<? extends ConnectionModuleState> moduleStateClass) {
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            if (moduleSelector.getKey() != moduleStateClass) continue;
            return moduleSelector.isSelected();
        }
        return false;
    }

    public boolean isConnectionModuleSelected(String moduleId) {
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            if (!moduleSelector.getModuleId().equals(moduleId)) continue;
            return moduleSelector.isSelected();
        }
        return false;
    }

    public List<ConnectionModuleSelector> getConnectionModuleSelectors() {
        return this.connectionModuleSelectors;
    }

    private void enableDisableConnectionModuleCheckboxes() {
        Role role = this.isIdpConnection() ? Role.IDP : Role.SP;
        AdminConnectionModuleSupport moduleSupport = AdminConnectionModuleSupport.getInstance();
        for (ConnectionModuleSelector moduleSelector : this.connectionModuleSelectors) {
            AdminConnectionModuleManager connectionModuleManager = moduleSupport.getAdminManagerFromConnState(moduleSelector.getKey(), role);
            boolean selectable = connectionModuleManager.isSelectableInConnection((ConnectionTasklet)this.getParent());
            moduleSelector.setCheckboxEnabled(selectable);
        }
    }

    public boolean isGroupInboundProvisioningEnabled() {
        return ScimVersion.SCIM11.equals((Object)this.getInboundProvisioningScimVersion()) && this.groupInboundProvisioningEnabled;
    }

    public String getInboundProvType() {
        if (this.isGroupInboundProvisioningEnabled()) {
            return INBOUND_PROV_USER_AND_GROUP_TYPE;
        }
        return INBOUND_PROV_USER_TYPE;
    }

    public void setInboundProvType(String inboundProvType) {
        this.groupInboundProvisioningEnabled = INBOUND_PROV_USER_AND_GROUP_TYPE.equals(inboundProvType);
    }

    public String getUserOnlyInboundProvType() {
        return INBOUND_PROV_USER_TYPE;
    }

    public String getUserAndGroupInboundProvType() {
        return INBOUND_PROV_USER_AND_GROUP_TYPE;
    }

    public WsTrustTokenType getWsFedTokenType() {
        return this.wsFedTokenType;
    }

    public String getWsFedTokenLabel() {
        if (this.wsFedTokenType == WsTrustTokenType.JWT) {
            return jwtFriendlyName;
        }
        if (this.wsFedTokenType == WsTrustTokenType.SAML20) {
            return ProtocolType.SAML20.getLabel();
        }
        return ProtocolType.SAML11.getLabel();
    }

    public void setWsFedTokenType(WsTrustTokenType tokenType) {
        this.wsFedTokenType = tokenType;
    }

    public StringPairPropertySelectionModel getWsFedTokenList() {
        return this.wsFedTokenList;
    }

    public StringPairPropertySelectionModel getInboundProvisioningScimVersions() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel(false);
        model.add("SCIM 1.1", "SCIM 1.1");
        model.add("SCIM 2.0", "SCIM 2.0");
        return model;
    }

    public String getSelectedInboundProvisioningScimVersion() {
        return this.selectedInboundProvisioningScimVersion;
    }

    public void setSelectedInboundProvisioningScimVersion(String selectedInboundProvisioningScimVersion) {
        this.selectedInboundProvisioningScimVersion = selectedInboundProvisioningScimVersion;
    }

    public ScimVersion getInboundProvisioningScimVersion() {
        return ScimVersion.fromDisplayName((String)this.selectedInboundProvisioningScimVersion);
    }

    public boolean showInboundProvisioningType() {
        return "SCIM 1.1".equals(this.selectedInboundProvisioningScimVersion);
    }

    public boolean isBCFIPSMode() {
        return PropertyInfo.isBCFIPSMode();
    }

    private class ConnectionModuleSelector
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String OUTBOUND_PROV_MODULE_ID = "SaasProvisioner";
        private static final String SALESFORCE_CRM_SAAS_PLUGIN_ID = "SalesForce";
        private static final String SALESFORCE_CRM_SAML2_SAAS_PLUGIN_ID = "SalesforceCrmSaml2";
        private final String moduleId;
        private final Class<? extends ConnectionModuleState> key;
        private final String description;
        private boolean selected = false;
        private boolean checkboxEnabled;
        private StringPairPropertySelectionModel availableTypesModel;
        private String selectedTypeId;
        private Map<String, ModuleType> typesById = new HashMap<String, ModuleType>();

        public ConnectionModuleSelector(String moduleId, Class<? extends ConnectionModuleState> ky, String desc, boolean chxEnabled, Map<String, ModuleType> typesById) {
            this.moduleId = moduleId;
            this.key = ky;
            this.description = desc;
            this.checkboxEnabled = chxEnabled;
            this.typesById = typesById;
            if (typesById != null && !typesById.isEmpty()) {
                this.availableTypesModel = new StringPairPropertySelectionModel(true);
                for (ModuleType moduleType : typesById.values()) {
                    if (!moduleType.isUserSelectable()) continue;
                    this.availableTypesModel.add(moduleType.getDescription(), moduleType.getId());
                }
                if (OUTBOUND_PROV_MODULE_ID.equals(moduleId) && typesById.containsKey(SALESFORCE_CRM_SAAS_PLUGIN_ID) && typesById.containsKey(SALESFORCE_CRM_SAML2_SAAS_PLUGIN_ID)) {
                    this.availableTypesModel.removeById(SALESFORCE_CRM_SAML2_SAAS_PLUGIN_ID);
                }
                this.availableTypesModel.sort();
            }
        }

        public String getModuleId() {
            return this.moduleId;
        }

        public Class<? extends ConnectionModuleState> getKey() {
            return this.key;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isCheckboxEnabled() {
            return this.checkboxEnabled;
        }

        public void setCheckboxEnabled(boolean checkboxEnabled) {
            this.checkboxEnabled = checkboxEnabled;
        }

        public boolean hasConnectionModuleTypes() {
            return this.availableTypesModel != null && this.availableTypesModel.getOptionCount() > 0 || this.isModuleSupportedByTargetType();
        }

        public StringPairPropertySelectionModel getAvailableTypes() {
            return this.availableTypesModel;
        }

        public String getSelectedType() {
            return this.selectedTypeId;
        }

        public void setSelectedType(String id) {
            this.selectedTypeId = id;
        }

        public String getSelectedTypeDescription() {
            ModuleType moduleType = this.typesById.get(this.selectedTypeId);
            if (moduleType != null) {
                return moduleType.getDescription();
            }
            return null;
        }

        public String getSelectedTypeFipsStatus() {
            ModuleType moduleType = this.typesById.get(this.selectedTypeId);
            if (moduleType != null) {
                return moduleType.getFipsStatus().getDisplayName();
            }
            return "";
        }

        public boolean isModuleSupportedByTargetType() {
            return this.typesById.containsKey(ConnRoleAndProtocolState.this.selectedTargetType);
        }
    }
}

