/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import java.util.ArrayList;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.IdpDiscovery;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.idp.HandleAuthnRequest;

public class ConnectionOptionsState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    private boolean browserSsoEnabled = true;
    private boolean attributeQueryEnabled;
    private boolean attributeQueryCheckboxEnabled = true;
    private boolean userProvisioningEnabled;
    private boolean oAuthAttributeMappingEnabled;
    private boolean idpDiscoveryEnabled = HandleAuthnRequest.isEnableCDCDuringSSO();
    private ConnectionBase connection;

    public ConnectionOptionsState(Tasklet parent) {
        super(parent);
        this.setMenuName("Connection Options");
    }

    @Override
    public void onStateActivated() {
        if (!this.isConnectionProtocol20()) {
            this.browserSsoEnabled = true;
            this.attributeQueryCheckboxEnabled = false;
            this.attributeQueryEnabled = false;
        } else if (this.isIdpConnection() && ((IdpConnectionConfigTasklet)this.getParent()).isAttributeQueryEnabledInUserProvisioning()) {
            this.attributeQueryEnabled = true;
            this.attributeQueryCheckboxEnabled = false;
        } else {
            this.attributeQueryCheckboxEnabled = true;
        }
        if (!this.isIdpDiscoveryCheckboxEnabled()) {
            this.idpDiscoveryEnabled = false;
        }
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.connection = (ConnectionBase)dataFromDisk;
        boolean bl = this.browserSsoEnabled = this.connection.getEnabledProfiles().isIdpInitiatedSSOEnabled() || this.connection.getEnabledProfiles().isSpInitiatedSSOEnabled();
        if (this.connection instanceof SpConnection) {
            this.attributeQueryEnabled = ((SpConnection)this.connection).getAttributeRequester() != null;
            this.idpDiscoveryEnabled = this.browserSsoEnabled && ((SpConnection)this.connection).isEnableCDCDuringSSO();
        } else if (this.connection instanceof IdpConnection) {
            IdpConnection idpConn = (IdpConnection)this.connection;
            this.attributeQueryEnabled = idpConn.getAttributeAuthority() != null;
            this.userProvisioningEnabled = idpConn.getUserProvisioning() != null;
            this.oAuthAttributeMappingEnabled = idpConn.hasSsoToOAuthAttrMapping() || idpConn.hasOAuthApcId();
        }
        this.getParent().reconfigureTransitions();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.connection = (ConnectionBase)dataToDisk;
        if (this.connection instanceof SpConnection) {
            ((SpConnection)this.connection).setEnableCDCDuringSSO(this.idpDiscoveryEnabled);
        }
        if (!this.isAttributeQueryEnabled()) {
            if (this.connection instanceof SpConnection) {
                ((SpConnection)this.connection).setAttributeRequester(null);
            } else if (this.connection instanceof IdpConnection) {
                ((IdpConnection)this.connection).setAttributeAuthority(null);
            }
        }
        return true;
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (!this.browserSsoEnabled && !this.attributeQueryEnabled) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Minimum_requirements_not_met"), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("Browser_sso"), new Boolean(this.isBrowserSsoEnabled()).toString(), this));
        if (!this.isIdpConnection()) {
            summaryList.add(new SummaryInfo(this.getMessage("Idp_discovery"), new Boolean(this.isIdpDiscoveryEnabled()).toString(), this));
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("User_provisioning"), new Boolean(this.isUserProvisioningEnabled()).toString(), this));
            summaryList.add(new SummaryInfo(this.getMessage("OAuth_Attribute_Mapping"), new Boolean(this.isOAuthAttributeMappingEnabled()).toString(), this));
        }
        summaryList.add(new SummaryInfo(this.getMessage("Attribute_query"), new Boolean(this.isAttributeQueryEnabled()).toString(), this));
    }

    public String getConnectionType() {
        ConnectionTasklet t = (ConnectionTasklet)this.getWizard();
        return t.getConnectionType().getName();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void formListener(IRequestCycle cycle) {
        if (!this.browserSsoEnabled) {
            this.idpDiscoveryEnabled = false;
            this.oAuthAttributeMappingEnabled = false;
            this.userProvisioningEnabled = false;
        }
    }

    public boolean isIdpConnection() {
        return this.findParent(IdpConnectionConfigTasklet.class) != null;
    }

    public boolean isBrowserSsoEnabled() {
        return this.browserSsoEnabled;
    }

    public void setBrowserSsoEnabled(boolean browserSsoEnabled) {
        this.browserSsoEnabled = browserSsoEnabled;
    }

    public boolean isAttributeQueryEnabled() {
        return this.attributeQueryEnabled;
    }

    public void setAttributeQueryEnabled(boolean attributeQueryEnabled) {
        this.attributeQueryEnabled = attributeQueryEnabled;
    }

    public boolean isUserProvisioningEnabled() {
        return this.userProvisioningEnabled;
    }

    public void setUserProvisioningEnabled(boolean userProvisioningEnabled) {
        this.userProvisioningEnabled = userProvisioningEnabled;
    }

    public boolean isOAuthAttributeMappingEnabled() {
        return this.oAuthAttributeMappingEnabled;
    }

    public void setOAuthAttributeMappingEnabled(boolean oAuthAttributeMappingEnabled) {
        this.oAuthAttributeMappingEnabled = oAuthAttributeMappingEnabled;
    }

    public boolean isOAuthGloballyEnabled() {
        return MgmtFactory.getAuthzServerManager().isEnableOAuth();
    }

    public boolean isConnectionProtocol20() {
        return ((ConnectionTasklet)this.getParent()).isConnectionProtocol20();
    }

    public boolean isAttributeQueryCheckboxEnabled() {
        return this.attributeQueryCheckboxEnabled;
    }

    public boolean isIdpDiscoveryEnabled() {
        return this.idpDiscoveryEnabled;
    }

    public void setIdpDiscoveryEnabled(boolean idpDiscoveryEnabled) {
        this.idpDiscoveryEnabled = idpDiscoveryEnabled;
    }

    public boolean isIdpDiscoveryCheckboxEnabled() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        IdpDiscovery idpDiscovery = localSettings.getIdpDiscovery();
        return this.browserSsoEnabled && this.isConnectionProtocol20() && localSettings.isEnableIdpDiscovery() && idpDiscovery != null && idpDiscovery.isIdpCommonDomainClient();
    }
}

